/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pipelineexecutor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.ISubPipelineAwareMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutor;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorData;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorParameters;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.w3c.dom.Node;

@Transform(id="PipelineExecutor", image="ui/images/pipelineexecutor.svg", name="i18n::PipelineExecutor.Name", description="i18n::PipelineExecutor.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", documentationUrl="/pipeline/transforms/pipeline-executor.html", keywords={"i18n::PipelineExecutorMeta.keyword"})
public class PipelineExecutorMeta
extends TransformWithMappingMeta<PipelineExecutor, PipelineExecutorData>
implements ISubPipelineAwareMeta {
    private static final Class<?> PKG = PipelineExecutorMeta.class;
    static final String F_EXECUTION_RESULT_TARGET_TRANSFORM = "execution_result_target_transform";
    static final String F_RESULT_FILE_TARGET_TRANSFORM = "result_files_target_transform";
    static final String F_EXECUTOR_OUTPUT_TRANSFORM = "executors_output_transform";
    public static final String CONST_RESULT_ROWS_FIELD = "result_rows_field";
    private String runConfigurationName;
    private boolean filenameInField;
    private String filenameField;
    private String groupSize;
    private String groupField;
    private String groupTime;
    private PipelineExecutorParameters parameters = new PipelineExecutorParameters();
    private String executionResultTargetTransform;
    private TransformMeta executionResultTargetTransformMeta;
    private String executionTimeField;
    private String executionResultField;
    private String executionNrErrorsField;
    private String executionLinesReadField;
    private String executionLinesWrittenField;
    private String executionLinesInputField;
    private String executionLinesOutputField;
    private String executionLinesRejectedField;
    private String executionLinesUpdatedField;
    private String executionLinesDeletedField;
    private String executionFilesRetrievedField;
    private String executionExitStatusField;
    private String executionLogTextField;
    private String executionLogChannelIdField;
    private String outputRowsSourceTransform;
    private TransformMeta outputRowsSourceTransformMeta;
    private String[] outputRowsField;
    private int[] outputRowsType;
    private int[] outputRowsLength;
    private int[] outputRowsPrecision;
    private String resultFilesTargetTransform;
    private TransformMeta resultFilesTargetTransformMeta;
    private String resultFilesFileNameField;
    private String executorsOutputTransform;
    private TransformMeta executorsOutputTransformMeta;
    private IHopMetadataProvider metadataProvider;

    public PipelineExecutorMeta() {
        this.allocate(0);
    }

    public void allocate(int nrFields) {
        this.outputRowsField = new String[nrFields];
        this.outputRowsType = new int[nrFields];
        this.outputRowsLength = new int[nrFields];
        this.outputRowsPrecision = new int[nrFields];
    }

    public Object clone() {
        PipelineExecutorMeta retval = (PipelineExecutorMeta)((Object)super.clone());
        int nrFields = this.outputRowsField.length;
        retval.allocate(nrFields);
        System.arraycopy(this.outputRowsField, 0, retval.outputRowsField, 0, nrFields);
        System.arraycopy(this.outputRowsType, 0, retval.outputRowsType, 0, nrFields);
        System.arraycopy(this.outputRowsLength, 0, retval.outputRowsLength, 0, nrFields);
        System.arraycopy(this.outputRowsPrecision, 0, retval.outputRowsPrecision, 0, nrFields);
        return retval;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XmlHandler.addTagValue((String)"run_configuration", (String)this.runConfigurationName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filenameInField", (boolean)this.filenameInField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filenameField", (String)this.filenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"group_size", (String)this.groupSize));
        retval.append("    ").append(XmlHandler.addTagValue((String)"group_field", (String)this.groupField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"group_time", (String)this.groupTime));
        retval.append("      ").append(this.parameters.getXml()).append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)F_EXECUTION_RESULT_TARGET_TRANSFORM, this.executionResultTargetTransformMeta == null ? null : this.executionResultTargetTransformMeta.getName()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_time_field", (String)this.executionTimeField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_result_field", (String)this.executionResultField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_errors_field", (String)this.executionNrErrorsField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_read_field", (String)this.executionLinesReadField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_written_field", (String)this.executionLinesWrittenField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_input_field", (String)this.executionLinesInputField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_output_field", (String)this.executionLinesOutputField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_rejected_field", (String)this.executionLinesRejectedField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_updated_field", (String)this.executionLinesUpdatedField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_deleted_field", (String)this.executionLinesDeletedField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_files_retrieved_field", (String)this.executionFilesRetrievedField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_exit_status_field", (String)this.executionExitStatusField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_log_text_field", (String)this.executionLogTextField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_log_channelid_field", (String)this.executionLogChannelIdField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"result_rows_target_transform", this.outputRowsSourceTransformMeta == null ? null : this.outputRowsSourceTransformMeta.getName()));
        for (int i = 0; i < this.outputRowsField.length; ++i) {
            retval.append("      ").append(XmlHandler.openTag((String)CONST_RESULT_ROWS_FIELD));
            retval.append(XmlHandler.addTagValue((String)"name", (String)this.outputRowsField[i], (boolean)false, (String[])new String[0]));
            retval.append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.outputRowsType[i]), (boolean)false, (String[])new String[0]));
            retval.append(XmlHandler.addTagValue((String)"length", (int)this.outputRowsLength[i], (boolean)false));
            retval.append(XmlHandler.addTagValue((String)"precision", (int)this.outputRowsPrecision[i], (boolean)false));
            retval.append(XmlHandler.closeTag((String)CONST_RESULT_ROWS_FIELD)).append(Const.CR);
        }
        retval.append("    ").append(XmlHandler.addTagValue((String)F_RESULT_FILE_TARGET_TRANSFORM, this.resultFilesTargetTransformMeta == null ? null : this.resultFilesTargetTransformMeta.getName()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"result_files_file_name_field", (String)this.resultFilesFileNameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)F_EXECUTOR_OUTPUT_TRANSFORM, this.executorsOutputTransformMeta == null ? null : this.executorsOutputTransformMeta.getName()));
        return retval.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.runConfigurationName = XmlHandler.getTagValue((Node)transformNode, (String)"run_configuration");
            this.filename = XmlHandler.getTagValue((Node)transformNode, (String)"filename");
            this.filenameInField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"filenameInField"));
            this.filenameField = XmlHandler.getTagValue((Node)transformNode, (String)"filenameField");
            this.groupSize = XmlHandler.getTagValue((Node)transformNode, (String)"group_size");
            this.groupField = XmlHandler.getTagValue((Node)transformNode, (String)"group_field");
            this.groupTime = XmlHandler.getTagValue((Node)transformNode, (String)"group_time");
            Node mappingParametersNode = XmlHandler.getSubNode((Node)transformNode, (String)"parameters");
            this.parameters = new PipelineExecutorParameters(mappingParametersNode);
            this.executionResultTargetTransform = XmlHandler.getTagValue((Node)transformNode, (String)F_EXECUTION_RESULT_TARGET_TRANSFORM);
            this.executionTimeField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_time_field");
            this.executionResultField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_result_field");
            this.executionNrErrorsField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_errors_field");
            this.executionLinesReadField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_read_field");
            this.executionLinesWrittenField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_written_field");
            this.executionLinesInputField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_input_field");
            this.executionLinesOutputField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_output_field");
            this.executionLinesRejectedField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_rejected_field");
            this.executionLinesUpdatedField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_updated_field");
            this.executionLinesDeletedField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_deleted_field");
            this.executionFilesRetrievedField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_files_retrieved_field");
            this.executionExitStatusField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_exit_status_field");
            this.executionLogTextField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_log_text_field");
            this.executionLogChannelIdField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_log_channelid_field");
            this.outputRowsSourceTransform = XmlHandler.getTagValue((Node)transformNode, (String)"result_rows_target_transform");
            int nrFields = XmlHandler.countNodes((Node)transformNode, (String)CONST_RESULT_ROWS_FIELD);
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fieldNode = XmlHandler.getSubNodeByNr((Node)transformNode, (String)CONST_RESULT_ROWS_FIELD, (int)i);
                this.outputRowsField[i] = XmlHandler.getTagValue((Node)fieldNode, (String)"name");
                this.outputRowsType[i] = ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fieldNode, (String)"type"));
                this.outputRowsLength[i] = Const.toInt((String)XmlHandler.getTagValue((Node)fieldNode, (String)"length"), (int)-1);
                this.outputRowsPrecision[i] = Const.toInt((String)XmlHandler.getTagValue((Node)fieldNode, (String)"precision"), (int)-1);
            }
            this.resultFilesTargetTransform = XmlHandler.getTagValue((Node)transformNode, (String)F_RESULT_FILE_TARGET_TRANSFORM);
            this.resultFilesFileNameField = XmlHandler.getTagValue((Node)transformNode, (String)"result_files_file_name_field");
            this.executorsOutputTransform = XmlHandler.getTagValue((Node)transformNode, (String)F_EXECUTOR_OUTPUT_TRANSFORM);
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.Exception.ErrorLoadingPipelineExecutorDetailsFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.parameters = new PipelineExecutorParameters();
        this.parameters.setInheritingAllVariables(true);
        this.filenameInField = false;
        this.groupSize = "1";
        this.groupField = "";
        this.groupTime = "";
        this.executionTimeField = "ExecutionTime";
        this.executionResultField = "ExecutionResult";
        this.executionNrErrorsField = "ExecutionNrErrors";
        this.executionLinesReadField = "ExecutionLinesRead";
        this.executionLinesWrittenField = "ExecutionLinesWritten";
        this.executionLinesInputField = "ExecutionLinesInput";
        this.executionLinesOutputField = "ExecutionLinesOutput";
        this.executionLinesRejectedField = "ExecutionLinesRejected";
        this.executionLinesUpdatedField = "ExecutionLinesUpdated";
        this.executionLinesDeletedField = "ExecutionLinesDeleted";
        this.executionFilesRetrievedField = "ExecutionFilesRetrieved";
        this.executionExitStatusField = "ExecutionExitStatus";
        this.executionLogTextField = "ExecutionLogText";
        this.executionLogChannelIdField = "ExecutionLogChannelId";
        this.resultFilesFileNameField = "FileName";
    }

    void prepareExecutionResultsFields(IRowMeta row, TransformMeta nextTransform) throws HopTransformException {
        if (nextTransform != null && this.executionResultTargetTransformMeta != null) {
            this.addFieldToRow(row, this.executionTimeField, 5, 15, 0);
            this.addFieldToRow(row, this.executionResultField, 4);
            this.addFieldToRow(row, this.executionNrErrorsField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesReadField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesWrittenField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesInputField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesOutputField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesRejectedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesUpdatedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesDeletedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionFilesRetrievedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionExitStatusField, 5, 3, 0);
            this.addFieldToRow(row, this.executionLogTextField, 2);
            this.addFieldToRow(row, this.executionLogChannelIdField, 2, 50, 0);
        }
    }

    protected void addFieldToRow(IRowMeta row, String fieldName, int type) throws HopTransformException {
        this.addFieldToRow(row, fieldName, type, -1, -1);
    }

    protected void addFieldToRow(IRowMeta row, String fieldName, int type, int length, int precision) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)fieldName)) {
            try {
                IValueMeta value = ValueMetaFactory.createValueMeta((String)fieldName, (int)type, (int)length, (int)precision);
                value.setOrigin(this.getParentTransformMeta().getName());
                row.addValueMeta(value);
            }
            catch (HopPluginException e) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ValueMetaInterfaceCreation", (String[])new String[]{fieldName}), (Throwable)e);
            }
        }
    }

    void prepareExecutionResultsFileFields(IRowMeta row, TransformMeta nextTransform) throws HopTransformException {
        if (nextTransform != null && this.resultFilesTargetTransformMeta != null && nextTransform.equals((Object)this.resultFilesTargetTransformMeta)) {
            this.addFieldToRow(row, this.resultFilesFileNameField, 2);
        }
    }

    void prepareResultsRowsFields(IRowMeta row) throws HopTransformException {
        for (int i = 0; i < this.outputRowsField.length; ++i) {
            this.addFieldToRow(row, this.outputRowsField[i], this.outputRowsType[i], this.outputRowsLength[i], this.outputRowsPrecision[i]);
        }
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (nextTransform != null) {
            if (nextTransform.equals((Object)this.executionResultTargetTransformMeta)) {
                inputRowMeta.clear();
                this.prepareExecutionResultsFields(inputRowMeta, nextTransform);
            } else if (nextTransform.equals((Object)this.resultFilesTargetTransformMeta)) {
                inputRowMeta.clear();
                this.prepareExecutionResultsFileFields(inputRowMeta, nextTransform);
            } else if (nextTransform.equals((Object)this.outputRowsSourceTransformMeta)) {
                inputRowMeta.clear();
                this.prepareResultsRowsFields(inputRowMeta);
            }
        }
    }

    public String[] getInfoTransforms() {
        String[] infoTransforms = this.getTransformIOMeta().getInfoTransformNames();
        return infoTransforms.length == 0 ? null : infoTransforms;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.CheckResult.NotReceivingAnyFields", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.CheckResult.TransformReceivingFieldsFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = variables.resolve(this.filename);
        ResourceReference reference = new ResourceReference((IResourceHolder)transformMeta);
        if (StringUtils.isNotEmpty((String)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        }
        references.add(reference);
        return references;
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, true, false, true, false);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.executionResultTargetTransformMeta, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ResultStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.outputRowsSourceTransformMeta, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ResultRowsStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.resultFilesTargetTransformMeta, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ResultFilesStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.executorsOutputTransformMeta, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ExecutorOutputStream.Description", (String[])new String[0]), StreamIcon.OUTPUT, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void handleStreamSelection(IStream stream) {
        List targets = this.getTransformIOMeta().getTargetStreams();
        int index = targets.indexOf(stream);
        TransformMeta transform = ((IStream)targets.get(index)).getTransformMeta();
        switch (index) {
            case 0: {
                this.setExecutionResultTargetTransformMeta(transform);
                break;
            }
            case 1: {
                this.setOutputRowsSourceTransformMeta(transform);
                break;
            }
            case 2: {
                this.setResultFilesTargetTransformMeta(transform);
                break;
            }
            case 3: {
                this.setExecutorsOutputTransformMeta(transform);
            }
        }
    }

    public void resetTransformIoMeta() {
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        this.executionResultTargetTransformMeta = TransformMeta.findTransform(transforms, (String)this.executionResultTargetTransform);
        this.outputRowsSourceTransformMeta = TransformMeta.findTransform(transforms, (String)this.outputRowsSourceTransform);
        this.resultFilesTargetTransformMeta = TransformMeta.findTransform(transforms, (String)this.resultFilesTargetTransform);
        this.executorsOutputTransformMeta = TransformMeta.findTransform(transforms, (String)this.executorsOutputTransform);
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    public PipelineExecutorParameters getMappingParameters() {
        return this.parameters;
    }

    public void setMappingParameters(PipelineExecutorParameters mappingParameters) {
        this.parameters = mappingParameters;
    }

    public PipelineExecutorParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(PipelineExecutorParameters parameters) {
        this.parameters = parameters;
    }

    public String getExecutionTimeField() {
        return this.executionTimeField;
    }

    public void setExecutionTimeField(String executionTimeField) {
        this.executionTimeField = executionTimeField;
    }

    public String getExecutionResultField() {
        return this.executionResultField;
    }

    public void setExecutionResultField(String executionResultField) {
        this.executionResultField = executionResultField;
    }

    public String getExecutionNrErrorsField() {
        return this.executionNrErrorsField;
    }

    public void setExecutionNrErrorsField(String executionNrErrorsField) {
        this.executionNrErrorsField = executionNrErrorsField;
    }

    public String getExecutionLinesReadField() {
        return this.executionLinesReadField;
    }

    public void setExecutionLinesReadField(String executionLinesReadField) {
        this.executionLinesReadField = executionLinesReadField;
    }

    public String getExecutionLinesWrittenField() {
        return this.executionLinesWrittenField;
    }

    public void setExecutionLinesWrittenField(String executionLinesWrittenField) {
        this.executionLinesWrittenField = executionLinesWrittenField;
    }

    public String getExecutionLinesInputField() {
        return this.executionLinesInputField;
    }

    public void setExecutionLinesInputField(String executionLinesInputField) {
        this.executionLinesInputField = executionLinesInputField;
    }

    public String getExecutionLinesOutputField() {
        return this.executionLinesOutputField;
    }

    public void setExecutionLinesOutputField(String executionLinesOutputField) {
        this.executionLinesOutputField = executionLinesOutputField;
    }

    public String getExecutionLinesRejectedField() {
        return this.executionLinesRejectedField;
    }

    public void setExecutionLinesRejectedField(String executionLinesRejectedField) {
        this.executionLinesRejectedField = executionLinesRejectedField;
    }

    public String getExecutionLinesUpdatedField() {
        return this.executionLinesUpdatedField;
    }

    public void setExecutionLinesUpdatedField(String executionLinesUpdatedField) {
        this.executionLinesUpdatedField = executionLinesUpdatedField;
    }

    public String getExecutionLinesDeletedField() {
        return this.executionLinesDeletedField;
    }

    public void setExecutionLinesDeletedField(String executionLinesDeletedField) {
        this.executionLinesDeletedField = executionLinesDeletedField;
    }

    public String getExecutionFilesRetrievedField() {
        return this.executionFilesRetrievedField;
    }

    public void setExecutionFilesRetrievedField(String executionFilesRetrievedField) {
        this.executionFilesRetrievedField = executionFilesRetrievedField;
    }

    public String getExecutionExitStatusField() {
        return this.executionExitStatusField;
    }

    public void setExecutionExitStatusField(String executionExitStatusField) {
        this.executionExitStatusField = executionExitStatusField;
    }

    public String getExecutionLogTextField() {
        return this.executionLogTextField;
    }

    public void setExecutionLogTextField(String executionLogTextField) {
        this.executionLogTextField = executionLogTextField;
    }

    public String getExecutionLogChannelIdField() {
        return this.executionLogChannelIdField;
    }

    public void setExecutionLogChannelIdField(String executionLogChannelIdField) {
        this.executionLogChannelIdField = executionLogChannelIdField;
    }

    public String getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(String groupSize) {
        this.groupSize = groupSize;
    }

    public String getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String groupField) {
        this.groupField = groupField;
    }

    public String getGroupTime() {
        return this.groupTime;
    }

    public void setGroupTime(String groupTime) {
        this.groupTime = groupTime;
    }

    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public String getExecutionResultTargetTransform() {
        return this.executionResultTargetTransform;
    }

    public void setExecutionResultTargetTransform(String executionResultTargetTransform) {
        this.executionResultTargetTransform = executionResultTargetTransform;
    }

    public TransformMeta getExecutionResultTargetTransformMeta() {
        return this.executionResultTargetTransformMeta;
    }

    public void setExecutionResultTargetTransformMeta(TransformMeta executionResultTargetTransformMeta) {
        this.executionResultTargetTransformMeta = executionResultTargetTransformMeta;
    }

    public String getResultFilesFileNameField() {
        return this.resultFilesFileNameField;
    }

    public void setResultFilesFileNameField(String resultFilesFileNameField) {
        this.resultFilesFileNameField = resultFilesFileNameField;
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isPipelineDefined() {
        return StringUtils.isNotEmpty((String)this.filename);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isPipelineDefined()};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return PipelineExecutorMeta.loadMappingMeta((TransformWithMappingMeta)this, (IHopMetadataProvider)metadataProvider, (IVariables)variables);
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public String getOutputRowsSourceTransform() {
        return this.outputRowsSourceTransform;
    }

    public void setOutputRowsSourceTransform(String outputRowsSourceTransform) {
        this.outputRowsSourceTransform = outputRowsSourceTransform;
    }

    public TransformMeta getOutputRowsSourceTransformMeta() {
        return this.outputRowsSourceTransformMeta;
    }

    public void setOutputRowsSourceTransformMeta(TransformMeta outputRowsSourceTransformMeta) {
        this.outputRowsSourceTransformMeta = outputRowsSourceTransformMeta;
    }

    public String[] getOutputRowsField() {
        return this.outputRowsField;
    }

    public void setOutputRowsField(String[] outputRowsField) {
        this.outputRowsField = outputRowsField;
    }

    public int[] getOutputRowsType() {
        return this.outputRowsType;
    }

    public void setOutputRowsType(int[] outputRowsType) {
        this.outputRowsType = outputRowsType;
    }

    public int[] getOutputRowsLength() {
        return this.outputRowsLength;
    }

    public void setOutputRowsLength(int[] outputRowsLength) {
        this.outputRowsLength = outputRowsLength;
    }

    public int[] getOutputRowsPrecision() {
        return this.outputRowsPrecision;
    }

    public void setOutputRowsPrecision(int[] outputRowsPrecision) {
        this.outputRowsPrecision = outputRowsPrecision;
    }

    public String getResultFilesTargetTransform() {
        return this.resultFilesTargetTransform;
    }

    public void setResultFilesTargetTransform(String resultFilesTargetTransform) {
        this.resultFilesTargetTransform = resultFilesTargetTransform;
    }

    public TransformMeta getResultFilesTargetTransformMeta() {
        return this.resultFilesTargetTransformMeta;
    }

    public void setResultFilesTargetTransformMeta(TransformMeta resultFilesTargetTransformMeta) {
        this.resultFilesTargetTransformMeta = resultFilesTargetTransformMeta;
    }

    public String getExecutorsOutputTransform() {
        return this.executorsOutputTransform;
    }

    public void setExecutorsOutputTransform(String executorsOutputTransform) {
        this.executorsOutputTransform = executorsOutputTransform;
    }

    public TransformMeta getExecutorsOutputTransformMeta() {
        return this.executorsOutputTransformMeta;
    }

    public void setExecutorsOutputTransformMeta(TransformMeta executorsOutputTransformMeta) {
        this.executorsOutputTransformMeta = executorsOutputTransformMeta;
    }

    public boolean cleanAfterHopFromRemove() {
        this.setExecutionResultTargetTransformMeta(null);
        this.setOutputRowsSourceTransformMeta(null);
        this.setResultFilesTargetTransformMeta(null);
        this.setExecutorsOutputTransformMeta(null);
        return true;
    }

    public boolean cleanAfterHopFromRemove(TransformMeta toTransform) {
        if (null == toTransform || null == toTransform.getName()) {
            return false;
        }
        boolean hasChanged = false;
        String toTransformName = toTransform.getName();
        if (this.getExecutionResultTargetTransformMeta() != null && toTransformName.equals(this.getExecutionResultTargetTransformMeta().getName())) {
            this.setExecutionResultTargetTransformMeta(null);
            hasChanged = true;
        } else if (this.getOutputRowsSourceTransformMeta() != null && toTransformName.equals(this.getOutputRowsSourceTransformMeta().getName())) {
            this.setOutputRowsSourceTransformMeta(null);
            hasChanged = true;
        } else if (this.getResultFilesTargetTransformMeta() != null && toTransformName.equals(this.getResultFilesTargetTransformMeta().getName())) {
            this.setResultFilesTargetTransformMeta(null);
            hasChanged = true;
        } else if (this.getExecutorsOutputTransformMeta() != null && toTransformName.equals(this.getExecutorsOutputTransformMeta().getName())) {
            this.setExecutorsOutputTransformMeta(null);
            hasChanged = true;
        }
        return hasChanged;
    }

    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    public boolean isFilenameInField() {
        return this.filenameInField;
    }

    public void setFilenameInField(boolean filenameInField) {
        this.filenameInField = filenameInField;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }
}

