/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.yamlinput;

import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.yamlinput.YamlInputField;
import org.apache.hop.pipeline.transforms.yamlinput.YamlInputMeta;
import org.apache.hop.pipeline.transforms.yamlinput.YamlReader;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class YamlInputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = YamlInputMeta.class;
    public static final String CONST_YAML_INPUT_DIALOG_ERROR_PARSING_DATA_DIALOG_TITLE = "YamlInputDialog.ErrorParsingData.DialogTitle";
    public static final String CONST_YAML_INPUT_DIALOG_ERROR_PARSING_DATA_DIALOG_MESSAGE = "YamlInputDialog.ErrorParsingData.DialogMessage";
    private Label wlFilename;
    private Label wlYamlIsAFile;
    private Button wbbFilename;
    private Button wbdFilename;
    private Button wbeFilename;
    private Button wbaFilename;
    private TextVar wFilename;
    private Label wlFilenameList;
    private TableView wFilenameList;
    private Label wlFilemask;
    private TextVar wFilemask;
    private Button wbShowFiles;
    private Label wlYamlField;
    private CCombo wYAMLLField;
    private Button wYAMLStreamField;
    private Button wYAMLIsAFile;
    private Label wlInclFilename;
    private Button wInclFilename;
    private Button wAddResult;
    private Label wlInclFilenameField;
    private TextVar wInclFilenameField;
    private Label wlAddResult;
    private Button wInclRownum;
    private Label wlInclRownumField;
    private TextVar wInclRownumField;
    private Label wlLimit;
    private Text wLimit;
    private TableView wFields;
    private Label wlIgnoreEmptyFile;
    private Button wIgnoreEmptyFile;
    private Label wlDoNotFailIfNoFile;
    private Button wDoNotFailIfNoFile;
    private YamlInputMeta input;
    public static final int[] dateLengths = new int[]{23, 19, 14, 10, 10, 10, 10, 8, 8, 8, 8, 6, 6};
    ArrayList<String> listpath = new ArrayList();
    String precNodeName = null;

    public YamlInputDialog(Shell parent, IVariables variables, YamlInputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wFileTab = new CTabItem(wTabFolder, 0);
        wFileTab.setFont(GuiResource.getInstance().getFontDefault());
        wFileTab.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.File.Tab", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        Group wOutputField = new Group(wFileComp, 32);
        PropsUi.setLook((Widget)wOutputField);
        wOutputField.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.wOutputField.Label", (String[])new String[0]));
        FormLayout outputfieldgroupLayout = new FormLayout();
        outputfieldgroupLayout.marginWidth = 10;
        outputfieldgroupLayout.marginHeight = 10;
        wOutputField.setLayout((Layout)outputfieldgroupLayout);
        Label wlXmlStreamField = new Label((Composite)wOutputField, 131072);
        wlXmlStreamField.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.wlXmlStreamField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlXmlStreamField);
        FormData fdlXMLStreamField = new FormData();
        fdlXMLStreamField.left = new FormAttachment(0, -margin);
        fdlXMLStreamField.top = new FormAttachment(0, margin);
        fdlXMLStreamField.right = new FormAttachment(middle, -2 * margin);
        wlXmlStreamField.setLayoutData((Object)fdlXMLStreamField);
        this.wYAMLStreamField = new Button((Composite)wOutputField, 32);
        PropsUi.setLook((Widget)this.wYAMLStreamField);
        this.wYAMLStreamField.setToolTipText(BaseMessages.getString(PKG, (String)"YamlInputDialog.wYAMLStreamField.Tooltip", (String[])new String[0]));
        FormData fdYAMLStreamField = new FormData();
        fdYAMLStreamField.left = new FormAttachment(middle, -margin);
        fdYAMLStreamField.top = new FormAttachment((Control)wlXmlStreamField, 0, 0x1000000);
        this.wYAMLStreamField.setLayoutData((Object)fdYAMLStreamField);
        SelectionAdapter lsyamlstream = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                YamlInputDialog.this.activateStreamField();
                YamlInputDialog.this.input.setChanged();
            }
        };
        this.wYAMLStreamField.addSelectionListener((SelectionListener)lsyamlstream);
        this.wlYamlIsAFile = new Label((Composite)wOutputField, 131072);
        this.wlYamlIsAFile.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.XMLIsAFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlYamlIsAFile);
        FormData fdlXMLIsAFile = new FormData();
        fdlXMLIsAFile.left = new FormAttachment(0, -margin);
        fdlXMLIsAFile.top = new FormAttachment((Control)this.wYAMLStreamField, margin);
        fdlXMLIsAFile.right = new FormAttachment(middle, -2 * margin);
        this.wlYamlIsAFile.setLayoutData((Object)fdlXMLIsAFile);
        this.wYAMLIsAFile = new Button((Composite)wOutputField, 32);
        PropsUi.setLook((Widget)this.wYAMLIsAFile);
        this.wYAMLIsAFile.setToolTipText(BaseMessages.getString(PKG, (String)"YamlInputDialog.XMLIsAFile.Tooltip", (String[])new String[0]));
        FormData fdYAMLIsAFile = new FormData();
        fdYAMLIsAFile.left = new FormAttachment(middle, -margin);
        fdYAMLIsAFile.top = new FormAttachment((Control)this.wlYamlIsAFile, 0, 0x1000000);
        this.wYAMLIsAFile.setLayoutData((Object)fdYAMLIsAFile);
        SelectionAdapter lsyamlisafile = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                YamlInputDialog.this.input.setChanged();
                YamlInputDialog.this.enableFileSettings();
            }
        };
        this.wYAMLIsAFile.addSelectionListener((SelectionListener)lsyamlisafile);
        this.wlYamlField = new Label((Composite)wOutputField, 131072);
        this.wlYamlField.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.wlYamlField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlYamlField);
        FormData fdlXMLField = new FormData();
        fdlXMLField.left = new FormAttachment(0, -margin);
        fdlXMLField.top = new FormAttachment((Control)this.wYAMLIsAFile, margin);
        fdlXMLField.right = new FormAttachment(middle, -2 * margin);
        this.wlYamlField.setLayoutData((Object)fdlXMLField);
        this.wYAMLLField = new CCombo((Composite)wOutputField, 2056);
        this.wYAMLLField.setEditable(true);
        PropsUi.setLook((Widget)this.wYAMLLField);
        this.wYAMLLField.addModifyListener(lsMod);
        FormData fdXMLField = new FormData();
        fdXMLField.left = new FormAttachment(middle, -margin);
        fdXMLField.top = new FormAttachment((Control)this.wYAMLIsAFile, margin);
        fdXMLField.right = new FormAttachment(100, -margin);
        this.wYAMLLField.setLayoutData((Object)fdXMLField);
        this.wYAMLLField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)YamlInputDialog.this.shell.getDisplay(), 1);
                YamlInputDialog.this.shell.setCursor(busy);
                YamlInputDialog.this.setXMLStreamField();
                YamlInputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        FormData fdOutputField = new FormData();
        fdOutputField.left = new FormAttachment(0, margin);
        fdOutputField.top = new FormAttachment((Control)this.wFilenameList, margin);
        fdOutputField.right = new FormAttachment(100, -margin);
        wOutputField.setLayoutData((Object)fdOutputField);
        this.wlFilename = new Label(wFileComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)wOutputField, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbbFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.FilenameBrowse.Button", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)wOutputField, margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbaFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbaFilename);
        this.wbaFilename.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.FilenameAdd.Button", (String[])new String[0]));
        this.wbaFilename.setToolTipText(BaseMessages.getString(PKG, (String)"YamlInputDialog.FilenameAdd.Tooltip", (String[])new String[0]));
        FormData fdbaFilename = new FormData();
        fdbaFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
        fdbaFilename.top = new FormAttachment((Control)wOutputField, margin);
        this.wbaFilename.setLayoutData((Object)fdbaFilename);
        this.wFilename = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.right = new FormAttachment((Control)this.wbaFilename, -margin);
        fdFilename.top = new FormAttachment((Control)wOutputField, margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wlFilemask = new Label(wFileComp, 131072);
        this.wlFilemask.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.RegExp.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilemask);
        FormData fdlFilemask = new FormData();
        fdlFilemask.left = new FormAttachment(0, 0);
        fdlFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        fdlFilemask.right = new FormAttachment(middle, -margin);
        this.wlFilemask.setLayoutData((Object)fdlFilemask);
        this.wFilemask = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilemask);
        this.wFilemask.addModifyListener(lsMod);
        FormData fdFilemask = new FormData();
        fdFilemask.left = new FormAttachment(middle, 0);
        fdFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        fdFilemask.right = new FormAttachment(100, 0);
        this.wFilemask.setLayoutData((Object)fdFilemask);
        this.wlFilenameList = new Label(wFileComp, 131072);
        this.wlFilenameList.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.FilenameList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameList);
        FormData fdlFilenameList = new FormData();
        fdlFilenameList.left = new FormAttachment(0, 0);
        fdlFilenameList.top = new FormAttachment((Control)this.wFilemask, margin);
        fdlFilenameList.right = new FormAttachment(middle, -margin);
        this.wlFilenameList.setLayoutData((Object)fdlFilenameList);
        this.wbdFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbdFilename);
        this.wbdFilename.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.FilenameRemove.Button", (String[])new String[0]));
        this.wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"YamlInputDialog.FilenameRemove.Tooltip", (String[])new String[0]));
        FormData fdbdFilename = new FormData();
        fdbdFilename.right = new FormAttachment(100, 0);
        fdbdFilename.top = new FormAttachment((Control)this.wFilemask, 40);
        this.wbdFilename.setLayoutData((Object)fdbdFilename);
        this.wbeFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbeFilename);
        this.wbeFilename.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.FilenameEdit.Button", (String[])new String[0]));
        this.wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"YamlInputDialog.FilenameEdit.Tooltip", (String[])new String[0]));
        FormData fdbeFilename = new FormData();
        fdbeFilename.right = new FormAttachment(100, 0);
        fdbeFilename.left = new FormAttachment((Control)this.wbdFilename, 0, 16384);
        fdbeFilename.top = new FormAttachment((Control)this.wbdFilename, margin);
        this.wbeFilename.setLayoutData((Object)fdbeFilename);
        this.wbShowFiles = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(middle, 0);
        fdbShowFiles.bottom = new FormAttachment(100, 0);
        this.wbShowFiles.setLayoutData((Object)fdbShowFiles);
        ColumnInfo[] colinfo = new ColumnInfo[4];
        colinfo[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.Files.Filename.Column", (String[])new String[0]), 1, false);
        colinfo[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.Files.Wildcard.Column", (String[])new String[0]), 1, false);
        colinfo[0].setUsingVariables(true);
        colinfo[1].setUsingVariables(true);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"YamlInputDialog.Files.Wildcard.Tooltip", (String[])new String[0]));
        colinfo[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.Required.Column", (String[])new String[0]), 2, YamlInputMeta.RequiredFilesDesc);
        colinfo[2].setToolTip(BaseMessages.getString(PKG, (String)"YamlInputDialog.Required.Tooltip", (String[])new String[0]));
        colinfo[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.IncludeSubDirs.Column", (String[])new String[0]), 2, YamlInputMeta.RequiredFilesDesc);
        colinfo[3].setToolTip(BaseMessages.getString(PKG, (String)"YamlInputDialog.IncludeSubDirs.Tooltip", (String[])new String[0]));
        this.wFilenameList = new TableView(this.variables, wFileComp, 67588, colinfo, 2, lsMod, this.props);
        PropsUi.setLook((Widget)this.wFilenameList);
        FormData fdFilenameList = new FormData();
        fdFilenameList.left = new FormAttachment(middle, 0);
        fdFilenameList.right = new FormAttachment((Control)this.wbdFilename, -margin);
        fdFilenameList.top = new FormAttachment((Control)this.wFilemask, margin);
        fdFilenameList.bottom = new FormAttachment((Control)this.wbShowFiles, -margin);
        this.wFilenameList.setLayoutData((Object)fdFilenameList);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)fdFileComp);
        wFileComp.layout();
        wFileTab.setControl((Control)wFileComp);
        CTabItem wContentTab = new CTabItem(wTabFolder, 0);
        wContentTab.setFont(GuiResource.getInstance().getFontDefault());
        wContentTab.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.Content.Tab", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Group wXmlConf = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wXmlConf);
        wXmlConf.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.wXmlConf.Label", (String[])new String[0]));
        FormLayout xmlConfgroupLayout = new FormLayout();
        xmlConfgroupLayout.marginWidth = 10;
        xmlConfgroupLayout.marginHeight = 10;
        wXmlConf.setLayout((Layout)xmlConfgroupLayout);
        this.wlIgnoreEmptyFile = new Label((Composite)wXmlConf, 131072);
        this.wlIgnoreEmptyFile.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.IgnoreEmptyFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlIgnoreEmptyFile);
        FormData fdlIgnoreEmptyFile = new FormData();
        fdlIgnoreEmptyFile.left = new FormAttachment(0, 0);
        fdlIgnoreEmptyFile.top = new FormAttachment(0, margin);
        fdlIgnoreEmptyFile.right = new FormAttachment(middle, -margin);
        this.wlIgnoreEmptyFile.setLayoutData((Object)fdlIgnoreEmptyFile);
        this.wIgnoreEmptyFile = new Button((Composite)wXmlConf, 32);
        PropsUi.setLook((Widget)this.wIgnoreEmptyFile);
        this.wIgnoreEmptyFile.setToolTipText(BaseMessages.getString(PKG, (String)"YamlInputDialog.IgnoreEmptyFile.Tooltip", (String[])new String[0]));
        FormData fdIgnoreEmptyFile = new FormData();
        fdIgnoreEmptyFile.left = new FormAttachment(middle, 0);
        fdIgnoreEmptyFile.top = new FormAttachment((Control)this.wlIgnoreEmptyFile, 0, 0x1000000);
        this.wIgnoreEmptyFile.setLayoutData((Object)fdIgnoreEmptyFile);
        this.wIgnoreEmptyFile.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        this.wlDoNotFailIfNoFile = new Label((Composite)wXmlConf, 131072);
        this.wlDoNotFailIfNoFile.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.doNotFailIfNoFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlDoNotFailIfNoFile);
        FormData fdlDoNotFailIfNoFile = new FormData();
        fdlDoNotFailIfNoFile.left = new FormAttachment(0, 0);
        fdlDoNotFailIfNoFile.top = new FormAttachment((Control)this.wIgnoreEmptyFile, margin);
        fdlDoNotFailIfNoFile.right = new FormAttachment(middle, -margin);
        this.wlDoNotFailIfNoFile.setLayoutData((Object)fdlDoNotFailIfNoFile);
        this.wDoNotFailIfNoFile = new Button((Composite)wXmlConf, 32);
        PropsUi.setLook((Widget)this.wDoNotFailIfNoFile);
        this.wDoNotFailIfNoFile.setToolTipText(BaseMessages.getString(PKG, (String)"YamlInputDialog.doNotFailIfNoFile.Tooltip", (String[])new String[0]));
        FormData fdDoNotFailIfNoFile = new FormData();
        fdDoNotFailIfNoFile.left = new FormAttachment(middle, 0);
        fdDoNotFailIfNoFile.top = new FormAttachment((Control)this.wlDoNotFailIfNoFile, 0, 0x1000000);
        this.wDoNotFailIfNoFile.setLayoutData((Object)fdDoNotFailIfNoFile);
        this.wDoNotFailIfNoFile.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        this.wlLimit = new Label((Composite)wXmlConf, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.top = new FormAttachment((Control)this.wDoNotFailIfNoFile, margin);
        fdlLimit.right = new FormAttachment(middle, -margin);
        this.wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text((Composite)wXmlConf, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.top = new FormAttachment((Control)this.wDoNotFailIfNoFile, margin);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        FormData fdXmlConf = new FormData();
        fdXmlConf.left = new FormAttachment(0, margin);
        fdXmlConf.top = new FormAttachment(0, margin);
        fdXmlConf.right = new FormAttachment(100, -margin);
        wXmlConf.setLayoutData((Object)fdXmlConf);
        Group wAdditionalFields = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wAdditionalFields);
        wAdditionalFields.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.wAdditionalFields.Label", (String[])new String[0]));
        FormLayout additionalFieldsgroupLayout = new FormLayout();
        additionalFieldsgroupLayout.marginWidth = 10;
        additionalFieldsgroupLayout.marginHeight = 10;
        wAdditionalFields.setLayout((Layout)additionalFieldsgroupLayout);
        this.wlInclFilename = new Label((Composite)wAdditionalFields, 131072);
        this.wlInclFilename.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.InclFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlInclFilename);
        FormData fdlInclFilename = new FormData();
        fdlInclFilename.left = new FormAttachment(0, 0);
        fdlInclFilename.top = new FormAttachment((Control)wXmlConf, 4 * margin);
        fdlInclFilename.right = new FormAttachment(middle, -margin);
        this.wlInclFilename.setLayoutData((Object)fdlInclFilename);
        this.wInclFilename = new Button((Composite)wAdditionalFields, 32);
        PropsUi.setLook((Widget)this.wInclFilename);
        this.wInclFilename.setToolTipText(BaseMessages.getString(PKG, (String)"YamlInputDialog.InclFilename.Tooltip", (String[])new String[0]));
        FormData fdInclFilename = new FormData();
        fdInclFilename.left = new FormAttachment(middle, 0);
        fdInclFilename.top = new FormAttachment((Control)this.wlInclFilename, 0, 0x1000000);
        this.wInclFilename.setLayoutData((Object)fdInclFilename);
        this.wInclFilename.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        this.wlInclFilenameField = new Label((Composite)wAdditionalFields, 16384);
        this.wlInclFilenameField.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.InclFilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlInclFilenameField);
        FormData fdlInclFilenameField = new FormData();
        fdlInclFilenameField.left = new FormAttachment((Control)this.wInclFilename, margin);
        fdlInclFilenameField.top = new FormAttachment((Control)this.wLimit, 4 * margin);
        this.wlInclFilenameField.setLayoutData((Object)fdlInclFilenameField);
        this.wInclFilenameField = new TextVar(this.variables, (Composite)wAdditionalFields, 18436);
        PropsUi.setLook((Widget)this.wInclFilenameField);
        this.wInclFilenameField.addModifyListener(lsMod);
        FormData fdInclFilenameField = new FormData();
        fdInclFilenameField.left = new FormAttachment((Control)this.wlInclFilenameField, margin);
        fdInclFilenameField.top = new FormAttachment((Control)this.wLimit, 4 * margin);
        fdInclFilenameField.right = new FormAttachment(100, 0);
        this.wInclFilenameField.setLayoutData((Object)fdInclFilenameField);
        Label wlInclRownum = new Label((Composite)wAdditionalFields, 131072);
        wlInclRownum.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.InclRownum.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclRownum);
        FormData fdlInclRownum = new FormData();
        fdlInclRownum.left = new FormAttachment(0, 0);
        fdlInclRownum.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        fdlInclRownum.right = new FormAttachment(middle, -margin);
        wlInclRownum.setLayoutData((Object)fdlInclRownum);
        this.wInclRownum = new Button((Composite)wAdditionalFields, 32);
        PropsUi.setLook((Widget)this.wInclRownum);
        this.wInclRownum.setToolTipText(BaseMessages.getString(PKG, (String)"YamlInputDialog.InclRownum.Tooltip", (String[])new String[0]));
        FormData fdRownum = new FormData();
        fdRownum.left = new FormAttachment(middle, 0);
        fdRownum.top = new FormAttachment((Control)wlInclRownum, 0, 0x1000000);
        this.wInclRownum.setLayoutData((Object)fdRownum);
        this.wInclRownum.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        this.wlInclRownumField = new Label((Composite)wAdditionalFields, 131072);
        this.wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.InclRownumField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlInclRownumField);
        FormData fdlInclRownumField = new FormData();
        fdlInclRownumField.left = new FormAttachment((Control)this.wInclRownum, margin);
        fdlInclRownumField.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        this.wlInclRownumField.setLayoutData((Object)fdlInclRownumField);
        this.wInclRownumField = new TextVar(this.variables, (Composite)wAdditionalFields, 18436);
        PropsUi.setLook((Widget)this.wInclRownumField);
        this.wInclRownumField.addModifyListener(lsMod);
        FormData fdInclRownumField = new FormData();
        fdInclRownumField.left = new FormAttachment((Control)this.wlInclRownumField, margin);
        fdInclRownumField.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        fdInclRownumField.right = new FormAttachment(100, 0);
        this.wInclRownumField.setLayoutData((Object)fdInclRownumField);
        FormData fdAdditionalFields = new FormData();
        fdAdditionalFields.left = new FormAttachment(0, margin);
        fdAdditionalFields.top = new FormAttachment((Control)wXmlConf, margin);
        fdAdditionalFields.right = new FormAttachment(100, -margin);
        wAdditionalFields.setLayoutData((Object)fdAdditionalFields);
        Group wAddFileResult = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wAddFileResult);
        wAddFileResult.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.wAddFileResult.Label", (String[])new String[0]));
        FormLayout addFileResultgroupLayout = new FormLayout();
        addFileResultgroupLayout.marginWidth = 10;
        addFileResultgroupLayout.marginHeight = 10;
        wAddFileResult.setLayout((Layout)addFileResultgroupLayout);
        this.wlAddResult = new Label((Composite)wAddFileResult, 131072);
        this.wlAddResult.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.AddResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)wAdditionalFields, margin);
        fdlAddResult.right = new FormAttachment(middle, -margin);
        this.wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)wAddFileResult, 32);
        PropsUi.setLook((Widget)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"YamlInputDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(middle, 0);
        fdAddResult.top = new FormAttachment((Control)this.wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        this.wAddResult.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        FormData fdAddFileResult = new FormData();
        fdAddFileResult.left = new FormAttachment(0, margin);
        fdAddFileResult.top = new FormAttachment((Control)wAdditionalFields, margin);
        fdAddFileResult.right = new FormAttachment(100, -margin);
        wAddFileResult.setLayoutData((Object)fdAddFileResult);
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)fdContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.Fields.Tab", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = PropsUi.getFormMargin();
        fieldsLayout.marginHeight = PropsUi.getFormMargin();
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        PropsUi.setLook((Widget)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"YamlInputDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.left = new FormAttachment(50, 0);
        this.fdGet.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        int FieldsRows = this.input.getInputFields().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.XPath.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.Type.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.Format.Column", (String[])new String[0]), 5, 3), new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.TrimType.Column", (String[])new String[0]), 2, YamlInputField.trimTypeDesc, true)};
        colinf[0].setUsingVariables(true);
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.Name.Column.Tooltip", (String[])new String[0]));
        colinf[1].setUsingVariables(true);
        colinf[1].setToolTip(BaseMessages.getString(PKG, (String)"YamlInputDialog.FieldsTable.XPath.Column.Tooltip", (String[])new String[0]));
        this.wFields = new TableView(this.variables, wFieldsComp, 65538, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wGet.addListener(13, e -> this.get());
        SelectionAdapter selA = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                YamlInputDialog.this.wFilenameList.add(new String[]{YamlInputDialog.this.wFilename.getText(), YamlInputDialog.this.wFilemask.getText()});
                YamlInputDialog.this.wFilename.setText("");
                YamlInputDialog.this.wFilemask.setText("");
                YamlInputDialog.this.wFilenameList.removeEmptyRows();
                YamlInputDialog.this.wFilenameList.setRowNums();
                YamlInputDialog.this.wFilenameList.optWidth(true);
            }
        };
        this.wbaFilename.addSelectionListener((SelectionListener)selA);
        this.wFilename.addSelectionListener(selA);
        this.wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = YamlInputDialog.this.wFilenameList.getSelectionIndices();
                YamlInputDialog.this.wFilenameList.remove(idx);
                YamlInputDialog.this.wFilenameList.removeEmptyRows();
                YamlInputDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = YamlInputDialog.this.wFilenameList.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = YamlInputDialog.this.wFilenameList.getItem(idx);
                    YamlInputDialog.this.wFilename.setText(string[0]);
                    YamlInputDialog.this.wFilemask.setText(string[1]);
                    YamlInputDialog.this.wFilenameList.remove(idx);
                }
                YamlInputDialog.this.wFilenameList.removeEmptyRows();
                YamlInputDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    YamlInputMeta tfii = new YamlInputMeta();
                    YamlInputDialog.this.getInfo(tfii);
                    FileInputList fileInputList = tfii.getFiles(YamlInputDialog.this.variables);
                    String[] files = fileInputList.getFileStrings();
                    if (files != null && files.length > 0) {
                        EnterSelectionDialog esd = new EnterSelectionDialog(YamlInputDialog.this.shell, files, BaseMessages.getString(PKG, (String)"YamlInputDialog.FilesReadSelection.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"YamlInputDialog.FilesReadSelection.DialogMessage", (String[])new String[0]));
                        esd.setViewOnly();
                        esd.open();
                    } else {
                        MessageBox mb = new MessageBox(YamlInputDialog.this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"YamlInputDialog.NoFileFound.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                        mb.open();
                    }
                }
                catch (Exception ex) {
                    new ErrorDialog(YamlInputDialog.this.shell, BaseMessages.getString(PKG, (String)YamlInputDialog.CONST_YAML_INPUT_DIALOG_ERROR_PARSING_DATA_DIALOG_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)YamlInputDialog.CONST_YAML_INPUT_DIALOG_ERROR_PARSING_DATA_DIALOG_MESSAGE, (String[])new String[0]), ex);
                }
            }
        });
        this.wInclFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                YamlInputDialog.this.setIncludeFilename();
            }
        });
        this.wInclRownum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                YamlInputDialog.this.setIncludeRownum();
            }
        });
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.wFilename.getText()));
        if (this.wbbFilename != null) {
            this.wbbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.yaml;*.YAML;*.yml;*.YML", "*"}, (String[])new String[]{"Yaml files", BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        }
        wTabFolder.setSelection(0);
        this.getData(this.input);
        this.activateStreamField();
        this.setIncludeFilename();
        this.setIncludeRownum();
        this.input.setChanged(this.changed);
        this.wFields.optWidth(true);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setXMLStreamField() {
        try {
            this.wYAMLLField.removeAll();
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                r.getFieldNames();
                for (int i = 0; i < r.getFieldNames().length; ++i) {
                    this.wYAMLLField.add(r.getFieldNames()[i]);
                }
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"YamlInputDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"YamlInputDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void activateStreamField() {
        this.wlYamlField.setEnabled(this.wYAMLStreamField.getSelection());
        this.wYAMLLField.setEnabled(this.wYAMLStreamField.getSelection());
        this.wlYamlIsAFile.setEnabled(this.wYAMLStreamField.getSelection());
        this.wYAMLIsAFile.setEnabled(this.wYAMLStreamField.getSelection());
        this.wlFilename.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wbbFilename.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wbaFilename.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wFilename.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wlFilemask.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wFilemask.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wlFilenameList.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wbdFilename.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wbeFilename.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wbShowFiles.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wlFilenameList.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wFilenameList.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wInclFilename.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wlInclFilename.setEnabled(!this.wYAMLStreamField.getSelection());
        if (this.wYAMLStreamField.getSelection()) {
            this.wInclFilename.setSelection(false);
            this.wlInclFilenameField.setEnabled(false);
            this.wInclFilenameField.setEnabled(false);
        } else {
            this.wlInclFilenameField.setEnabled(this.wInclFilename.getSelection());
            this.wInclFilenameField.setEnabled(this.wInclFilename.getSelection());
        }
        this.wAddResult.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wlAddResult.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wLimit.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wlLimit.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wPreview.setEnabled(!this.wYAMLStreamField.getSelection());
        this.wGet.setEnabled(!this.wYAMLStreamField.getSelection());
        this.enableFileSettings();
    }

    private void enableFileSettings() {
        boolean active = !this.wYAMLStreamField.getSelection() || this.wYAMLStreamField.getSelection() && this.wYAMLIsAFile.getSelection();
        this.wlIgnoreEmptyFile.setEnabled(active);
        this.wIgnoreEmptyFile.setEnabled(active);
        this.wlDoNotFailIfNoFile.setEnabled(active);
        this.wDoNotFailIfNoFile.setEnabled(active);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get() {
        YamlReader yaml = null;
        try {
            YamlInputMeta meta = new YamlInputMeta();
            this.getInfo(meta);
            FileInputList inputList = meta.getFiles(this.variables);
            if (!inputList.getFiles().isEmpty()) {
                this.wFields.removeAll();
                yaml = new YamlReader();
                yaml.loadFile(inputList.getFile(0));
                RowMeta row = yaml.getFields();
                for (int i = 0; i < row.size(); ++i) {
                    IValueMeta value = row.getValueMeta(i);
                    TableItem item = new TableItem(this.wFields.table, 0);
                    item.setText(1, value.getName());
                    item.setText(2, value.getName());
                    item.setText(3, value.getTypeDesc());
                }
                this.wFields.removeEmptyRows();
                this.wFields.setRowNums();
                this.wFields.optWidth(true);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_YAML_INPUT_DIALOG_ERROR_PARSING_DATA_DIALOG_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_YAML_INPUT_DIALOG_ERROR_PARSING_DATA_DIALOG_MESSAGE, (String[])new String[0]), e);
        }
        finally {
            if (yaml != null) {
                try {
                    yaml.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setIncludeFilename() {
        this.wlInclFilenameField.setEnabled(this.wInclFilename.getSelection());
        this.wInclFilenameField.setEnabled(this.wInclFilename.getSelection());
    }

    public void setIncludeRownum() {
        this.wlInclRownumField.setEnabled(this.wInclRownum.getSelection());
        this.wInclRownumField.setEnabled(this.wInclRownum.getSelection());
    }

    public void getData(YamlInputMeta in) {
        int i;
        if (in.getFileName() != null) {
            this.wFilenameList.removeAll();
            for (i = 0; i < in.getFileName().length; ++i) {
                this.wFilenameList.add(new String[]{in.getFileName()[i], in.getFileMask()[i], in.getRequiredFilesDesc(in.getFileRequired()[i]), in.getRequiredFilesDesc(in.getIncludeSubFolders()[i])});
            }
            this.wFilenameList.removeEmptyRows();
            this.wFilenameList.setRowNums();
            this.wFilenameList.optWidth(true);
        }
        this.wInclFilename.setSelection(in.includeFilename());
        this.wInclRownum.setSelection(in.includeRowNumber());
        this.wAddResult.setSelection(in.addResultFile());
        this.wIgnoreEmptyFile.setSelection(in.isIgnoreEmptyFile());
        this.wDoNotFailIfNoFile.setSelection(in.isdoNotFailIfNoFile());
        this.wYAMLStreamField.setSelection(in.isInFields());
        this.wYAMLIsAFile.setSelection(in.getIsAFile());
        if (in.getYamlField() != null) {
            this.wYAMLLField.setText(in.getYamlField());
        }
        if (in.getFilenameField() != null) {
            this.wInclFilenameField.setText(in.getFilenameField());
        }
        if (in.getRowNumberField() != null) {
            this.wInclRownumField.setText(in.getRowNumberField());
        }
        this.wLimit.setText("" + in.getRowLimit());
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"YamlInputDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        }
        for (i = 0; i < in.getInputFields().length; ++i) {
            YamlInputField field = in.getInputFields()[i];
            if (field == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            String name = field.getName();
            String path = field.getPath();
            String type = field.getTypeDesc();
            String format = field.getFormat();
            String length = "" + field.getLength();
            String prec = "" + field.getPrecision();
            String curr = field.getCurrencySymbol();
            String group = field.getGroupSymbol();
            String decim = field.getDecimalSymbol();
            String trim = field.getTrimTypeDesc();
            if (name != null) {
                item.setText(1, name);
            }
            if (path != null) {
                item.setText(2, path);
            }
            if (type != null) {
                item.setText(3, type);
            }
            if (format != null) {
                item.setText(4, format);
            }
            if (length != null && !"-1".equals(length)) {
                item.setText(5, length);
            }
            if (prec != null && !"-1".equals(prec)) {
                item.setText(6, prec);
            }
            if (curr != null) {
                item.setText(7, curr);
            }
            if (decim != null) {
                item.setText(8, decim);
            }
            if (group != null) {
                item.setText(9, group);
            }
            if (trim == null) continue;
            item.setText(10, trim);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.getInfo(this.input);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_YAML_INPUT_DIALOG_ERROR_PARSING_DATA_DIALOG_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_YAML_INPUT_DIALOG_ERROR_PARSING_DATA_DIALOG_MESSAGE, (String[])new String[0]), e);
        }
        this.dispose();
    }

    private void getInfo(YamlInputMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
        in.setFilenameField(this.wInclFilenameField.getText());
        in.setRowNumberField(this.wInclRownumField.getText());
        in.setAddResultFile(this.wAddResult.getSelection());
        in.setIncludeFilename(this.wInclFilename.getSelection());
        in.setIncludeRowNumber(this.wInclRownum.getSelection());
        in.setIgnoreEmptyFile(this.wIgnoreEmptyFile.getSelection());
        in.setdoNotFailIfNoFile(this.wDoNotFailIfNoFile.getSelection());
        in.setInFields(this.wYAMLStreamField.getSelection());
        in.setIsAFile(this.wYAMLIsAFile.getSelection());
        in.setYamlField(this.wYAMLLField.getText());
        int nrFiles = this.wFilenameList.getItemCount();
        int nrFields = this.wFields.nrNonEmpty();
        in.allocate(nrFiles, nrFields);
        in.setFileName(this.wFilenameList.getItems(0));
        in.setFileMask(this.wFilenameList.getItems(1));
        in.setFileRequired(this.wFilenameList.getItems(2));
        in.setIncludeSubFolders(this.wFilenameList.getItems(3));
        for (int i = 0; i < nrFields; ++i) {
            YamlInputField field = new YamlInputField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setName(item.getText(1));
            field.setPath(item.getText(2));
            field.setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(3)));
            field.setFormat(item.getText(4));
            field.setLength(Const.toInt((String)item.getText(5), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(6), (int)-1));
            field.setCurrencySymbol(item.getText(7));
            field.setDecimalSymbol(item.getText(8));
            field.setGroupSymbol(item.getText(9));
            field.setTrimType(YamlInputField.getTrimTypeByDesc(item.getText(10)));
            in.getInputFields()[i] = field;
        }
    }

    private void preview() {
        try {
            YamlInputMeta oneMeta = new YamlInputMeta();
            this.getInfo(oneMeta);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"YamlInputDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"YamlInputDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Pipeline pipeline = progressDialog.getPipeline();
                    String loggingText = progressDialog.getLoggingText();
                    if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"YamlInputDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"YamlInputDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), e);
        }
    }
}

