/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.propertyinput;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.propertyinput.PropertyInputData;
import org.apache.hop.pipeline.transforms.propertyinput.PropertyInputMeta;
import org.ini4j.Profile;
import org.ini4j.Wini;

public class PropertyInput
extends BaseTransform<PropertyInputMeta, PropertyInputData> {
    private static final Class<?> PKG = PropertyInputMeta.class;

    public PropertyInput(TransformMeta transformMeta, PropertyInputMeta meta, PropertyInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (this.first && !((PropertyInputMeta)this.meta).isFileField()) {
            ((PropertyInputData)this.data).files = ((PropertyInputMeta)this.meta).getFiles((IVariables)this);
            if (((PropertyInputData)this.data).files == null || ((PropertyInputData)this.data).files.nrOfFiles() == 0) {
                this.setOutputDone();
                return false;
            }
            this.handleMissingFiles();
            ((PropertyInputData)this.data).outputRowMeta = new RowMeta();
            ((PropertyInputMeta)this.meta).getFields(((PropertyInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((PropertyInputData)this.data).convertRowMeta = ((PropertyInputData)this.data).outputRowMeta.cloneToType(2);
        }
        try {
            Object[] outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            this.putRow(((PropertyInputData)this.data).outputRowMeta, outputRowData);
            if (((PropertyInputMeta)this.meta).getRowLimit() > 0L && ((PropertyInputData)this.data).rowNumber > ((PropertyInputMeta)this.meta).getRowLimit()) {
                this.setOutputDone();
                return false;
            }
        }
        catch (HopException e) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError((IRowMeta)new RowMeta(), new Object[0], 1L, e.toString(), null, "PropertyInput001");
            }
            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.ErrorInTransformRunning", (String[])new String[]{e.getMessage()}));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void handleMissingFiles() throws HopException {
        List nonExistantFiles = ((PropertyInputData)this.data).files.getNonExistentFiles();
        if (!nonExistantFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = ((PropertyInputData)this.data).files.getNonAccessibleFiles();
        if (!nonAccessibleFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredNotAccessibleFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    private Object[] getOneRow() throws HopException {
        try {
            if (((PropertyInputMeta)this.meta).isFileField()) {
                while (((PropertyInputData)this.data).inputRow == null || ((PropertyInputData)this.data).propFiles && !((PropertyInputData)this.data).iterator.hasNext() || !((PropertyInputData)this.data).propFiles && !((PropertyInputData)this.data).iniNameIterator.hasNext()) {
                    if (!((PropertyInputData)this.data).propFiles && ((PropertyInputData)this.data).realSection == null && ((PropertyInputData)this.data).inputRow != null && ((PropertyInputData)this.data).sectionNameIterator.hasNext()) {
                        ((PropertyInputData)this.data).iniSection = (Profile.Section)((PropertyInputData)this.data).wini.get((Object)((PropertyInputData)this.data).sectionNameIterator.next().toString());
                        ((PropertyInputData)this.data).iniNameIterator = ((PropertyInputData)this.data).iniSection.keySet().iterator();
                        continue;
                    }
                    if (this.openNextFile()) continue;
                    return null;
                }
            } else {
                while (((PropertyInputData)this.data).file == null || ((PropertyInputData)this.data).propFiles && !((PropertyInputData)this.data).iterator.hasNext() || !((PropertyInputData)this.data).propFiles && !((PropertyInputData)this.data).iniNameIterator.hasNext()) {
                    if (!((PropertyInputData)this.data).propFiles && ((PropertyInputData)this.data).realSection == null && ((PropertyInputData)this.data).file != null && ((PropertyInputData)this.data).sectionNameIterator.hasNext()) {
                        ((PropertyInputData)this.data).iniSection = (Profile.Section)((PropertyInputData)this.data).wini.get((Object)((PropertyInputData)this.data).sectionNameIterator.next());
                        ((PropertyInputData)this.data).iniNameIterator = ((PropertyInputData)this.data).iniSection.keySet().iterator();
                        continue;
                    }
                    if (this.openNextFile()) continue;
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.logError("Unable to read row from file : " + e.getMessage());
            return null;
        }
        Object[] outputRow = ((PropertyInputMeta)this.meta).isFileField() ? RowDataUtil.createResizedCopy((Object[])this.getInputRowMeta().cloneRow(((PropertyInputData)this.data).inputRow), (int)((PropertyInputData)this.data).outputRowMeta.size()) : RowDataUtil.allocateRowData((int)((PropertyInputData)this.data).outputRowMeta.size());
        try {
            String key = null;
            key = ((PropertyInputData)this.data).propFiles ? ((PropertyInputData)this.data).iterator.next().toString() : ((PropertyInputData)this.data).iniNameIterator.next();
            for (int i = 0; i < ((PropertyInputMeta)this.meta).getInputFields().size(); ++i) {
                PropertyInputMeta.PIField field = ((PropertyInputMeta)this.meta).getInputFields().get(i);
                String value = null;
                value = field.getColumn() == PropertyInputMeta.KeyValue.KEY ? key : (((PropertyInputMeta)this.meta).isResolvingValueVariable() ? (((PropertyInputData)this.data).propFiles ? this.resolve(((PropertyInputData)this.data).properties.getProperty(key)) : this.resolve(((PropertyInputData)this.data).iniSection.fetch((Object)key))) : (((PropertyInputData)this.data).propFiles ? ((PropertyInputData)this.data).properties.getProperty(key) : ((PropertyInputData)this.data).iniSection.fetch((Object)key)));
                if (field.getTrimType() != null) {
                    switch (field.getTrimType()) {
                        case LEFT: {
                            value = Const.ltrim((String)value);
                            break;
                        }
                        case RIGHT: {
                            value = Const.rtrim((String)value);
                            break;
                        }
                        case BOTH: {
                            value = Const.trim((String)value);
                            break;
                        }
                    }
                }
                if (((PropertyInputMeta)this.meta).isFileField()) {
                    outputRow = RowDataUtil.addValueData((Object[])outputRow, (int)(((PropertyInputData)this.data).totalPreviousFields + i), (Object)value);
                }
                IValueMeta targetValueMeta = ((PropertyInputData)this.data).outputRowMeta.getValueMeta(((PropertyInputData)this.data).totalPreviousFields + i);
                IValueMeta sourceValueMeta = ((PropertyInputData)this.data).convertRowMeta.getValueMeta(((PropertyInputData)this.data).totalPreviousFields + i);
                outputRow[((PropertyInputData)this.data).totalPreviousFields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)value);
                if (!field.isRepeating() || ((PropertyInputData)this.data).previousRow == null || !Utils.isEmpty((CharSequence)value)) continue;
                outputRow[((PropertyInputData)this.data).totalPreviousFields + i] = ((PropertyInputData)this.data).previousRow[((PropertyInputData)this.data).totalPreviousFields + i];
            }
            int rowIndex = ((PropertyInputMeta)this.meta).getInputFields().size();
            if (((PropertyInputMeta)this.meta).isIncludingFilename() && !Utils.isEmpty((CharSequence)((PropertyInputMeta)this.meta).getFilenameField())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex++] = ((PropertyInputData)this.data).filename;
            }
            if (((PropertyInputMeta)this.meta).isIncludeRowNumber() && !Utils.isEmpty((CharSequence)((PropertyInputMeta)this.meta).getRowNumberField())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex++] = ((PropertyInputData)this.data).rowNumber;
            }
            if (((PropertyInputMeta)this.meta).isIncludeIniSection() && !Utils.isEmpty((CharSequence)((PropertyInputMeta)this.meta).getIniSectionField())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex++] = this.resolve(((PropertyInputData)this.data).iniSection.getName());
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getShortFileFieldName())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex++] = ((PropertyInputData)this.data).shortFilename;
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getExtensionFieldName())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex++] = ((PropertyInputData)this.data).extension;
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getPathFieldName())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex++] = ((PropertyInputData)this.data).path;
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getSizeFieldName())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex++] = ((PropertyInputData)this.data).size;
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getHiddenFieldName())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex++] = ((PropertyInputData)this.data).hidden;
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getLastModificationTimeFieldName())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex++] = ((PropertyInputData)this.data).lastModificationDateTime;
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getUriNameFieldName())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex++] = ((PropertyInputData)this.data).uriName;
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getRootUriNameFieldName())) {
                outputRow[((PropertyInputData)this.data).totalPreviousFields + rowIndex] = ((PropertyInputData)this.data).rootUriName;
            }
            IRowMeta inputRowMeta = this.getInputRowMeta();
            ((PropertyInputData)this.data).previousRow = inputRowMeta == null ? outputRow : inputRowMeta.cloneRow(outputRow);
            this.incrementLinesInput();
            ++((PropertyInputData)this.data).rowNumber;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Error.CanNotReadFromFile", (String[])new String[]{((PropertyInputData)this.data).file.toString()}), (Throwable)e);
        }
        return outputRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openNextFile() {
        InputStream inputStream = null;
        try {
            if (!((PropertyInputMeta)this.meta).isFileField()) {
                if (((PropertyInputData)this.data).fileNumber >= ((PropertyInputData)this.data).files.nrOfFiles()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    boolean bl = false;
                    return bl;
                }
                ((PropertyInputData)this.data).lastFile = ((PropertyInputData)this.data).fileNumber == ((PropertyInputData)this.data).files.nrOfFiles() - 1;
                ((PropertyInputData)this.data).file = ((PropertyInputData)this.data).files.getFile(((PropertyInputData)this.data).fileNumber);
                ++((PropertyInputData)this.data).fileNumber;
            } else {
                ((PropertyInputData)this.data).inputRow = this.getRow();
                if (((PropertyInputData)this.data).inputRow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    boolean bl = false;
                    return bl;
                }
                if (this.first) {
                    this.first = false;
                    ((PropertyInputData)this.data).inputRowMeta = this.getInputRowMeta();
                    ((PropertyInputData)this.data).outputRowMeta = ((PropertyInputData)this.data).inputRowMeta.clone();
                    ((PropertyInputMeta)this.meta).getFields(((PropertyInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((PropertyInputData)this.data).totalPreviousFields = ((PropertyInputData)this.data).inputRowMeta.size();
                    ((PropertyInputData)this.data).convertRowMeta = ((PropertyInputData)this.data).outputRowMeta.cloneToType(2);
                    if (Utils.isEmpty((CharSequence)((PropertyInputMeta)this.meta).getDynamicFilenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.NoField", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Log.NoField", (String[])new String[0]));
                    }
                    if (((PropertyInputData)this.data).indexOfFilenameField < 0) {
                        ((PropertyInputData)this.data).indexOfFilenameField = this.getInputRowMeta().indexOfValue(((PropertyInputMeta)this.meta).getDynamicFilenameField());
                        if (((PropertyInputData)this.data).indexOfFilenameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.ErrorFindingField", (String[])new String[0]) + "[" + ((PropertyInputMeta)this.meta).getDynamicFilenameField() + "]");
                            throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Exception.CouldNotFindField", (String[])new String[]{((PropertyInputMeta)this.meta).getDynamicFilenameField()}));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(((PropertyInputData)this.data).inputRow, ((PropertyInputData)this.data).indexOfFilenameField);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FilenameInStream", (String[])new String[]{((PropertyInputMeta)this.meta).getDynamicFilenameField(), filename}));
                }
                ((PropertyInputData)this.data).file = HopVfs.getFileObject((String)filename, (IVariables)this.variables);
            }
            ((PropertyInputData)this.data).filename = HopVfs.getFilename((FileObject)((PropertyInputData)this.data).file);
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getShortFileFieldName())) {
                ((PropertyInputData)this.data).shortFilename = ((PropertyInputData)this.data).file.getName().getBaseName();
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getPathFieldName())) {
                ((PropertyInputData)this.data).path = HopVfs.getFilename((FileObject)((PropertyInputData)this.data).file.getParent());
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getHiddenFieldName())) {
                ((PropertyInputData)this.data).hidden = ((PropertyInputData)this.data).file.isHidden();
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getExtensionFieldName())) {
                ((PropertyInputData)this.data).extension = ((PropertyInputData)this.data).file.getName().getExtension();
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getLastModificationTimeFieldName())) {
                ((PropertyInputData)this.data).lastModificationDateTime = new Date(((PropertyInputData)this.data).file.getContent().getLastModifiedTime());
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getUriNameFieldName())) {
                ((PropertyInputData)this.data).uriName = ((PropertyInputData)this.data).file.getName().getURI();
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getRootUriNameFieldName())) {
                ((PropertyInputData)this.data).rootUriName = ((PropertyInputData)this.data).file.getName().getRootURI();
            }
            if (StringUtils.isNotEmpty((String)((PropertyInputMeta)this.meta).getSizeFieldName())) {
                ((PropertyInputData)this.data).size = ((PropertyInputData)this.data).file.getContent().getSize();
            }
            if (((PropertyInputMeta)this.meta).isResettingRowNumber()) {
                ((PropertyInputData)this.data).rowNumber = 0L;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.OpeningFile", (String[])new String[]{((PropertyInputData)this.data).file.toString()}));
            }
            if (((PropertyInputMeta)this.meta).isAddResult()) {
                ResultFile resultFile = new ResultFile(0, ((PropertyInputData)this.data).file, this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            inputStream = ((PropertyInputData)this.data).file.getContent().getInputStream();
            if (((PropertyInputData)this.data).propFiles) {
                ((PropertyInputData)this.data).properties = new Properties();
                ((PropertyInputData)this.data).properties.load(inputStream);
                ((PropertyInputData)this.data).iterator = ((PropertyInputData)this.data).properties.keySet().iterator();
            } else {
                ((PropertyInputData)this.data).wini = new Wini();
                if (!Utils.isEmpty((CharSequence)((PropertyInputData)this.data).realEncoding)) {
                    ((PropertyInputData)this.data).wini.getConfig().setFileEncoding(Charset.forName(((PropertyInputData)this.data).realEncoding));
                }
                ((PropertyInputData)this.data).wini.load(inputStream);
                if (((PropertyInputData)this.data).realSection != null) {
                    ((PropertyInputData)this.data).iniSection = (Profile.Section)((PropertyInputData)this.data).wini.get((Object)((PropertyInputData)this.data).realSection);
                    if (((PropertyInputData)this.data).iniSection == null) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Error.CanNotFindSection", (String[])new String[]{((PropertyInputData)this.data).realSection, "" + ((PropertyInputData)this.data).file.getName()}));
                    }
                } else {
                    ((PropertyInputData)this.data).sectionNameIterator = ((PropertyInputData)this.data).wini.keySet().iterator();
                    ((PropertyInputData)this.data).iniSection = (Profile.Section)((PropertyInputData)this.data).wini.get((Object)((PropertyInputData)this.data).sectionNameIterator.next());
                }
                ((PropertyInputData)this.data).iniNameIterator = ((PropertyInputData)this.data).iniSection.keySet().iterator();
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FileOpened", (String[])new String[]{((PropertyInputData)this.data).file.toString()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.log.TotalKey", (String[])new String[]{"" + (((PropertyInputData)this.data).propFiles ? ((PropertyInputData)this.data).properties.size() : ((PropertyInputData)this.data).iniSection.size()), HopVfs.getFilename((FileObject)((PropertyInputData)this.data).file)}));
            }
            BaseTransform.closeQuietly((Closeable)inputStream);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.UnableToOpenFile", (String[])new String[]{"" + ((PropertyInputData)this.data).fileNumber, ((PropertyInputData)this.data).file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            boolean bl = false;
            return bl;
        }
        finally {
            BaseTransform.closeQuietly(inputStream);
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            String realSection;
            String realEncoding = this.resolve(((PropertyInputMeta)this.meta).getEncoding());
            if (!Utils.isEmpty((CharSequence)realEncoding)) {
                ((PropertyInputData)this.data).realEncoding = realEncoding;
            }
            if (!Utils.isEmpty((CharSequence)(realSection = this.resolve(((PropertyInputMeta)this.meta).getSection())))) {
                ((PropertyInputData)this.data).realSection = realSection;
            }
            ((PropertyInputData)this.data).propFiles = ((PropertyInputMeta)this.meta).getFileType() == PropertyInputMeta.FileType.PROPERTY;
            ((PropertyInputData)this.data).rowNumber = 1L;
            ((PropertyInputData)this.data).totalPreviousFields = 0;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((PropertyInputData)this.data).inputRow != null) {
            ((PropertyInputData)this.data).inputRow = null;
        }
        if (((PropertyInputData)this.data).iniSection != null) {
            ((PropertyInputData)this.data).iniSection.clear();
        }
        ((PropertyInputData)this.data).iniSection = null;
        if (((PropertyInputData)this.data).sectionNameIterator != null) {
            ((PropertyInputData)this.data).sectionNameIterator = null;
        }
        if (((PropertyInputData)this.data).file != null) {
            try {
                ((PropertyInputData)this.data).file.close();
                ((PropertyInputData)this.data).file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }
}

