/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceinsert;

import com.google.common.annotations.VisibleForTesting;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import java.util.ArrayList;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransform;
import org.apache.hop.pipeline.transforms.salesforceinsert.SalesforceInsertData;
import org.apache.hop.pipeline.transforms.salesforceinsert.SalesforceInsertMeta;
import org.apache.hop.pipeline.transforms.salesforceutils.SalesforceUtils;

public class SalesforceInsert
extends SalesforceTransform<SalesforceInsertMeta, SalesforceInsertData> {
    private static final Class<?> PKG = SalesforceInsertMeta.class;

    public SalesforceInsert(TransformMeta transformMeta, SalesforceInsertMeta meta, SalesforceInsertData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, meta, data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] outputRowData = this.getRow();
        if (outputRowData == null) {
            if (((SalesforceInsertData)this.data).iBufferPos > 0) {
                this.flushBuffers();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((SalesforceInsertData)this.data).sfBuffer = new SObject[((SalesforceInsertMeta)this.meta).getBatchSizeInt()];
            ((SalesforceInsertData)this.data).outputBuffer = new Object[((SalesforceInsertMeta)this.meta).getBatchSizeInt()][];
            ((SalesforceInsertData)this.data).nrFields = ((SalesforceInsertMeta)this.meta).getUpdateLookup().length;
            if (((SalesforceInsertData)this.data).nrFields == 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
            }
            ((SalesforceInsertData)this.data).inputRowMeta = this.getInputRowMeta().clone();
            ((SalesforceInsertData)this.data).outputRowMeta = ((SalesforceInsertData)this.data).inputRowMeta.clone();
            ((SalesforceInsertMeta)this.meta).getFields(((SalesforceInsertData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((SalesforceInsertData)this.data).fieldnrs = new int[((SalesforceInsertMeta)this.meta).getUpdateStream().length];
            for (int i = 0; i < ((SalesforceInsertMeta)this.meta).getUpdateStream().length; ++i) {
                ((SalesforceInsertData)this.data).fieldnrs[i] = this.getInputRowMeta().indexOfValue(((SalesforceInsertMeta)this.meta).getUpdateStream()[i]);
                if (((SalesforceInsertData)this.data).fieldnrs[i] >= 0) continue;
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceInsert.CanNotFindField", (String[])new String[]{((SalesforceInsertMeta)this.meta).getUpdateStream()[i]}));
            }
        }
        try {
            this.writeToSalesForce(outputRowData);
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"SalesforceInsert.log.Exception", (Object[])new Object[]{e}));
        }
        return true;
    }

    @VisibleForTesting
    void writeToSalesForce(Object[] rowData) throws HopException {
        try {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInsert.WriteToSalesforce", (Object[])new Object[]{((SalesforceInsertData)this.data).iBufferPos, ((SalesforceInsertMeta)this.meta).getBatchSizeInt()}));
            }
            if (((SalesforceInsertData)this.data).iBufferPos < ((SalesforceInsertMeta)this.meta).getBatchSizeInt()) {
                ArrayList<XmlObject> insertfields = new ArrayList<XmlObject>();
                ArrayList<String> fieldsToNull = new ArrayList<String>();
                for (int i = 0; i < ((SalesforceInsertData)this.data).nrFields; ++i) {
                    Object value;
                    IValueMeta valueMeta = ((SalesforceInsertData)this.data).inputRowMeta.getValueMeta(((SalesforceInsertData)this.data).fieldnrs[i]);
                    if (valueMeta.isNull(value = rowData[((SalesforceInsertData)this.data).fieldnrs[i]])) {
                        fieldsToNull.add(SalesforceUtils.getFieldToNullName(this.log, ((SalesforceInsertMeta)this.meta).getUpdateLookup()[i], ((SalesforceInsertMeta)this.meta).getUseExternalId()[i]));
                        continue;
                    }
                    Object normalObject = this.normalizeValue(valueMeta, value);
                    insertfields.add(SalesforceConnection.createMessageElement(((SalesforceInsertMeta)this.meta).getUpdateLookup()[i], normalObject, ((SalesforceInsertMeta)this.meta).getUseExternalId()[i]));
                }
                SObject sobjPass = new SObject();
                sobjPass.setType(((SalesforceInsertData)this.data).connection.getModule());
                if (!insertfields.isEmpty()) {
                    for (XmlObject element : insertfields) {
                        sobjPass.setSObjectField(element.getName().getLocalPart(), element.getValue());
                    }
                }
                if (!fieldsToNull.isEmpty()) {
                    sobjPass.setFieldsToNull(fieldsToNull.toArray(new String[fieldsToNull.size()]));
                }
                ((SalesforceInsertData)this.data).sfBuffer[((SalesforceInsertData)this.data).iBufferPos] = sobjPass;
                ((SalesforceInsertData)this.data).outputBuffer[((SalesforceInsertData)this.data).iBufferPos] = rowData;
                ++((SalesforceInsertData)this.data).iBufferPos;
            }
            if (((SalesforceInsertData)this.data).iBufferPos >= ((SalesforceInsertMeta)this.meta).getBatchSizeInt()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInsert.CallingFlushBuffer", (String[])new String[0]));
                }
                this.flushBuffers();
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceInsert.Error", (String[])new String[]{e.getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffers() throws HopException {
        try {
            ((SalesforceInsertData)this.data).saveResult = ((SalesforceInsertData)this.data).connection.insert(((SalesforceInsertData)this.data).sfBuffer);
            for (int j = 0; j < ((SalesforceInsertData)this.data).saveResult.length; ++j) {
                if (((SalesforceInsertData)this.data).saveResult[j].isSuccess()) {
                    String id = ((SalesforceInsertData)this.data).saveResult[j].getId();
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceInsert.RowInserted", (String[])new String[]{id}));
                    }
                    Object[] newRow = RowDataUtil.resizeArray((Object[])((SalesforceInsertData)this.data).outputBuffer[j], (int)((SalesforceInsertData)this.data).outputRowMeta.size());
                    if (((SalesforceInsertData)this.data).realSalesforceFieldName != null) {
                        int newIndex = this.getInputRowMeta().size();
                        newRow[newIndex++] = id;
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInsert.NewRow", (Object[])new Object[]{newRow[0]}));
                    }
                    this.putRow(((SalesforceInsertData)this.data).outputRowMeta, newRow);
                    this.incrementLinesOutput();
                    if (!this.checkFeedback(this.getLinesInput()) || !this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInsert.log.LineRow", (Object[])new Object[]{this.getLinesInput()}));
                    continue;
                }
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceInsert.ErrorFound", (String[])new String[0]));
                    }
                    Error err = ((SalesforceInsertData)this.data).saveResult[j].getErrors()[0];
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceInsert.Error.FlushBuffer", (Object[])new Object[]{j, err.getStatusCode(), err.getMessage()}));
                }
                Object errorMessage = "";
                for (int i = 0; i < ((SalesforceInsertData)this.data).saveResult[j].getErrors().length; ++i) {
                    Error err = ((SalesforceInsertData)this.data).saveResult[j].getErrors()[i];
                    errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"SalesforceInsert.Error.FlushBuffer", (Object[])new Object[]{j, err.getStatusCode(), err.getMessage()});
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInsert.PassingRowToErrorTransform", (String[])new String[0]));
                }
                this.putError(this.getInputRowMeta(), ((SalesforceInsertData)this.data).outputBuffer[j], 1L, (String)errorMessage, null, "SalesforceInsert001");
            }
            ((SalesforceInsertData)this.data).sfBuffer = new SObject[((SalesforceInsertMeta)this.meta).getBatchSizeInt()];
            ((SalesforceInsertData)this.data).outputBuffer = new Object[((SalesforceInsertMeta)this.meta).getBatchSizeInt()][];
            ((SalesforceInsertData)this.data).iBufferPos = 0;
        }
        catch (Exception e) {
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceInsert.FailedToInsertObject", (String[])new String[]{e.getMessage()}));
            }
            if (this.log.isDebug()) {
                this.logDebug("Passing row to error transform");
            }
            for (int i = 0; i < ((SalesforceInsertData)this.data).iBufferPos; ++i) {
                this.putError(((SalesforceInsertData)this.data).inputRowMeta, ((SalesforceInsertData)this.data).outputBuffer[i], 1L, e.getMessage(), null, "SalesforceInsert002");
            }
        }
        finally {
            if (((SalesforceInsertData)this.data).saveResult != null) {
                ((SalesforceInsertData)this.data).saveResult = null;
            }
        }
    }

    @Override
    public boolean init() {
        if (super.init()) {
            try {
                String salesfoceIdFieldname = this.resolve(((SalesforceInsertMeta)this.meta).getSalesforceIDFieldName());
                if (!Utils.isEmpty((CharSequence)salesfoceIdFieldname)) {
                    ((SalesforceInsertData)this.data).realSalesforceFieldName = salesfoceIdFieldname;
                }
                ((SalesforceInsertData)this.data).connection.setRollbackAllChangesOnError(((SalesforceInsertMeta)this.meta).isRollbackAllChangesOnError());
                ((SalesforceInsertData)this.data).connection.connect();
            }
            catch (HopException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceInsert.Log.ErrorOccurredDuringTransformInitialize", (String[])new String[0]) + ke.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        if (((SalesforceInsertData)this.data).outputBuffer != null) {
            ((SalesforceInsertData)this.data).outputBuffer = null;
        }
        if (((SalesforceInsertData)this.data).sfBuffer != null) {
            ((SalesforceInsertData)this.data).sfBuffer = null;
        }
        super.dispose();
    }
}

