/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforce;

import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.DeletedRecord;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.GetDeletedResult;
import com.sforce.soap.partner.GetUpdatedResult;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.fault.ExceptionCode;
import com.sforce.soap.partner.fault.LoginFault;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.bind.XmlObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceRecordValue;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SalesforceConnection {
    private static final FieldType ID_FIELD_TYPE = FieldType.id;
    private static final FieldType REFERENCE_FIELD_TYPE = FieldType.reference;
    private static final Class<?> PKG = SalesforceConnection.class;
    private String url;
    private String username;
    private String password;
    private String module;
    private int timeout;
    private PartnerConnection binding;
    private LoginResult loginResult;
    private GetUserInfoResult userInfo;
    private String sql;
    private Date serverTimestamp;
    private QueryResult qr;
    private GregorianCalendar startDate;
    private GregorianCalendar endDate;
    private SObject[] sObjects;
    private int recordsFilter;
    private String fieldsList;
    private int queryResultSize;
    private int recordsCount;
    private boolean useCompression;
    private boolean rollbackAllChangesOnError;
    private boolean queryAll;
    private HashMap<String, Date> getDeletedList;
    private ILogChannel log;

    public SalesforceConnection(ILogChannel logInterface, String url, String username, String password) throws HopException {
        this.log = logInterface == null ? HopLogStore.getLogChannelFactory().create((Object)this) : logInterface;
        this.url = url;
        this.setUsername(username);
        this.setPassword(password);
        this.setTimeOut(0);
        this.binding = null;
        this.loginResult = null;
        this.userInfo = null;
        this.sql = null;
        this.serverTimestamp = null;
        this.qr = null;
        this.startDate = null;
        this.endDate = null;
        this.sObjects = null;
        this.recordsFilter = 0;
        this.fieldsList = null;
        this.queryResultSize = 0;
        this.recordsCount = 0;
        this.setUsingCompression(false);
        this.setRollbackAllChangesOnError(false);
        if (Utils.isEmpty((CharSequence)this.getURL())) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.TargetURLMissing.Error", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.getUsername())) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.UsernameMissing.Error", (String[])new String[0]));
        }
        if (this.log.isDetailed()) {
            logInterface.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.NewConnection", (String[])new String[0]));
        }
    }

    public boolean isRollbackAllChangesOnError() {
        return this.rollbackAllChangesOnError;
    }

    public void setRollbackAllChangesOnError(boolean value) {
        this.rollbackAllChangesOnError = value;
    }

    public boolean isQueryAll() {
        return this.queryAll;
    }

    public void setQueryAll(boolean value) {
        this.queryAll = value;
    }

    public void setCalendar(int recordsFilter, GregorianCalendar startDate, GregorianCalendar endDate) throws HopException {
        this.startDate = startDate;
        this.endDate = endDate;
        this.recordsFilter = recordsFilter;
        if (this.startDate == null || this.endDate == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.EmptyStartDateOrEndDate", (String[])new String[0]));
        }
        if (this.startDate.getTime().compareTo(this.endDate.getTime()) >= 0) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.WrongDates", (String[])new String[0]));
        }
        long diffDays = (this.endDate.getTime().getTime() - this.startDate.getTime().getTime()) / 86400000L;
        if (diffDays > 30L) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.StartDateTooOlder", (String[])new String[0]));
        }
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public void setFieldsList(String fieldsList) {
        this.fieldsList = fieldsList;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getURL() {
        return this.url;
    }

    public String getSQL() {
        return this.sql;
    }

    public Date getServerTimestamp() {
        return this.serverTimestamp;
    }

    public String getModule() {
        return this.module;
    }

    public QueryResult getQueryResult() {
        return this.qr;
    }

    public PartnerConnection createBinding(ConnectorConfig config) throws ConnectionException {
        if (this.binding == null) {
            this.binding = new PartnerConnection(config);
        }
        return this.binding;
    }

    public PartnerConnection getBinding() {
        return this.binding;
    }

    public void setTimeOut(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeOut() {
        return this.timeout;
    }

    public boolean isUsingCompression() {
        return this.useCompression;
    }

    public void setUsingCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public void connect() throws HopException {
        ConnectorConfig config = new ConnectorConfig();
        config.setAuthEndpoint(this.getURL());
        config.setServiceEndpoint(this.getURL());
        config.setUsername(this.getUsername());
        config.setPassword(this.getPassword());
        config.setCompression(this.isUsingCompression());
        config.setManualLogin(true);
        String proxyUrl = System.getProperty("http.proxyHost", null);
        if (StringUtils.isNotEmpty((String)proxyUrl)) {
            int proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            String proxyUser = System.getProperty("http.proxyUser", null);
            String proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)System.getProperty("http.proxyPassword", null));
            config.setProxy(proxyUrl, proxyPort);
            config.setProxyUsername(proxyUser);
            config.setProxyPassword(proxyPassword);
        }
        if (this.getTimeOut() > 0) {
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.SettingTimeout", (String[])new String[]{"" + this.timeout}));
            }
            config.setConnectionTimeout(this.getTimeOut());
            config.setReadTimeout(this.getTimeOut());
        }
        try {
            PartnerConnection pConnection = this.createBinding(config);
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.LoginURL", (String[])new String[]{config.getAuthEndpoint()}));
            }
            if (this.isRollbackAllChangesOnError()) {
                pConnection.setAllOrNoneHeader(true);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.LoginNow", (String[])new String[0]));
                this.log.logDetailed("----------------------------------------->");
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.LoginURL", (String[])new String[]{this.getURL()}));
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.LoginUsername", (String[])new String[]{this.getUsername()}));
                if (this.getModule() != null) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.LoginModule", (String[])new String[]{this.getModule()}));
                }
                this.log.logDetailed("<-----------------------------------------");
            }
            this.loginResult = pConnection.login(config.getUsername(), Encr.decryptPasswordOptionallyEncrypted((String)config.getPassword()));
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.SessionId", (String[])new String[0]) + " : " + this.loginResult.getSessionId());
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.NewServerURL", (String[])new String[0]) + " : " + this.loginResult.getServerUrl());
            }
            pConnection.setSessionHeader(this.loginResult.getSessionId());
            config.setServiceEndpoint(this.loginResult.getServerUrl());
            this.userInfo = pConnection.getUserInfo();
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.UserInfos", (String[])new String[0]) + " : " + this.userInfo.getUserFullName());
                this.log.logDebug("----------------------------------------->");
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.UserName", (String[])new String[0]) + " : " + this.userInfo.getUserFullName());
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.UserEmail", (String[])new String[0]) + " : " + this.userInfo.getUserEmail());
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.UserLanguage", (String[])new String[0]) + " : " + this.userInfo.getUserLanguage());
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.UserOrganization", (String[])new String[0]) + " : " + this.userInfo.getOrganizationName());
                this.log.logDebug("<-----------------------------------------");
            }
            this.serverTimestamp = pConnection.getServerTimestamp().getTimestamp().getTime();
            if (this.log.isDebug()) {
                BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.ServerTimestamp", (Object[])new Object[]{this.getServerTimestamp()});
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.Connected", (String[])new String[0]));
            }
        }
        catch (LoginFault ex) {
            ExceptionCode exCode = ex.getExceptionCode();
            if (exCode == ExceptionCode.FUNCTIONALITY_NOT_ENABLED || exCode == ExceptionCode.INVALID_CLIENT || exCode == ExceptionCode.INVALID_LOGIN || exCode == ExceptionCode.LOGIN_DURING_RESTRICTED_DOMAIN || exCode == ExceptionCode.LOGIN_DURING_RESTRICTED_TIME || exCode == ExceptionCode.ORG_LOCKED || exCode == ExceptionCode.PASSWORD_LOCKOUT || exCode == ExceptionCode.SERVER_UNAVAILABLE || exCode == ExceptionCode.TRIAL_EXPIRED || exCode == ExceptionCode.UNSUPPORTED_CLIENT) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.InvalidUsernameOrPassword", (String[])new String[0]));
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.Connection", (String[])new String[0]), (Throwable)ex);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.Connection", (String[])new String[0]), (Throwable)e);
        }
    }

    public void query(boolean specifyQuery) throws HopException {
        if (this.getBinding() == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Exception.CanNotGetBiding", (String[])new String[0]));
        }
        try {
            if (!specifyQuery) {
                DescribeSObjectResult describeSObjectResult = this.getBinding().describeSObject(this.getModule());
                if (describeSObjectResult == null) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorGettingObject", (String[])new String[0]));
                }
                if (!describeSObjectResult.isQueryable()) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ObjectNotQueryable", (String[])new String[]{this.module}));
                }
                if (!(this.recordsFilter != 1 && this.recordsFilter != 2 || describeSObjectResult.isReplicateable())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.ObjectNotReplicable", (String[])new String[]{this.getModule()}));
                }
            }
            if (this.getSQL() != null && this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.SQLString", (String[])new String[0]) + " : " + this.getSQL());
            }
            switch (this.recordsFilter) {
                case 1: {
                    int nr;
                    GetUpdatedResult updatedRecords = this.getBinding().getUpdated(this.getModule(), (Calendar)this.startDate, (Calendar)this.endDate);
                    if (updatedRecords.getIds() == null || (nr = updatedRecords.getIds().length) <= 0) break;
                    String[] ids = updatedRecords.getIds();
                    if (nr > 2000) {
                        this.sObjects = new SObject[nr];
                        ArrayList<String> list = new ArrayList<String>();
                        int desPos = 0;
                        for (int i = 0; i < nr; ++i) {
                            list.add(updatedRecords.getIds()[i]);
                            if (i % 2000 != 0 && i != nr - 1) continue;
                            SObject[] s = this.getBinding().retrieve(this.fieldsList, this.getModule(), list.toArray(new String[list.size()]));
                            System.arraycopy(s, 0, this.sObjects, desPos, s.length);
                            desPos += s.length;
                            s = null;
                            list = new ArrayList();
                        }
                    } else {
                        this.sObjects = this.getBinding().retrieve(this.fieldsList, this.getModule(), ids);
                    }
                    if (this.sObjects == null) break;
                    this.queryResultSize = this.sObjects.length;
                    break;
                }
                case 2: {
                    GetDeletedResult deletedRecordsResult = this.getBinding().getDeleted(this.getModule(), (Calendar)this.startDate, (Calendar)this.endDate);
                    DeletedRecord[] deletedRecords = deletedRecordsResult.getDeletedRecords();
                    if (this.log.isDebug()) {
                        this.log.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"SalesforceConnection.DeletedRecordsFound", (String[])new String[]{String.valueOf(deletedRecords == null ? 0 : deletedRecords.length)})});
                    }
                    if (deletedRecords == null || deletedRecords.length <= 0) break;
                    this.getDeletedList = new HashMap();
                    for (DeletedRecord dr : deletedRecords) {
                        this.getDeletedList.put(dr.getId(), dr.getDeletedDate().getTime());
                    }
                    this.qr = this.getBinding().queryAll(this.getSQL());
                    this.sObjects = this.getQueryResult().getRecords();
                    if (this.sObjects == null) break;
                    this.queryResultSize = this.sObjects.length;
                    break;
                }
                default: {
                    this.qr = this.isQueryAll() ? this.getBinding().queryAll(this.getSQL()) : this.getBinding().query(this.getSQL());
                    this.sObjects = this.getQueryResult().getRecords();
                    this.queryResultSize = this.getQueryResult().getSize();
                }
            }
            if (this.sObjects != null) {
                this.recordsCount = this.sObjects.length;
            }
        }
        catch (Exception e) {
            this.log.logError(Const.getStackTracker((Throwable)e));
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Exception.Query", (String[])new String[0]), (Throwable)e);
        }
    }

    public void close() throws HopException {
        try {
            if (!this.getQueryResult().isDone()) {
                this.qr.setDone(true);
                this.qr = null;
            }
            if (this.sObjects != null) {
                this.sObjects = null;
            }
            if (this.binding != null) {
                this.binding = null;
            }
            if (this.loginResult != null) {
                this.loginResult = null;
            }
            if (this.userInfo != null) {
                this.userInfo = null;
            }
            if (this.getDeletedList != null) {
                this.getDeletedList.clear();
                this.getDeletedList = null;
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.ConnectionClosed", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.ClosingConnection", (String[])new String[0]), (Throwable)e);
        }
    }

    public int getQueryResultSize() {
        return this.queryResultSize;
    }

    public int getRecordsCount() {
        return this.recordsCount;
    }

    public SalesforceRecordValue getRecord(int recordIndex) {
        int index = recordIndex;
        SObject con = this.sObjects[index];
        SalesforceRecordValue retval = new SalesforceRecordValue(index);
        if (con == null) {
            return null;
        }
        if (this.recordsFilter == 2) {
            if (this.getDeletedList.containsKey(con.getId())) {
                retval.setRecordValue(con);
                retval.setDeletionDate(this.getDeletedList.get(con.getId()));
            } else if (index < this.getRecordsCount() - 1) {
                while (con != null && index < this.getRecordsCount() - 1 && !this.getDeletedList.containsKey(con.getId())) {
                    con = this.sObjects[++index];
                }
                retval.setRecordIndexChanges(true);
                retval.setRecordIndex(index);
                if (con != null && SalesforceConnection.getChildren(con)[index] != null && this.getDeletedList.containsKey(con.getId())) {
                    retval.setRecordValue(con);
                    retval.setDeletionDate(this.getDeletedList.get(con.getId()));
                }
            }
            retval.setAllRecordsProcessed(index >= this.getRecordsCount() - 1);
        } else {
            retval.setRecordValue(con);
        }
        return retval;
    }

    public String getRecordValue(SObject con, String fieldname) throws HopException {
        String[] fieldHierarchy = fieldname.split("\\.");
        if (con == null) {
            return null;
        }
        XmlObject element = this.getMessageElementForHierarchy(con, fieldHierarchy);
        if (element != null) {
            Object object = element.getValue();
            if (object != null) {
                if (object instanceof QueryResult) {
                    return this.buildJsonQueryResult((QueryResult)object);
                }
                return String.valueOf(object);
            }
            return (String)element.getValue();
        }
        return null;
    }

    private XmlObject getMessageElementForHierarchy(SObject con, String[] fieldHierarchy) {
        int lastIndex = fieldHierarchy.length - 1;
        SObject currentSObject = con;
        block0: for (int index = 0; index <= lastIndex; ++index) {
            for (XmlObject element : SalesforceConnection.getChildren(currentSObject)) {
                if (!element.getName().getLocalPart().equals(fieldHierarchy[index])) continue;
                if (index == lastIndex) {
                    return element;
                }
                if (!(element instanceof SObject)) continue block0;
                currentSObject = (SObject)element;
                continue block0;
            }
        }
        return null;
    }

    private String buildJsonQueryResult(QueryResult queryResult) throws HopException {
        JSONArray list = new JSONArray();
        for (SObject sobject : queryResult.getRecords()) {
            list.add((Object)this.buildJSONSObject(sobject));
        }
        StringWriter sw = new StringWriter();
        try {
            list.writeJSONString((Writer)sw);
        }
        catch (IOException e) {
            throw new HopException((Throwable)e);
        }
        return sw.toString();
    }

    private JSONObject buildJSONSObject(SObject sobject) {
        JSONObject jsonObject = new JSONObject();
        for (XmlObject element : SalesforceConnection.getChildren(sobject)) {
            Object object = element.getValue();
            if (object != null && object instanceof SObject) {
                jsonObject.put((Object)element.getName(), (Object)this.buildJSONSObject((SObject)object));
                continue;
            }
            jsonObject.put((Object)element.getName(), element.getValue());
        }
        return jsonObject;
    }

    public XmlObject[] getElements() throws Exception {
        SObject con;
        XmlObject[] result = null;
        this.qr = this.getBinding().query(this.getSQL());
        if (this.qr.getSize() > 0 && (con = this.getQueryResult().getRecords()[0]) != null) {
            result = SalesforceConnection.getChildren(con);
        }
        return result;
    }

    public boolean queryMore() throws HopException {
        try {
            if (!this.getQueryResult().isDone()) {
                this.qr = this.getBinding().queryMore(this.getQueryResult().getQueryLocator());
                this.sObjects = this.getQueryResult().getRecords();
                if (this.sObjects != null) {
                    this.recordsCount = this.sObjects.length;
                }
                this.queryResultSize = this.getQueryResult().getSize();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.QueringMore", (String[])new String[0]), (Throwable)e);
        }
    }

    public String[] getAllAvailableObjects(boolean onlyQueryableObjects) throws HopException {
        DescribeGlobalResult dgr = null;
        ArrayList<String> objects = null;
        DescribeGlobalSObjectResult[] sobjectResults = null;
        try {
            dgr = this.getBinding().describeGlobal();
            sobjectResults = dgr.getSobjects();
            int nrObjects = dgr.getSobjects().length;
            objects = new ArrayList<String>();
            for (int i = 0; i < nrObjects; ++i) {
                DescribeGlobalSObjectResult o = dgr.getSobjects()[i];
                if ((!onlyQueryableObjects || !o.isQueryable()) && onlyQueryableObjects) continue;
                objects.add(o.getName());
            }
            String[] stringArray = objects.toArray(new String[objects.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.GettingModules", (String[])new String[0]), (Throwable)e);
        }
        finally {
            if (dgr != null) {
                dgr = null;
            }
            if (objects != null) {
                objects.clear();
                objects = null;
            }
            if (sobjectResults != null) {
                sobjectResults = null;
            }
        }
    }

    public Field[] getObjectFields(String objectName) throws HopException {
        DescribeSObjectResult describeSObjectResult = null;
        try {
            describeSObjectResult = this.getBinding().describeSObject(objectName);
            if (describeSObjectResult == null) {
                Field[] fieldArray = null;
                return fieldArray;
            }
            if (!describeSObjectResult.isQueryable()) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ObjectNotQueryable", (String[])new String[]{this.module}));
            }
            Field[] fieldArray = describeSObjectResult.getFields();
            return fieldArray;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.GettingModuleFields", (String[])new String[]{this.module}), (Throwable)e);
        }
        finally {
            if (describeSObjectResult != null) {
                describeSObjectResult = null;
            }
        }
    }

    public Field[] getObjectFields(String objectName, boolean excludeNonUpdatableFields) throws HopException {
        Field[] fieldList = this.getObjectFields(objectName);
        if (excludeNonUpdatableFields) {
            ArrayList<Field> finalFieldList = new ArrayList<Field>();
            for (Field f : fieldList) {
                if (!this.isIdField(f) && (f.isCalculated() || !f.isUpdateable())) continue;
                finalFieldList.add(f);
            }
            fieldList = finalFieldList.toArray(new Field[finalFieldList.size()]);
        }
        return fieldList;
    }

    private boolean isIdField(Field field) {
        return field.getType() == ID_FIELD_TYPE;
    }

    private boolean isReferenceField(Field field) {
        return field.getType() == REFERENCE_FIELD_TYPE;
    }

    public String[] getFields(String objectName) throws HopException {
        return this.getFields(this.getObjectFields(objectName));
    }

    public String[] getFields(String objectName, boolean excludeNonUpdatableFields) throws HopException {
        return this.getFields(this.getObjectFields(objectName, excludeNonUpdatableFields), excludeNonUpdatableFields);
    }

    public String[] getFields(Field[] fields) throws HopException {
        if (fields != null) {
            int nrFields = fields.length;
            String[] fieldsMapp = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Field field = fields[i];
                fieldsMapp[i] = field.getName();
            }
            return fieldsMapp;
        }
        return null;
    }

    public String[] getFields(Field[] fields, boolean excludeNonUpdatableFields) throws HopException {
        if (fields != null) {
            ArrayList<String> fieldsList = new ArrayList<String>(fields.length);
            for (Field field : fields) {
                Field[] referenceObjectFields;
                fieldsList.add(field.getName());
                if (!this.isReferenceField(field)) continue;
                String referenceTo = field.getReferenceTo()[0];
                for (Field f : referenceObjectFields = this.getObjectFields(referenceTo, excludeNonUpdatableFields)) {
                    if (!f.isIdLookup() || this.isIdField(f)) continue;
                    fieldsList.add(String.format("%s:%s/%s", referenceTo, f.getName(), field.getRelationshipName()));
                }
            }
            return fieldsList.toArray(new String[fieldsList.size()]);
        }
        return null;
    }

    public UpsertResult[] upsert(String upsertField, SObject[] sfBuffer) throws HopException {
        try {
            return this.getBinding().upsert(upsertField, sfBuffer);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorUpsert", (Object[])new Object[]{e}));
        }
    }

    public SaveResult[] insert(SObject[] sfBuffer) throws HopException {
        try {
            ArrayList<SObject> normalizedSfBuffer = new ArrayList<SObject>();
            for (SObject part : sfBuffer) {
                if (part == null) continue;
                normalizedSfBuffer.add(part);
            }
            return this.getBinding().create(normalizedSfBuffer.toArray(new SObject[normalizedSfBuffer.size()]));
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorInsert", (Object[])new Object[]{e}));
        }
    }

    public SaveResult[] update(SObject[] sfBuffer) throws HopException {
        try {
            return this.getBinding().update(sfBuffer);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorUpdate", (Object[])new Object[]{e}));
        }
    }

    public DeleteResult[] delete(String[] id) throws HopException {
        try {
            return this.getBinding().delete(id);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorDelete", (Object[])new Object[]{e}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmlObject createMessageElement(String name, Object value, boolean useExternalKey) throws Exception {
        XmlObject me = null;
        if (!useExternalKey) return SalesforceConnection.fromTemplateElement(name, value, true);
        int indexOfType = name.indexOf(":");
        if (indexOfType <= 0) throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.UnableToFindObjectType", (String[])new String[0]));
        String type = name.substring(0, indexOfType);
        String extIdName = null;
        String lookupField = null;
        String rest = name.substring(indexOfType + 1, name.length());
        int indexOfExtId = rest.indexOf("/");
        if (indexOfExtId > 0) {
            extIdName = rest.substring(0, indexOfExtId);
            lookupField = rest.substring(indexOfExtId + 1, rest.length());
            return SalesforceConnection.createForeignKeyElement(type, lookupField, extIdName, value);
        } else {
            lookupField = extIdName = rest;
        }
        return SalesforceConnection.createForeignKeyElement(type, lookupField, extIdName, value);
    }

    private static XmlObject createForeignKeyElement(String type, String lookupField, String extIdName, Object extIdValue) throws Exception {
        XmlObject me = SalesforceConnection.fromTemplateElement(lookupField, null, false);
        me.addField("type", (Object)type);
        me.addField(extIdName, extIdValue);
        return me;
    }

    public static XmlObject fromTemplateElement(String name, Object value, boolean setValue) throws SOAPException {
        XmlObject me = new XmlObject();
        if (setValue) {
            me.setValue(value);
        }
        me.setName(new QName(name));
        return me;
    }

    public static XmlObject[] getChildren(SObject object) {
        List<String> reservedFieldNames = Arrays.asList("type", "fieldsToNull");
        if (object == null) {
            return null;
        }
        ArrayList<XmlObject> children = new ArrayList<XmlObject>();
        Iterator iterator = object.getChildren();
        while (iterator.hasNext()) {
            XmlObject child = (XmlObject)iterator.next();
            if (child.getName().getNamespaceURI().equals("urn:sobject.partner.soap.sforce.com") && reservedFieldNames.contains(child.getName().getLocalPart())) continue;
            children.add(child);
        }
        if (children.isEmpty()) {
            return null;
        }
        return children.toArray(new XmlObject[children.size()]);
    }
}

