/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kinesis;

import java.util.List;
import org.apache.hop.beam.transforms.kinesis.BeamKinesisProduce;
import org.apache.hop.beam.transforms.kinesis.BeamKinesisProduceMeta;
import org.apache.hop.beam.transforms.kinesis.KinesisConfigOption;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BeamKinesisProduceDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = BeamKinesisProduce.class;
    private final BeamKinesisProduceMeta input;
    private TextVar wSecretKey;
    private TextVar wAccessKey;
    private TextVar wStreamName;
    private TextVar wDataField;
    private ComboVar wDataType;
    private TextVar wPartitionKey;
    private TableView wConfigOptions;

    public BeamKinesisProduceDialog(Shell parent, IVariables variables, BeamKinesisProduceMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamKinesisProduceDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlAccessKey = new Label((Composite)this.shell, 131072);
        wlAccessKey.setText(BaseMessages.getString(PKG, (String)"BeamKinesisProduceDialog.AccessKey", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAccessKey);
        FormData fdlAccessKey = new FormData();
        fdlAccessKey.left = new FormAttachment(0, 0);
        fdlAccessKey.top = new FormAttachment((Control)lastControl, margin);
        fdlAccessKey.right = new FormAttachment(middle, -margin);
        wlAccessKey.setLayoutData((Object)fdlAccessKey);
        this.wAccessKey = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wAccessKey.setEchoChar('*');
        PropsUi.setLook((Widget)this.wAccessKey);
        FormData fdAccessKey = new FormData();
        fdAccessKey.left = new FormAttachment(middle, 0);
        fdAccessKey.top = new FormAttachment((Control)wlAccessKey, 0, 0x1000000);
        fdAccessKey.right = new FormAttachment(100, 0);
        this.wAccessKey.setLayoutData((Object)fdAccessKey);
        lastControl = this.wAccessKey;
        Label wlSecretKey = new Label((Composite)this.shell, 131072);
        wlSecretKey.setText(BaseMessages.getString(PKG, (String)"BeamKinesisProduceDialog.SecretKey", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSecretKey);
        FormData fdlSecretKey = new FormData();
        fdlSecretKey.left = new FormAttachment(0, 0);
        fdlSecretKey.top = new FormAttachment((Control)lastControl, margin);
        fdlSecretKey.right = new FormAttachment(middle, -margin);
        wlSecretKey.setLayoutData((Object)fdlSecretKey);
        this.wSecretKey = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wSecretKey.setEchoChar('*');
        PropsUi.setLook((Widget)this.wSecretKey);
        FormData fdSecretKey = new FormData();
        fdSecretKey.left = new FormAttachment(middle, 0);
        fdSecretKey.top = new FormAttachment((Control)wlSecretKey, 0, 0x1000000);
        fdSecretKey.right = new FormAttachment(100, 0);
        this.wSecretKey.setLayoutData((Object)fdSecretKey);
        lastControl = this.wSecretKey;
        Label wlStreamName = new Label((Composite)this.shell, 131072);
        wlStreamName.setText(BaseMessages.getString(PKG, (String)"BeamKinesisProduceDialog.StreamName", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStreamName);
        FormData fdlStreamName = new FormData();
        fdlStreamName.left = new FormAttachment(0, 0);
        fdlStreamName.top = new FormAttachment((Control)lastControl, margin);
        fdlStreamName.right = new FormAttachment(middle, -margin);
        wlStreamName.setLayoutData((Object)fdlStreamName);
        this.wStreamName = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wStreamName);
        FormData fdStreamName = new FormData();
        fdStreamName.left = new FormAttachment(middle, 0);
        fdStreamName.top = new FormAttachment((Control)wlStreamName, 0, 0x1000000);
        fdStreamName.right = new FormAttachment(100, 0);
        this.wStreamName.setLayoutData((Object)fdStreamName);
        lastControl = this.wStreamName;
        Label wlDataField = new Label((Composite)this.shell, 131072);
        wlDataField.setText(BaseMessages.getString(PKG, (String)"BeamKinesisProduceDialog.DataField", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataField);
        FormData fdlDataField = new FormData();
        fdlDataField.left = new FormAttachment(0, 0);
        fdlDataField.top = new FormAttachment((Control)lastControl, margin);
        fdlDataField.right = new FormAttachment(middle, -margin);
        wlDataField.setLayoutData((Object)fdlDataField);
        this.wDataField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDataField);
        FormData fdDataField = new FormData();
        fdDataField.left = new FormAttachment(middle, 0);
        fdDataField.top = new FormAttachment((Control)wlDataField, 0, 0x1000000);
        fdDataField.right = new FormAttachment(100, 0);
        this.wDataField.setLayoutData((Object)fdDataField);
        lastControl = this.wDataField;
        Label wlDataType = new Label((Composite)this.shell, 131072);
        wlDataType.setText(BaseMessages.getString(PKG, (String)"BeamKinesisProduceDialog.DataType", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataType);
        FormData fdlDataType = new FormData();
        fdlDataType.left = new FormAttachment(0, 0);
        fdlDataType.top = new FormAttachment((Control)lastControl, margin);
        fdlDataType.right = new FormAttachment(middle, -margin);
        wlDataType.setLayoutData((Object)fdlDataType);
        this.wDataType = new ComboVar(this.variables, (Composite)this.shell, 18436);
        this.wDataType.setItems(new String[]{"String"});
        PropsUi.setLook((Widget)this.wDataType);
        FormData fdDataType = new FormData();
        fdDataType.left = new FormAttachment(middle, 0);
        fdDataType.top = new FormAttachment((Control)wlDataType, 0, 0x1000000);
        fdDataType.right = new FormAttachment(100, 0);
        this.wDataType.setLayoutData((Object)fdDataType);
        lastControl = this.wDataType;
        Label wlPartitionKey = new Label((Composite)this.shell, 131072);
        wlPartitionKey.setText(BaseMessages.getString(PKG, (String)"BeamKinesisProduceDialog.PartitionKey", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPartitionKey);
        FormData fdlPartitionKey = new FormData();
        fdlPartitionKey.left = new FormAttachment(0, 0);
        fdlPartitionKey.top = new FormAttachment((Control)lastControl, margin);
        fdlPartitionKey.right = new FormAttachment(middle, -margin);
        wlPartitionKey.setLayoutData((Object)fdlPartitionKey);
        this.wPartitionKey = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPartitionKey);
        FormData fdPartitionKey = new FormData();
        fdPartitionKey.left = new FormAttachment(middle, 0);
        fdPartitionKey.top = new FormAttachment((Control)wlPartitionKey, 0, 0x1000000);
        fdPartitionKey.right = new FormAttachment(100, 0);
        this.wPartitionKey.setLayoutData((Object)fdPartitionKey);
        lastControl = this.wPartitionKey;
        Label wlConfigOptions = new Label((Composite)this.shell, 131072);
        wlConfigOptions.setText(BaseMessages.getString(PKG, (String)"BeamKinesisProduceDialog.ConfigOptions", (String[])new String[0]));
        PropsUi.setLook((Widget)wlConfigOptions);
        FormData fdlConfigOptions = new FormData();
        fdlConfigOptions.left = new FormAttachment(0, 0);
        fdlConfigOptions.top = new FormAttachment((Control)lastControl, margin);
        fdlConfigOptions.right = new FormAttachment(middle, -margin);
        wlConfigOptions.setLayoutData((Object)fdlConfigOptions);
        lastControl = wlConfigOptions;
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamKinesisProduceDialog.ConfigOptions.Column.Property", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamKinesisProduceDialog.ConfigOptions.Column.Value", (String[])new String[0]), 1, false)};
        columns[0].setUsingVariables(true);
        columns[1].setUsingVariables(true);
        this.wConfigOptions = new TableView(this.variables, (Composite)this.shell, 0, columns, this.input.getConfigOptions().size(), null, this.props);
        PropsUi.setLook((Widget)this.wConfigOptions);
        FormData fdConfigOptions = new FormData();
        fdConfigOptions.left = new FormAttachment(0, 0);
        fdConfigOptions.right = new FormAttachment(100, 0);
        fdConfigOptions.top = new FormAttachment((Control)lastControl, margin);
        fdConfigOptions.bottom = new FormAttachment((Control)this.wOk, -margin * 2);
        this.wConfigOptions.setLayoutData((Object)fdConfigOptions);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wSecretKey.setText(Const.NVL((String)this.input.getSecretKey(), (String)""));
        this.wAccessKey.setText(Const.NVL((String)this.input.getAccessKey(), (String)""));
        this.wStreamName.setText(Const.NVL((String)this.input.getStreamName(), (String)""));
        this.wDataField.setText(Const.NVL((String)this.input.getDataField(), (String)""));
        this.wDataType.setText(Const.NVL((String)this.input.getDataType(), (String)""));
        this.wPartitionKey.setText(Const.NVL((String)this.input.getPartitionKey(), (String)""));
        for (int i = 0; i < this.input.getConfigOptions().size(); ++i) {
            KinesisConfigOption option = this.input.getConfigOptions().get(i);
            TableItem item = this.wConfigOptions.table.getItem(i);
            item.setText(1, Const.NVL((String)option.getParameter(), (String)""));
            item.setText(2, Const.NVL((String)option.getValue(), (String)""));
        }
        this.wConfigOptions.optimizeTableView();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamKinesisProduceMeta in) {
        this.transformName = this.wTransformName.getText();
        this.input.setAccessKey(this.wAccessKey.getText());
        this.input.setSecretKey(this.wSecretKey.getText());
        this.input.setStreamName(this.wStreamName.getText());
        this.input.setDataField(this.wDataField.getText());
        this.input.setDataType(this.wDataType.getText());
        this.input.setPartitionKey(this.wPartitionKey.getText());
        in.getConfigOptions().clear();
        List nonEmptyItems = this.wConfigOptions.getNonEmptyItems();
        for (TableItem item : nonEmptyItems) {
            String parameter = item.getText(1);
            String value = item.getText(2);
            in.getConfigOptions().add(new KinesisConfigOption(parameter, value));
        }
        this.input.setChanged();
    }
}

