/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.hivecatalog;

import org.apache.hop.beam.transforms.hivecatalog.BeamHiveCatalogInput;
import org.apache.hop.beam.transforms.hivecatalog.BeamHiveCatalogInputMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BeamHiveCatalogInputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = BeamHiveCatalogInput.class;
    private final BeamHiveCatalogInputMeta input;
    int middle;
    int margin;
    private TextVar wMetastoreUri;
    private TextVar wMetastoreDatabase;
    private TextVar wMetastoreTable;

    public BeamHiveCatalogInputDialog(Shell parent, IVariables variables, BeamHiveCatalogInputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamHiveCatalogInputDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlMetastoreUri = new Label((Composite)this.shell, 131072);
        wlMetastoreUri.setText(BaseMessages.getString(PKG, (String)"BeamHiveCatalogInputDialog.MetaStoreUri", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMetastoreUri);
        FormData fdlmetastoreUri = new FormData();
        fdlmetastoreUri.left = new FormAttachment(0, 0);
        fdlmetastoreUri.top = new FormAttachment((Control)lastControl, this.margin);
        fdlmetastoreUri.right = new FormAttachment(this.middle, -this.margin);
        wlMetastoreUri.setLayoutData((Object)fdlmetastoreUri);
        this.wMetastoreUri = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wMetastoreUri);
        FormData fdMetastoreUri = new FormData();
        fdMetastoreUri.left = new FormAttachment(this.middle, 0);
        fdMetastoreUri.top = new FormAttachment((Control)wlMetastoreUri, 0, 0x1000000);
        fdMetastoreUri.right = new FormAttachment(100, 0);
        this.wMetastoreUri.setLayoutData((Object)fdMetastoreUri);
        lastControl = this.wMetastoreUri;
        Label wlMetastoreDatabase = new Label((Composite)this.shell, 131072);
        wlMetastoreDatabase.setText(BaseMessages.getString(PKG, (String)"BeamHiveCatalogInputDialog.MetaStoreDatabase", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMetastoreDatabase);
        FormData fdlmetastoredatabase = new FormData();
        fdlmetastoredatabase.left = new FormAttachment(0, 0);
        fdlmetastoredatabase.top = new FormAttachment((Control)lastControl, this.margin);
        fdlmetastoredatabase.right = new FormAttachment(this.middle, -this.margin);
        wlMetastoreDatabase.setLayoutData((Object)fdlmetastoredatabase);
        this.wMetastoreDatabase = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wMetastoreDatabase);
        FormData fdMetastoreDatabase = new FormData();
        fdMetastoreDatabase.left = new FormAttachment(this.middle, 0);
        fdMetastoreDatabase.top = new FormAttachment((Control)wlMetastoreDatabase, 0, 0x1000000);
        fdMetastoreDatabase.right = new FormAttachment(100, 0);
        this.wMetastoreDatabase.setLayoutData((Object)fdMetastoreDatabase);
        lastControl = this.wMetastoreDatabase;
        Label wlMetastoreTable = new Label((Composite)this.shell, 131072);
        wlMetastoreTable.setText(BaseMessages.getString(PKG, (String)"BeamHiveCatalogInputDialog.MetaStoreTable", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMetastoreTable);
        FormData fdlmetastoreTable = new FormData();
        fdlmetastoreTable.left = new FormAttachment(0, 0);
        fdlmetastoreTable.top = new FormAttachment((Control)lastControl, this.margin);
        fdlmetastoreTable.right = new FormAttachment(this.middle, -this.margin);
        wlMetastoreTable.setLayoutData((Object)fdlmetastoreTable);
        this.wMetastoreTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wMetastoreTable);
        FormData fdMetastoreTable = new FormData();
        fdMetastoreTable.left = new FormAttachment(this.middle, 0);
        fdMetastoreTable.top = new FormAttachment((Control)wlMetastoreTable, 0, 0x1000000);
        fdMetastoreTable.right = new FormAttachment(100, 0);
        this.wMetastoreTable.setLayoutData((Object)fdMetastoreTable);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, this.margin, null);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wMetastoreUri.setText(Const.NVL((String)this.input.getHiveMetastoreUris(), (String)""));
        this.wMetastoreDatabase.setText(Const.NVL((String)this.input.getHiveMetastoreDatabase(), (String)""));
        this.wMetastoreTable.setText(Const.NVL((String)this.input.getHiveMetastoreTable(), (String)""));
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(BeamHiveCatalogInputMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setHiveMetastoreUris(this.wMetastoreUri.getText());
        in.setHiveMetastoreDatabase(this.wMetastoreDatabase.getText());
        in.setHiveMetastoreTable(this.wMetastoreTable.getText());
        this.input.setChanged();
    }
}

