/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction.evaluator.amoro;

import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.OptimizingConfig;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.ServerTableIdentifier;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableConfiguration;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableRuntimeMeta;

public class TableRuntime {
    private final TableConfiguration tableConfiguration;
    private final ServerTableIdentifier tableIdentifier;
    private volatile long lastFullOptimizingTime;
    private volatile long lastMinorOptimizingTime;

    protected TableRuntime(TableRuntimeMeta tableRuntimeMeta) {
        this.tableIdentifier = ServerTableIdentifier.of(tableRuntimeMeta.getTableId(), tableRuntimeMeta.getCatalogName(), tableRuntimeMeta.getDbName(), tableRuntimeMeta.getTableName(), tableRuntimeMeta.getFormat());
        this.lastMinorOptimizingTime = tableRuntimeMeta.getLastMinorOptimizingTime();
        this.lastFullOptimizingTime = tableRuntimeMeta.getLastFullOptimizingTime();
        this.tableConfiguration = tableRuntimeMeta.getTableConfig();
    }

    public OptimizingConfig getOptimizingConfig() {
        return this.tableConfiguration.getOptimizingConfig();
    }

    public ServerTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public long getLastFullOptimizingTime() {
        return this.lastFullOptimizingTime;
    }

    public long getLastMinorOptimizingTime() {
        return this.lastMinorOptimizingTime;
    }
}

