/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorPipeline;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.service.CompactionService;
import org.apache.iceberg.Table;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.compaction.evaluator.CompactionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCompactionService
extends CompactionService {
    public static final String PARTITION_PATH = "compaction_partition_path";
    private static final String CLASS_NAME = IcebergCompactionService.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);

    public Boolean compact(org.apache.hadoop.hive.metastore.api.Table table, CompactionInfo ci) throws Exception {
        if (!(ci.isMajorCompaction() || ci.isMinorCompaction() || ci.isSmartOptimize())) {
            ci.errorMessage = String.format("Iceberg tables do not support %s compaction type", ci.type.name());
            LOG.error(ci.errorMessage + " Compaction info: {}", (Object)ci);
            this.msc.markRefused(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
            return false;
        }
        CompactorUtil.checkInterrupt((String)CLASS_NAME);
        Table icebergTable = IcebergTableUtil.getTable((Configuration)this.conf, table);
        CompactionEvaluator compactionEvaluator = new CompactionEvaluator(icebergTable, ci, table.getParameters());
        if (!compactionEvaluator.isEligibleForCompaction()) {
            LOG.info("Table={}{} doesn't meet requirements for compaction", (Object)table.getTableName(), ci.partName == null ? "" : ", partition=" + ci.partName);
            this.msc.markRefused(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
            return false;
        }
        if (ci.type == CompactionType.SMART_OPTIMIZE) {
            CompactionType type = compactionEvaluator.determineCompactionType();
            if (type == null) {
                this.msc.markRefused(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
                return false;
            }
            ci.type = type;
        }
        this.msc.updateCompactorState(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci), 0L);
        if (ci.runAs == null) {
            ci.runAs = TxnUtils.findUserToRunAs((String)table.getSd().getLocation(), (org.apache.hadoop.hive.metastore.api.Table)table, (Configuration)this.conf);
        }
        try {
            CompactorPipeline compactorPipeline = this.compactorFactory.getCompactorPipeline(table, this.conf, ci, this.msc);
            this.computeStats = this.collectGenericStats;
            LOG.info("Starting " + ci.type.toString() + " compaction for " + ci.getFullPartitionName() + ", id:" + ci.id + " with compute stats set to " + this.computeStats);
            CompactorContext compactorContext = new CompactorContext(this.conf, table, ci);
            compactorPipeline.execute(compactorContext);
            LOG.info("Completed " + ci.type.toString() + " compaction for " + ci.getFullPartitionName() + ", marking as compacted.");
            this.msc.markCleaned(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
        }
        catch (Throwable e) {
            this.computeStats = false;
            throw e;
        }
        return true;
    }

    public void cleanupResultDirs(CompactionInfo ci) {
    }
}

