/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hive.iceberg.org.apache.avro.LogicalType;
import org.apache.hive.iceberg.org.apache.avro.LogicalTypes;
import org.apache.hive.iceberg.org.apache.avro.io.DatumReader;
import org.apache.hive.iceberg.org.apache.avro.io.Decoder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroWithPartnerVisitor;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.data.GenericDataUtil;
import org.apache.iceberg.data.avro.GenericReaders;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;

public class PlannedDataReader<T>
implements DatumReader<T>,
SupportsRowPosition {
    private final Schema expectedSchema;
    private final Map<Integer, ?> idToConstant;
    private ValueReader<T> reader;

    public static <D> PlannedDataReader<D> create(Schema expectedSchema) {
        return PlannedDataReader.create(expectedSchema, ImmutableMap.of());
    }

    public static <D> PlannedDataReader<D> create(Schema expectedSchema, Map<Integer, ?> idToConstant) {
        return new PlannedDataReader(expectedSchema, idToConstant);
    }

    protected PlannedDataReader(Schema expectedSchema, Map<Integer, ?> idToConstant) {
        this.expectedSchema = expectedSchema;
        this.idToConstant = idToConstant;
    }

    @Override
    public void setSchema(org.apache.hive.iceberg.org.apache.avro.Schema fileSchema) {
        this.reader = (ValueReader)AvroWithPartnerVisitor.visit(this.expectedSchema.asStruct(), fileSchema, new ReadBuilder(this.idToConstant), AvroWithPartnerVisitor.FieldIDAccessors.get());
    }

    @Override
    public T read(T reuse, Decoder decoder) throws IOException {
        return this.reader.read(decoder, reuse);
    }

    @Override
    public void setRowPositionSupplier(Supplier<Long> posSupplier) {
        if (this.reader instanceof SupportsRowPosition) {
            ((SupportsRowPosition)((Object)this.reader)).setRowPositionSupplier(posSupplier);
        }
    }

    private static class ReadBuilder
    extends AvroWithPartnerVisitor<Type, ValueReader<?>> {
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(Map<Integer, ?> idToConstant) {
            this.idToConstant = idToConstant;
        }

        @Override
        public ValueReader<?> record(Type partner, org.apache.hive.iceberg.org.apache.avro.Schema record, List<ValueReader<?>> fieldReaders) {
            if (partner == null) {
                return ValueReaders.skipStruct(fieldReaders);
            }
            Types.StructType expected = partner.asStructType();
            List<Pair<Integer, ValueReader<?>>> readPlan = ValueReaders.buildReadPlan(expected, record, fieldReaders, this.idToConstant, GenericDataUtil::internalToGeneric);
            return GenericReaders.struct(readPlan, expected);
        }

        @Override
        public ValueReader<?> union(Type partner, org.apache.hive.iceberg.org.apache.avro.Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        @Override
        public ValueReader<?> array(Type ignored, org.apache.hive.iceberg.org.apache.avro.Schema array, ValueReader<?> elementReader) {
            return ValueReaders.array(elementReader);
        }

        @Override
        public ValueReader<?> arrayMap(Type ignored, org.apache.hive.iceberg.org.apache.avro.Schema map, ValueReader<?> keyReader, ValueReader<?> valueReader) {
            return ValueReaders.arrayMap(keyReader, valueReader);
        }

        @Override
        public ValueReader<?> map(Type ignored, org.apache.hive.iceberg.org.apache.avro.Schema map, ValueReader<?> valueReader) {
            return ValueReaders.map(ValueReaders.strings(), valueReader);
        }

        @Override
        public ValueReader<?> variant(Type partner, ValueReader<?> metadataReader, ValueReader<?> valueReader) {
            return ValueReaders.variants();
        }

        @Override
        public ValueReader<?> primitive(Type partner, org.apache.hive.iceberg.org.apache.avro.Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return GenericReaders.dates();
                    }
                    case "time-micros": {
                        return GenericReaders.times();
                    }
                    case "timestamp-micros": {
                        if (AvroSchemaUtil.isTimestamptz(primitive)) {
                            return GenericReaders.timestamptz();
                        }
                        return GenericReaders.timestamps();
                    }
                    case "timestamp-nanos": {
                        if (AvroSchemaUtil.isTimestamptz(primitive)) {
                            return GenericReaders.timestamptzNanos();
                        }
                        return GenericReaders.timestampNanos();
                    }
                    case "decimal": {
                        return ValueReaders.decimal(ValueReaders.decimalBytesReader(primitive), ((LogicalTypes.Decimal)logicalType).getScale());
                    }
                    case "uuid": {
                        return ValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    if (partner != null && partner.typeId() == Type.TypeID.LONG) {
                        return ValueReaders.intsAsLongs();
                    }
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    if (partner != null && partner.typeId() == Type.TypeID.DOUBLE) {
                        return ValueReaders.floatsAsDoubles();
                    }
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return ValueReaders.strings();
                }
                case FIXED: {
                    return ValueReaders.fixed(primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueReaders.byteBuffers();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

