/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionState;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetLatestCommittedCompactionInfoHandler
implements QueryHandler<GetLatestCommittedCompactionInfoResponse> {
    private final GetLatestCommittedCompactionInfoRequest rqst;

    public GetLatestCommittedCompactionInfoHandler(GetLatestCommittedCompactionInfoRequest rqst) {
        this.rqst = rqst;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT * FROM ( SELECT \"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_TYPE\" FROM \"COMPLETED_COMPACTIONS\"    WHERE \"CC_STATE\" = :succeeded UNION ALL SELECT \"CQ_ID\" AS \"CC_ID\", \"CQ_DATABASE\" AS \"CC_DATABASE\", \"CQ_TABLE\" AS \"CC_TABLE\", \"CQ_PARTITION\" AS \"CC_PARTITION\", \"CQ_TYPE\" AS \"CC_TYPE\" FROM \"COMPACTION_QUEUE\"    WHERE \"CQ_STATE\" = :readyForCleaning) AS compactions WHERE \"CC_DATABASE\" = :dbName AND \"CC_TABLE\" = :tableName AND (\"CC_PARTITION\" IN (:partitionNames) OR :emptyPartitionNames = TRUE) AND (\"CC_ID\" > :id OR :id IS NULL) ORDER BY \"CC_ID\" DESC";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("succeeded", (Object)CompactionState.SUCCEEDED.getSqlConst(), 1).addValue("readyForCleaning", (Object)CompactionState.READY_FOR_CLEANING.getSqlConst(), 1).addValue("dbName", (Object)this.rqst.getDbname()).addValue("tableName", (Object)this.rqst.getTablename()).addValue("emptyPartitionNames", (Object)CollectionUtils.isEmpty((Collection)this.rqst.getPartitionnames()), 16).addValue("partitionNames", (Object)(CollectionUtils.isEmpty((Collection)this.rqst.getPartitionnames()) ? null : this.rqst.getPartitionnames()), 12).addValue("id", this.rqst.isSetLastCompactionId() ? Long.valueOf(this.rqst.getLastCompactionId()) : null, -5);
    }

    public GetLatestCommittedCompactionInfoResponse extractData(ResultSet rs) throws SQLException, DataAccessException {
        GetLatestCommittedCompactionInfoResponse response = new GetLatestCommittedCompactionInfoResponse(new ArrayList());
        HashSet<String> partitionSet = new HashSet<String>();
        while (rs.next()) {
            CompactionInfoStruct lci = new CompactionInfoStruct();
            lci.setId(rs.getLong(1));
            lci.setDbname(rs.getString(2));
            lci.setTablename(rs.getString(3));
            String partition = rs.getString(4);
            if (!rs.wasNull()) {
                lci.setPartitionname(partition);
            }
            lci.setType(TxnUtils.dbCompactionType2ThriftType(rs.getString(5).charAt(0)));
            if (partitionSet.contains(partition)) continue;
            response.addToCompactions(lci);
            partitionSet.add(partition);
        }
        return response;
    }
}

