/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.commands;

import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedBatchCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedCommand;
import org.springframework.jdbc.core.ParameterizedPreparedStatementSetter;

public class InsertCompletedTxnComponentsCommand
implements ParameterizedBatchCommand<WriteEventInfo> {
    private final long txnId;
    private final char isUpdateDelete;
    private final List<WriteEventInfo> infos;

    public InsertCompletedTxnComponentsCommand(long txnId, char isUpdateDelete, List<WriteEventInfo> infos) {
        this.txnId = txnId;
        this.isUpdateDelete = isUpdateDelete;
        this.infos = infos;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) {
        return "INSERT INTO \"COMPLETED_TXN_COMPONENTS\" (\"CTC_TXNID\", \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\", \"CTC_WRITEID\", \"CTC_UPDATE_DELETE\") VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    public List<WriteEventInfo> getQueryParameters() {
        return this.infos;
    }

    @Override
    public ParameterizedPreparedStatementSetter<WriteEventInfo> getPreparedStatementSetter() {
        return (ps, argument) -> {
            ps.setLong(1, this.txnId);
            ps.setString(2, argument.getDatabase());
            ps.setString(3, argument.getTable());
            ps.setString(4, argument.getPartition());
            ps.setLong(5, argument.getWriteId());
            ps.setString(6, Character.toString(this.isUpdateDelete));
        };
    }

    @Override
    public Function<Integer, Boolean> resultPolicy() {
        return ParameterizedCommand.EXACTLY_ONE_ROW;
    }
}

