/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.thrift.TException;

public class FunctionBuilder {
    private String catName;
    private String dbName = "default";
    private String funcName = null;
    private String className = null;
    private String owner = null;
    private PrincipalType ownerType = PrincipalType.USER;
    private int createTime = (int)(System.currentTimeMillis() / 1000L);
    private FunctionType funcType = FunctionType.JAVA;
    private List<ResourceUri> resourceUris = new ArrayList<ResourceUri>();

    public FunctionBuilder setCatName(String catName) {
        this.catName = catName;
        return this;
    }

    public FunctionBuilder setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public FunctionBuilder inDb(Database db) {
        this.dbName = db.getName();
        this.catName = db.getCatalogName();
        return this;
    }

    public FunctionBuilder setName(String funcName) {
        this.funcName = funcName;
        return this;
    }

    public FunctionBuilder setClass(String className) {
        this.className = className;
        return this;
    }

    public FunctionBuilder setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public FunctionBuilder setOwnerType(PrincipalType ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    public FunctionBuilder setCreateTime(int createTime) {
        this.createTime = createTime;
        return this;
    }

    public FunctionBuilder setFunctionType(FunctionType funcType) {
        this.funcType = funcType;
        return this;
    }

    public FunctionBuilder setResourceUris(List<ResourceUri> resourceUris) {
        this.resourceUris = resourceUris;
        return this;
    }

    public FunctionBuilder addResourceUri(ResourceUri resourceUri) {
        this.resourceUris.add(resourceUri);
        return this;
    }

    public Function build(Configuration conf) throws MetaException {
        try {
            if (this.owner != null) {
                this.owner = SecurityUtils.getUser();
            }
        }
        catch (IOException e) {
            throw MetaStoreUtils.newMetaException((Exception)e);
        }
        if (this.catName == null) {
            this.catName = MetaStoreUtils.getDefaultCatalog((Configuration)conf);
        }
        Function f = new Function(this.funcName, this.dbName, this.className, this.owner, this.ownerType, this.createTime, this.funcType, this.resourceUris);
        f.setCatName(this.catName);
        return f;
    }

    public Function create(IMetaStoreClient client, Configuration conf) throws TException {
        Function f = this.build(conf);
        client.createFunction(f);
        return f;
    }
}

