/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.show;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Columns", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowColumnsDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEMA = "Field#string";
    private final String resFile;
    private final String tableName;
    private final String pattern;
    private final boolean sorted;

    public ShowColumnsDesc(Path resFile, String tableName, String pattern, boolean sorted) {
        this.resFile = resFile.toString();
        this.pattern = pattern;
        this.tableName = tableName;
        this.sorted = sorted;
    }

    @Explain(displayName="pattern", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getPattern() {
        return this.pattern;
    }

    @Explain(displayName="table name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    @Explain(displayName="sorted", explainLevels={Explain.Level.EXTENDED})
    public boolean isSorted() {
        return this.sorted;
    }
}

