/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr;

import java.nio.ByteBuffer;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.IpmiCommandName;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.AbstractIpmiRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public class GetSdrRequest
extends AbstractIpmiRequest {
    public static byte HEADER_LENGTH = (byte)5;
    public static int RECORD_ID_START = 1;
    final int reservationId;
    final int recordId;
    final byte offset;
    final byte byteToRead;

    public GetSdrRequest(int reservationId, int recordId, byte offset, byte byteToRead) {
        this.reservationId = reservationId;
        this.recordId = recordId;
        this.offset = offset;
        this.byteToRead = byteToRead;
    }

    @Override
    public int getDataWireLength(IpmiPacketContext context) {
        return 6;
    }

    @Override
    public void toWireData(IpmiPacketContext context, ByteBuffer buffer) {
        byte[] reservationIdBytes = ByteConvertUtils.intToLsMsByte(this.reservationId);
        buffer.put(reservationIdBytes[0]);
        buffer.put(reservationIdBytes[1]);
        byte[] recordIdBytes = ByteConvertUtils.intToLsMsByte(this.recordId);
        buffer.put(recordIdBytes[0]);
        buffer.put(recordIdBytes[1]);
        buffer.put(this.offset);
        buffer.put(this.byteToRead);
    }

    @Override
    public IpmiCommandName getCommandName() {
        return IpmiCommandName.GetSdr;
    }
}

