/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.scheduler;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.dto.CollectorInfo;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.manager.CollectorMonitorBind;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.manager.config.PrometheusProxyConfig;
import org.apache.hertzbeat.manager.dao.CollectorDao;
import org.apache.hertzbeat.manager.dao.CollectorMonitorBindDao;
import org.apache.hertzbeat.manager.dao.MonitorDao;
import org.apache.hertzbeat.manager.dao.ParamDao;
import org.apache.hertzbeat.manager.scheduler.CollectJobScheduling;
import org.apache.hertzbeat.manager.scheduler.CollectorScheduling;
import org.apache.hertzbeat.manager.service.AppService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Configuration
@Order(value=0x7FFFFFFE)
public class SchedulerInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SchedulerInit.class);
    @Autowired
    private CollectorScheduling collectorScheduling;
    @Autowired
    private CollectJobScheduling collectJobScheduling;
    private static final String MAIN_COLLECTOR_NODE_IP = "127.0.0.1";
    private static final String DEFAULT_COLLECTOR_VERSION = "DEBUG";
    @Autowired
    private AppService appService;
    @Autowired
    private MonitorDao monitorDao;
    @Autowired
    private ParamDao paramDao;
    @Autowired
    private CollectorDao collectorDao;
    @Autowired
    private CollectorMonitorBindDao collectorMonitorBindDao;
    @Autowired
    private PrometheusProxyConfig prometheusProxyConfig;

    @Override
    public void run(String ... args) throws Exception {
        List collectors = this.collectorDao.findAll().stream().peek(item -> item.setStatus((byte)1)).collect(Collectors.toList());
        this.collectorDao.saveAll((Iterable)collectors);
        CollectorInfo collectorInfo = CollectorInfo.builder().name("main-default-collector").ip(MAIN_COLLECTOR_NODE_IP).version(DEFAULT_COLLECTOR_VERSION).build();
        this.collectorScheduling.collectorGoOnline("main-default-collector", collectorInfo);
        List<Monitor> monitors = this.monitorDao.findMonitorsByStatusNotInAndJobIdNotNull(List.of(Byte.valueOf((byte)0)));
        Iterable monitorBinds = this.collectorMonitorBindDao.findAll();
        Map<Long, String> monitorIdCollectorMap = monitorBinds.stream().collect(Collectors.toMap(CollectorMonitorBind::getMonitorId, CollectorMonitorBind::getCollector));
        for (Monitor monitor : monitors) {
            try {
                boolean isStatic = "static".equals(monitor.getScrape()) || !StringUtils.hasText(monitor.getScrape());
                String app = isStatic ? monitor.getApp() : monitor.getScrape();
                Job appDefine = this.appService.getAppDefine(app);
                appDefine.setPrometheusProxyMode(this.prometheusProxyConfig.isPrometheusProxy());
                if (!isStatic) {
                    appDefine.setSd(true);
                }
                List<Param> params = this.paramDao.findParamsByMonitorId(monitor.getId());
                if ("prometheus".equals(monitor.getApp())) {
                    appDefine.setApp("_prometheus_" + monitor.getName());
                }
                appDefine.setId(monitor.getJobId());
                appDefine.setMonitorId(monitor.getId());
                appDefine.setDefaultInterval(monitor.getIntervals().intValue());
                appDefine.setCyclic(true);
                appDefine.setTimestamp(System.currentTimeMillis());
                Map<String, String> metadata = Map.of("instancename", monitor.getName(), "instancehost", monitor.getHost());
                appDefine.setMetadata(metadata);
                appDefine.setLabels(monitor.getLabels());
                appDefine.setAnnotations(monitor.getAnnotations());
                List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).collect(Collectors.toList());
                List<ParamDefine> paramDefaultValue = appDefine.getParams().stream().filter(item -> StringUtils.hasText(item.getDefaultValue())).toList();
                paramDefaultValue.forEach(defaultVar -> {
                    if (configmaps.stream().noneMatch(item -> item.getKey().equals(defaultVar.getField()))) {
                        Configmap configmap = new Configmap(defaultVar.getField(), defaultVar.getDefaultValue(), 1);
                        configmaps.add(configmap);
                    }
                });
                appDefine.setConfigmap(configmaps);
                String collector = monitorIdCollectorMap.get(monitor.getId());
                long jobId = this.collectJobScheduling.addAsyncCollectJob(appDefine, collector);
                monitor.setJobId(jobId);
                this.monitorDao.save(monitor);
            }
            catch (Exception e) {
                log.error("init monitor job: {} error,continue next monitor", (Object)monitor, (Object)e);
            }
        }
    }
}

