/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.sd;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.arrow.RowWrapper;
import org.apache.hertzbeat.common.entity.manager.CollectorMonitorBind;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.MonitorBind;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.manager.dao.CollectorMonitorBindDao;
import org.apache.hertzbeat.manager.dao.MonitorBindDao;
import org.apache.hertzbeat.manager.dao.MonitorDao;
import org.apache.hertzbeat.manager.dao.ParamDao;
import org.apache.hertzbeat.manager.scheduler.ManagerWorkerPool;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class ServiceDiscoveryWorker
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryWorker.class);
    private static final String FILED_HOST = "host";
    private static final String FILED_PORT = "port";
    private final MonitorService monitorService;
    private final ParamDao paramDao;
    private final MonitorDao monitorDao;
    private final MonitorBindDao monitorBindDao;
    private final CollectorMonitorBindDao collectorMonitorBindDao;
    private final CommonDataQueue dataQueue;
    private final ManagerWorkerPool workerPool;

    public ServiceDiscoveryWorker(MonitorService monitorService, ParamDao paramDao, MonitorDao monitorDao, MonitorBindDao monitorBindDao, CollectorMonitorBindDao collectorMonitorBindDao, CommonDataQueue dataQueue, ManagerWorkerPool workerPool) {
        this.monitorService = monitorService;
        this.paramDao = paramDao;
        this.monitorDao = monitorDao;
        this.monitorBindDao = monitorBindDao;
        this.collectorMonitorBindDao = collectorMonitorBindDao;
        this.dataQueue = dataQueue;
        this.workerPool = workerPool;
    }

    @Override
    public void afterPropertiesSet() {
        this.workerPool.executeJob(new SdUpdateTask());
    }

    private class SdUpdateTask
    implements Runnable {
        private SdUpdateTask() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    CollectRep.MetricsData metricsData = ServiceDiscoveryWorker.this.dataQueue.pollServiceDiscoveryData();
                    try {
                        Long monitorId = metricsData.getId();
                        Monitor mainMonitor = ServiceDiscoveryWorker.this.monitorDao.findById(monitorId).orElse(null);
                        if (mainMonitor == null) {
                            log.warn("No monitor found for id {}", (Object)monitorId);
                            continue;
                        }
                        Optional<CollectorMonitorBind> collectorBind = ServiceDiscoveryWorker.this.collectorMonitorBindDao.findCollectorMonitorBindByMonitorId(monitorId);
                        String collector = collectorBind.map(CollectorMonitorBind::getCollector).orElse(null);
                        List<Param> mainMonitorParams = ServiceDiscoveryWorker.this.paramDao.findParamsByMonitorId(monitorId);
                        Map<String, MonitorBind> subMonitorBindMap = ServiceDiscoveryWorker.this.monitorBindDao.findMonitorBindsByBizId(monitorId).stream().collect(Collectors.toMap(MonitorBind::getKeyStr, item -> item));
                        RowWrapper rowWrapper = metricsData.readRow();
                        HashMap fieldsValue = Maps.newHashMapWithExpectedSize(8);
                        String defaultPort = mainMonitorParams.stream().filter(param -> ServiceDiscoveryWorker.FILED_PORT.equals(param.getField())).findFirst().map(Param::getParamValue).orElse("");
                        while (rowWrapper.hasNextRow()) {
                            rowWrapper = rowWrapper.nextRow();
                            fieldsValue.clear();
                            rowWrapper.cellStream().forEach(cell -> {
                                String value = cell.getValue();
                                fieldsValue.put(cell.getField().getName(), value);
                            });
                            String host = (String)fieldsValue.get(ServiceDiscoveryWorker.FILED_HOST);
                            String port = fieldsValue.getOrDefault(ServiceDiscoveryWorker.FILED_PORT, defaultPort);
                            String keyStr = host + ":" + port;
                            if (subMonitorBindMap.containsKey(keyStr)) {
                                subMonitorBindMap.remove(keyStr);
                                continue;
                            }
                            Monitor newMonitor = mainMonitor.clone();
                            newMonitor.setId(null);
                            newMonitor.setHost(host);
                            newMonitor.setName(newMonitor.getName() + "-" + host + ":" + port);
                            newMonitor.setScrape("static");
                            newMonitor.setGmtCreate(LocalDateTime.now());
                            newMonitor.setGmtUpdate(LocalDateTime.now());
                            LinkedList<Param> newParams = new LinkedList<Param>();
                            for (Param param2 : mainMonitorParams) {
                                Param newParam = param2.clone();
                                newParam.setId(null);
                                newParam.setGmtUpdate(null);
                                newParam.setGmtCreate(null);
                                if (ServiceDiscoveryWorker.FILED_HOST.equals(newParam.getField())) {
                                    newParam.setParamValue(host);
                                } else if (ServiceDiscoveryWorker.FILED_PORT.equals(newParam.getField())) {
                                    newParam.setParamValue(port);
                                }
                                newParams.add(newParam);
                            }
                            ServiceDiscoveryWorker.this.monitorService.addMonitor(newMonitor, newParams, collector, null);
                            MonitorBind monitorBind = MonitorBind.builder().bizId(monitorId).monitorId(newMonitor.getId()).keyStr(keyStr).build();
                            ServiceDiscoveryWorker.this.monitorBindDao.save(monitorBind);
                        }
                        Set<Long> needCancelMonitorIdSet = subMonitorBindMap.values().stream().map(MonitorBind::getMonitorId).collect(Collectors.toSet());
                        ServiceDiscoveryWorker.this.monitorService.deleteMonitors(needCancelMonitorIdSet);
                    }
                    finally {
                        if (metricsData == null) continue;
                        metricsData.close();
                    }
                }
                catch (Exception exception) {
                    log.error(exception.getMessage(), exception);
                }
            }
        }
    }
}

