/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.WriteOp;
import io.greptime.common.util.Ensures;
import io.greptime.models.AuthInfo;
import io.greptime.models.Table;
import io.greptime.models.WriteTables;
import io.greptime.v1.Common;
import io.greptime.v1.Database;
import java.util.Collection;

public class TableHelper {
    public static Database.GreptimeRequest toGreptimeRequest(WriteTables writeTables, String database, AuthInfo authInfo) {
        Common.RequestHeader.Builder headerBuilder = Common.RequestHeader.newBuilder();
        if (database != null) {
            headerBuilder.setDbname(database);
        }
        if (authInfo != null) {
            headerBuilder.setAuthorization(authInfo.into());
        }
        Collection<Table> tables = writeTables.getTables();
        WriteOp writeOp = writeTables.getWriteOp();
        switch (writeOp) {
            case Insert: {
                Database.RowInsertRequests.Builder insertBuilder = Database.RowInsertRequests.newBuilder();
                for (Table t : tables) {
                    Ensures.ensure((t.pointCount() > 0 ? 1 : 0) != 0, (String)"No data to insert in table: %s", (Object[])new Object[]{t.tableName()});
                    insertBuilder.addInserts(t.intoRowInsertRequest());
                }
                return Database.GreptimeRequest.newBuilder().setHeader(headerBuilder.build()).setRowInserts(insertBuilder.build()).build();
            }
            case Delete: {
                Database.RowDeleteRequests.Builder deleteBuilder = Database.RowDeleteRequests.newBuilder();
                for (Table t : tables) {
                    Ensures.ensure((t.pointCount() > 0 ? 1 : 0) != 0, (String)"No data to delete in table: %s", (Object[])new Object[]{t.tableName()});
                    deleteBuilder.addDeletes(t.intoRowDeleteRequest());
                }
                return Database.GreptimeRequest.newBuilder().setHeader(headerBuilder.build()).setRowDeletes(deleteBuilder.build()).build();
            }
        }
        throw new IllegalArgumentException("Unsupported write operation: " + (Object)((Object)writeOp));
    }

    private TableHelper() {
    }
}

