/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.dto.PluginUpload;
import org.apache.hertzbeat.common.entity.manager.PluginMetadata;
import org.apache.hertzbeat.manager.pojo.dto.PluginParam;
import org.apache.hertzbeat.manager.pojo.dto.PluginParametersVO;
import org.apache.hertzbeat.manager.service.PluginService;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Plugin Manage API")
@RestController
@RequestMapping(path={"/api/plugin"}, produces={"application/json"})
public class PluginController {
    private final PluginService pluginService;

    @PostMapping
    @Operation(summary="upload plugin", description="upload plugin")
    public ResponseEntity<Message<Void>> uploadNewPlugin(@Valid PluginUpload pluginUpload) {
        this.pluginService.savePlugin(pluginUpload);
        return ResponseEntity.ok(Message.success("Add success"));
    }

    @GetMapping
    @Operation(summary="Get Plugins information", description="Obtain plugins information based on conditions")
    public ResponseEntity<Message<Page<PluginMetadata>>> getPlugins(@Parameter(description="plugin name search", example="status") @RequestParam(required=false) String search, @Parameter(description="List current page", example="0") @RequestParam(defaultValue="0") int pageIndex, @Parameter(description="Number of list pagination", example="8") @RequestParam(defaultValue="8") int pageSize) {
        Page<PluginMetadata> alertPage = this.pluginService.getPlugins(search, pageIndex, pageSize);
        return ResponseEntity.ok(Message.success(alertPage));
    }

    @DeleteMapping
    @Operation(summary="Delete plugins based on ID", description="Delete plugins based on ID")
    public ResponseEntity<Message<Void>> deletePlugins(@Parameter(description="Plugin IDs ", example="6565463543") @RequestParam(required=false) List<Long> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.pluginService.deletePlugins(new HashSet<Long>(ids));
        }
        return ResponseEntity.ok(Message.success("Delete success"));
    }

    @PutMapping
    @Operation(summary="Update enable status", description="Delete plugins based on ID")
    public ResponseEntity<Message<Void>> updatePluginStatus(@RequestBody PluginMetadata plugin) {
        this.pluginService.updateStatus(plugin);
        return ResponseEntity.ok(Message.success("Update success"));
    }

    @GetMapping(value={"/params/define"})
    @Operation(summary="get param define", description="get param define by jar path")
    public ResponseEntity<Message<PluginParametersVO>> getParamDefine(@RequestParam Long pluginMetadataId) {
        PluginParametersVO plugins = this.pluginService.getParamDefine(pluginMetadataId);
        return ResponseEntity.ok(Message.success(plugins));
    }

    @PostMapping(value={"/params"})
    @Operation(summary="get param define", description="get param define by jar path")
    public ResponseEntity<Message<Boolean>> saveParams(@RequestBody List<PluginParam> pluginParams) {
        this.pluginService.savePluginParam(pluginParams);
        return ResponseEntity.ok(Message.success(true));
    }

    public PluginController(PluginService pluginService) {
        this.pluginService = pluginService;
    }
}

