/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.AbstractBucketAdvanceClient;
import com.obs.services.AbstractClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ObjectUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AppendObjectResult;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.CopyObjectRequest;
import com.obs.services.model.CopyObjectResult;
import com.obs.services.model.DeleteObjectRequest;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.GetObjectAclRequest;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ListVersionsRequest;
import com.obs.services.model.ListVersionsResult;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObjectTagResult;
import com.obs.services.model.ObjectTaggingRequest;
import com.obs.services.model.ObsObject;
import com.obs.services.model.OptionsInfoRequest;
import com.obs.services.model.OptionsInfoResult;
import com.obs.services.model.PutObjectInTwoBucketRequest;
import com.obs.services.model.PutObjectInTwoBucketResult;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.SetObjectAclRequest;
import com.obs.services.model.SetObjectMetadataRequest;
import com.obs.services.model.select.SelectObjectRequest;
import com.obs.services.model.select.SelectObjectResult;
import java.io.File;
import java.io.InputStream;

public abstract class AbstractObjectClient
extends AbstractBucketAdvanceClient {
    @Override
    public boolean doesObjectExist(String bucketName, String objectKey) throws ObsException {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(bucketName, objectKey);
        return this.doesObjectExist(request);
    }

    @Override
    public boolean doesObjectExist(final GetObjectMetadataRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucket is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("doesObjectExist", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<Boolean>(){

            @Override
            public Boolean action() throws ServiceException {
                try {
                    return AbstractObjectClient.this.doesObjectExistImpl(request);
                }
                catch (ServiceException e) {
                    if (AbstractObjectClient.this.isAuthTypeNegotiation() && e.getResponseCode() == 400 && "Unsupported Authorization Type".equals(e.getErrorMessage()) && AbstractObjectClient.this.getProviderCredentials().getLocalAuthType(request.getBucketName()) == AuthTypeEnum.OBS) {
                        AbstractObjectClient.this.getProviderCredentials().setLocalAuthType(request.getBucketName(), AuthTypeEnum.V2);
                        return AbstractObjectClient.this.doesObjectExistImpl(request);
                    }
                    throw e;
                }
            }
        });
    }

    public OptionsInfoResult optionsObject(final String bucketName, final String objectKey, final OptionsInfoRequest optionInfo) throws ObsException {
        return this.doActionWithResult("optionsObject", bucketName, new AbstractClient.ActionCallbackWithResult<OptionsInfoResult>(){

            @Override
            public OptionsInfoResult action() throws ServiceException {
                ServiceUtils.assertParameterNotNull(optionInfo, "OptionsInfoRequest is null");
                return AbstractObjectClient.this.optionsImpl(bucketName, objectKey, optionInfo);
            }
        });
    }

    @Override
    public ObjectListing listObjects(final ListObjectsRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "ListObjectsRequest is null");
        return this.doActionWithResult("listObjects", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ObjectListing>(){

            @Override
            public ObjectListing action() throws ServiceException {
                return AbstractObjectClient.this.listObjectsImpl(request);
            }
        });
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws ObsException {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
        return this.listObjects(listObjectsRequest);
    }

    @Deprecated
    public ListVersionsResult listVersions(String bucketName, String prefix, String delimiter, String keyMarker, String versionIdMarker, long maxKeys, String nextVersionIdMarker) throws ObsException {
        ListVersionsRequest request = new ListVersionsRequest();
        request.setBucketName(bucketName);
        request.setPrefix(prefix);
        request.setKeyMarker(keyMarker);
        request.setMaxKeys((int)maxKeys);
        request.setVersionIdMarker(versionIdMarker);
        request.setDelimiter(delimiter);
        return this.listVersions(request);
    }

    @Override
    public ListVersionsResult listVersions(final ListVersionsRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "ListVersionsRequest is null");
        return this.doActionWithResult("listVersions", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ListVersionsResult>(){

            @Override
            public ListVersionsResult action() throws ServiceException {
                return AbstractObjectClient.this.listVersionsImpl(request);
            }
        });
    }

    @Override
    public ListVersionsResult listVersions(String bucketName) throws ObsException {
        ListVersionsRequest request = new ListVersionsRequest();
        request.setBucketName(bucketName);
        return this.listVersions(request);
    }

    @Override
    public ListVersionsResult listVersions(String bucketName, long maxKeys) throws ObsException {
        ListVersionsRequest request = new ListVersionsRequest();
        request.setBucketName(bucketName);
        request.setMaxKeys((int)maxKeys);
        return this.listVersions(request);
    }

    @Override
    public ListVersionsResult listVersions(String bucketName, String prefix, String delimiter, String keyMarker, String versionIdMarker, long maxKeys) throws ObsException {
        return this.listVersions(bucketName, prefix, delimiter, keyMarker, versionIdMarker, maxKeys, null);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, InputStream input, ObjectMetadata metadata) throws ObsException {
        PutObjectRequest request = new PutObjectRequest();
        request.setBucketName(bucketName);
        request.setInput(input);
        request.setMetadata(metadata);
        request.setObjectKey(objectKey);
        return this.putObject(request);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, InputStream input) throws ObsException {
        return this.putObject(bucketName, objectKey, input, null);
    }

    @Override
    public PutObjectResult putObject(final PutObjectRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "PutObjectRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("putObject", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<PutObjectResult>(){

            @Override
            public PutObjectResult action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return AbstractObjectClient.this.putObjectImpl(request);
            }
        });
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, File file) throws ObsException {
        return this.putObject(bucketName, objectKey, file, null);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, File file, ObjectMetadata metadata) throws ObsException {
        PutObjectRequest request = new PutObjectRequest();
        request.setBucketName(bucketName);
        request.setFile(file);
        request.setObjectKey(objectKey);
        request.setMetadata(metadata);
        return this.putObject(request);
    }

    @Override
    public PutObjectInTwoBucketResult putObjectInTwoBucket(final PutObjectInTwoBucketRequest request) throws ObsException {
        File file;
        ServiceUtils.assertParameterNotNull(request, "PutObjectInTwoBucketRequest is null");
        ServiceUtils.assertParameterNotNull(request.getMainBucketRequest(), "mainBucketRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBackupBucketRequest(), "backupBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBackupBucketRequest().getBucketName(), "backupBucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getMainBucketRequest().getBucketName(), "mainBucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getBackupBucketRequest().getObjectKey(), "backupObjectKey is null");
        ServiceUtils.assertParameterNotNull2(request.getMainBucketRequest().getObjectKey(), "mainObjectKey is null");
        String path = request.getFilePath();
        if (ObjectUtils.isNotBlank(path) && (file = new File(path)).exists()) {
            PutObjectRequest mainBucketRequest = request.getMainBucketRequest();
            mainBucketRequest.setFile(file);
            request.setMainBucketRequest(mainBucketRequest);
            PutObjectRequest backupBucketRequest = request.getBackupBucketRequest();
            backupBucketRequest.setFile(file);
            request.setBackupBucketRequest(backupBucketRequest);
        }
        return this.doActionWithResult("putObjectInTwoBucket", "All Buckets", new AbstractClient.ActionCallbackWithResult<PutObjectInTwoBucketResult>(){

            @Override
            public PutObjectInTwoBucketResult action() throws ServiceException {
                if (null != request.getMainBucketRequest().getInput() && null != request.getMainBucketRequest().getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed in main bucket request.");
                }
                if (null != request.getBackupBucketRequest().getInput() && null != request.getBackupBucketRequest().getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed in backup bucket request.");
                }
                return AbstractObjectClient.this.putObjectInTwoBucketImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = AbstractObjectClient.this.getProviderCredentials().getLocalAuthType().get(bucketName);
                if (authTypeEnum == null) {
                    authTypeEnum = AbstractObjectClient.this.getApiVersion("");
                    AbstractObjectClient.this.getProviderCredentials().setLocalAuthType(bucketName, authTypeEnum);
                }
            }
        });
    }

    @Override
    public ObsObject getObject(final GetObjectRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "GetObjectRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("getObject", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ObsObject>(){

            @Override
            public ObsObject action() throws ServiceException {
                return AbstractObjectClient.this.getObjectImpl(request);
            }
        });
    }

    @Override
    public ObsObject getObject(String bucketName, String objectKey, String versionId) throws ObsException {
        return this.getObject(new GetObjectRequest(bucketName, objectKey, versionId));
    }

    @Override
    public ObsObject getObject(String bucketName, String objectKey) throws ObsException {
        return this.getObject(bucketName, objectKey, null);
    }

    @Override
    public SelectObjectResult selectObjectContent(final SelectObjectRequest selectRequest) throws ObsException {
        ServiceUtils.assertParameterNotNull(selectRequest, "SelectObjectRequest is null");
        ServiceUtils.assertParameterNotNull2(selectRequest.getBucketName(), "bucket-name is null");
        ServiceUtils.assertParameterNotNull2(selectRequest.getKey(), "object-key is null");
        ServiceUtils.assertParameterNotNull2(selectRequest.getExpression(), "sql-expression is null");
        return this.doActionWithResult("selectObjectContent", selectRequest.getBucketName(), new AbstractClient.ActionCallbackWithResult<SelectObjectResult>(){

            @Override
            public SelectObjectResult action() throws ServiceException {
                return AbstractObjectClient.this.selectObjectContentImpl(selectRequest);
            }
        });
    }

    @Override
    public DeleteObjectResult deleteObject(String bucketName, String objectKey, String versionId) throws ObsException {
        DeleteObjectRequest request = new DeleteObjectRequest(bucketName, objectKey, versionId);
        return this.deleteObject(request);
    }

    @Override
    public DeleteObjectResult deleteObject(String bucketName, String objectKey) throws ObsException {
        DeleteObjectRequest request = new DeleteObjectRequest(bucketName, objectKey);
        return this.deleteObject(request);
    }

    @Override
    public DeleteObjectResult deleteObject(final DeleteObjectRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "DeleteObjectRequest is null");
        return this.doActionWithResult("deleteObject", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<DeleteObjectResult>(){

            @Override
            public DeleteObjectResult action() throws ServiceException {
                ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
                return AbstractObjectClient.this.deleteObjectImpl(request);
            }
        });
    }

    @Override
    public DeleteObjectsResult deleteObjects(final DeleteObjectsRequest deleteObjectsRequest) throws ObsException {
        ServiceUtils.assertParameterNotNull(deleteObjectsRequest, "DeleteObjectsRequest is null");
        return this.doActionWithResult("deleteObjects", deleteObjectsRequest.getBucketName(), new AbstractClient.ActionCallbackWithResult<DeleteObjectsResult>(){

            @Override
            public DeleteObjectsResult action() throws ServiceException {
                return AbstractObjectClient.this.deleteObjectsImpl(deleteObjectsRequest);
            }
        });
    }

    @Override
    public CopyObjectResult copyObject(final CopyObjectRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "CopyObjectRequest is null");
        ServiceUtils.assertParameterNotNull(request.getDestinationBucketName(), "destinationBucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getSourceObjectKey(), "sourceObjectKey is null");
        ServiceUtils.assertParameterNotNull2(request.getDestinationObjectKey(), "destinationObjectKey is null");
        return this.doActionWithResult("copyObject", request.getSourceBucketName(), new AbstractClient.ActionCallbackWithResult<CopyObjectResult>(){

            @Override
            public CopyObjectResult action() throws ServiceException {
                return AbstractObjectClient.this.copyObjectImpl(request);
            }
        });
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceObjectKey, String destBucketName, String destObjectKey) throws ObsException {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceObjectKey, destBucketName, destObjectKey));
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String objectKey, String versionId) throws ObsException {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, objectKey, versionId));
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String objectKey) throws ObsException {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, objectKey, null));
    }

    @Override
    public AccessControlList getObjectAcl(final GetObjectAclRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "GetObjectAclRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("getObjectAcl", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<AccessControlList>(){

            @Override
            public AccessControlList action() throws ServiceException {
                return AbstractObjectClient.this.getObjectAclImpl(request);
            }
        });
    }

    @Deprecated
    public HeaderResponse setObjectAcl(String bucketName, String objectKey, String cannedACL, AccessControlList acl, String versionId) throws ObsException {
        SetObjectAclRequest request = new SetObjectAclRequest(bucketName, objectKey, acl, versionId);
        request.setCannedACL(cannedACL);
        return this.setObjectAcl(request);
    }

    @Override
    public HeaderResponse setObjectAcl(final SetObjectAclRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetObjectAclRequest is null");
        return this.doActionWithResult("setObjectAcl", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                if (request.getAcl() == null && null == request.getCannedACL()) {
                    throw new IllegalArgumentException("Both cannedACL and AccessControlList is null");
                }
                return AbstractObjectClient.this.setObjectAclImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setObjectAcl(String bucketName, String objectKey, AccessControlList acl, String versionId) throws ObsException {
        return this.setObjectAcl(new SetObjectAclRequest(bucketName, objectKey, acl, versionId));
    }

    @Override
    public HeaderResponse setObjectAcl(String bucketName, String objectKey, AccessControlList acl) throws ObsException {
        return this.setObjectAcl(new SetObjectAclRequest(bucketName, objectKey, acl));
    }

    @Override
    public ObjectMetadata getObjectMetadata(final GetObjectMetadataRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "GetObjectMetadataRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("getObjectMetadata", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ObjectMetadata>(){

            @Override
            public ObjectMetadata action() throws ServiceException {
                return AbstractObjectClient.this.getObjectMetadataImpl(request);
            }
        });
    }

    @Override
    public ObjectMetadata setObjectMetadata(final SetObjectMetadataRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetObjectMetadataRequest is null");
        return this.doActionWithResult("setObjectMetadata", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ObjectMetadata>(){

            @Override
            public ObjectMetadata action() throws ServiceException {
                return AbstractObjectClient.this.setObjectMetadataImpl(request);
            }
        });
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String objectKey, String versionId) throws ObsException {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setVersionId(versionId);
        return this.getObjectMetadata(request);
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String objectKey) throws ObsException {
        return this.getObjectMetadata(bucketName, objectKey, null);
    }

    @Override
    public AppendObjectResult appendObject(final AppendObjectRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "AppendObjectRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("appendObject", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<AppendObjectResult>(){

            @Override
            public AppendObjectResult action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return AbstractObjectClient.this.appendObjectImpl(request);
            }
        });
    }

    @Override
    public RestoreObjectRequest.RestoreObjectStatus restoreObject(final RestoreObjectRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "RestoreObjectRequest is null");
        return this.doActionWithResult("restoreObject", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<RestoreObjectRequest.RestoreObjectStatus>(){

            @Override
            public RestoreObjectRequest.RestoreObjectStatus action() throws ServiceException {
                ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
                return AbstractObjectClient.this.restoreObjectImpl(request);
            }
        });
    }

    @Override
    public ObjectTagResult getObjectTagging(final ObjectTaggingRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "ObjectTaggingRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("getObjectTagging", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ObjectTagResult>(){

            @Override
            public ObjectTagResult action() throws ServiceException {
                return AbstractObjectClient.this.getObjectTaggingImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setObjectTagging(final ObjectTaggingRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "ObjectTaggingRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("setObjectTagging", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractObjectClient.this.setObjectTaggingImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteObjectTagging(final ObjectTaggingRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "ObjectTaggingRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("deleteObjectTagging", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractObjectClient.this.deleteObjectTaggingImpl(request);
            }
        });
    }

    @Override
    public RestoreObjectResult restoreObjectV2(final RestoreObjectRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "RestoreObjectRequest is null");
        return this.doActionWithResult("restoreObjectV2", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<RestoreObjectResult>(){

            @Override
            public RestoreObjectResult action() throws ServiceException {
                ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
                return AbstractObjectClient.this.restoreObjectV2Impl(request);
            }
        });
    }
}

