/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.convert.DB2J;
import dm.jdbc.convert.J2DB;
import dm.jdbc.desc.Parameter;
import dm.jdbc.desc.TypeDescriptor;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbSQLOutput;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.util.ByteUtil;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Vector;

public class TypeData {
    public static final int ARRAY_TYPE_SHORT = 1;
    public static final int ARRAY_TYPE_INTEGER = 2;
    public static final int ARRAY_TYPE_LONG = 3;
    public static final int ARRAY_TYPE_FLOAT = 4;
    public static final int ARRAY_TYPE_DOUBLE = 5;
    public Object m_dumyData = null;
    public int m_offset = 0;
    public int m_bufLen;
    public byte[] m_dataBuf = null;
    public byte[] m_objBlobDescBuf = null;
    public boolean m_isFromBlob = false;
    public int m_packid = -1;
    public Vector m_objRefArr = new Vector(0);

    protected TypeData(Object object, byte[] byArray) {
        this.m_dumyData = object;
        this.m_offset = 0;
        this.m_bufLen = 0;
        this.m_dataBuf = byArray;
    }

    public static TypeData[] toStruct(Object[] objectArray, TypeDescriptor typeDescriptor) {
        int n2 = typeDescriptor.getStrctMemSize();
        TypeData[] typeDataArray = new TypeData[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (objectArray[n3] == null || objectArray[n3] instanceof DmdbStruct || objectArray[n3] instanceof DmdbArray) {
                typeDataArray[n3] = new TypeData(objectArray[n3], null);
            } else if (objectArray[n3] instanceof SQLData) {
                DmdbSQLOutput dmdbSQLOutput = new DmdbSQLOutput();
                ((SQLData)objectArray[n3]).writeSQL(dmdbSQLOutput);
                DmdbStruct dmdbStruct = new DmdbStruct(TypeData.toStruct(dmdbSQLOutput.getAttribs(), typeDescriptor.m_fieldsObj[n3]), typeDescriptor.m_fieldsObj[n3]);
                typeDataArray[n3] = new TypeData(dmdbStruct, null);
            } else {
                switch (typeDescriptor.m_fieldsObj[n3].getDType()) {
                    case 119: 
                    case 121: {
                        typeDataArray[n3] = new TypeData(new DmdbStruct(TypeData.toStruct((Object[])objectArray[n3], typeDescriptor.m_fieldsObj[n3]), typeDescriptor.m_fieldsObj[n3]), null);
                        break;
                    }
                    case 117: 
                    case 122: {
                        typeDataArray[n3] = new TypeData(new DmdbArray(TypeData.toArray((Object[])objectArray[n3], typeDescriptor.m_fieldsObj[n3]), typeDescriptor.m_fieldsObj[n3]), null);
                        break;
                    }
                    default: {
                        typeDataArray[n3] = TypeData.toMemberObj(objectArray[n3], typeDescriptor.m_fieldsObj[n3]);
                    }
                }
            }
            ++n3;
        }
        return typeDataArray;
    }

    public static TypeData[] toArray(Object[] objectArray, TypeDescriptor typeDescriptor) {
        int n2 = objectArray.length;
        TypeData[] typeDataArray = new TypeData[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (objectArray[n3] == null || objectArray[n3] instanceof DmdbStruct || objectArray[n3] instanceof DmdbArray) {
                typeDataArray[n3] = new TypeData(objectArray[n3], null);
            } else {
                switch (typeDescriptor.m_arrObj.getDType()) {
                    case 119: 
                    case 121: {
                        typeDataArray[n3] = new TypeData(new DmdbStruct(TypeData.toStruct((Object[])objectArray[n3], typeDescriptor.m_arrObj), typeDescriptor.m_arrObj), null);
                        break;
                    }
                    case 117: 
                    case 122: {
                        if (!(objectArray[n3] instanceof Object[]) && typeDescriptor.m_arrObj.m_arrObj != null) {
                            objectArray[n3] = TypeData.makeupObjToArr(objectArray[n3], typeDescriptor.m_arrObj);
                        }
                        typeDataArray[n3] = new TypeData(new DmdbArray(TypeData.toArray((Object[])objectArray[n3], typeDescriptor.m_arrObj), typeDescriptor.m_arrObj), null);
                        break;
                    }
                    default: {
                        typeDataArray[n3] = TypeData.toMemberObj(objectArray[n3], typeDescriptor.m_arrObj);
                    }
                }
            }
            ++n3;
        }
        return typeDataArray;
    }

    private static Object[] makeupObjToArr(Object object, TypeDescriptor typeDescriptor) {
        int n2;
        int n3 = typeDescriptor.getDType();
        boolean bl = true;
        int n4 = 0;
        if (n3 == 122) {
            bl = false;
            n4 = typeDescriptor.m_length;
        }
        if ((n2 = typeDescriptor.m_arrObj.getDType()) == 17 || n2 == 18 || n2 == 3) {
            String string = "";
            if (object instanceof Integer) {
                string = Integer.toBinaryString((Integer)object);
            } else if (object instanceof Long) {
                string = Long.toBinaryString((Long)object);
            } else if (object instanceof String) {
                string = (String)object;
            } else {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
            int n5 = bl ? string.length() : n4;
            Object[] objectArray = new Object[n5];
            byte[] byArray = ByteUtil.fromString(string, typeDescriptor.getServerEncoding());
            int n6 = 0;
            while (n6 < n5) {
                objectArray[n6] = byArray[n6];
                ++n6;
            }
            return objectArray;
        }
        DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        return null;
    }

    private static TypeData toMemberObj(Object object, TypeDescriptor typeDescriptor) {
        int n2 = typeDescriptor.getScale();
        int n3 = typeDescriptor.getPrec();
        int n4 = typeDescriptor.getDType();
        if (object == null) {
            return new TypeData(null, null);
        }
        Parameter parameter = new Parameter();
        parameter.type = n4;
        parameter.prec = n3;
        parameter.scale = n2;
        byte[] byArray = J2DB.fromObject(object, parameter, typeDescriptor.m_conn);
        return new TypeData(object, byArray);
    }

    private static byte[] typeDataToBytes(TypeData typeData, TypeDescriptor typeDescriptor) {
        int n2 = typeDescriptor.getDType();
        if (typeData.m_dumyData == null) {
            byte[] byArray = TypeData.realocBuffer(null, 0, 2);
            ByteUtil.setByte(byArray, 0, (byte)0);
            ByteUtil.setByte(byArray, 1, (byte)0);
            return byArray;
        }
        switch (n2) {
            case 117: {
                byte[] byArray = TypeData.arrayToBytes((DmdbArray)typeData.m_dumyData, typeDescriptor);
                byte[] byArray2 = TypeData.realocBuffer(null, 0, byArray.length + 1 + 1);
                ByteUtil.setByte(byArray2, 0, (byte)0);
                int n3 = 1;
                ByteUtil.setByte(byArray2, n3, (byte)1);
                System.arraycopy(byArray, 0, byArray2, ++n3, byArray.length);
                return byArray2;
            }
            case 122: {
                byte[] byArray = TypeData.sarrayToBytes((DmdbArray)typeData.m_dumyData, typeDescriptor);
                byte[] byArray3 = TypeData.realocBuffer(null, 0, byArray.length + 1 + 1);
                ByteUtil.setByte(byArray3, 0, (byte)0);
                int n4 = 1;
                ByteUtil.setByte(byArray3, n4, (byte)1);
                System.arraycopy(byArray, 0, byArray3, ++n4, byArray.length);
                return byArray3;
            }
            case 119: {
                byte[] byArray = TypeData.objToBytes(typeData.m_dumyData, typeDescriptor);
                byte[] byArray4 = TypeData.realocBuffer(null, 0, byArray.length + 1 + 1);
                ByteUtil.setByte(byArray4, 0, (byte)0);
                int n5 = 1;
                ByteUtil.setByte(byArray4, n5, (byte)1);
                System.arraycopy(byArray, 0, byArray4, ++n5, byArray.length);
                return byArray4;
            }
            case 121: {
                byte[] byArray = TypeData.recordToBytes((DmdbStruct)typeData.m_dumyData, typeDescriptor);
                byte[] byArray5 = TypeData.realocBuffer(null, 0, byArray.length + 1 + 1);
                ByteUtil.setByte(byArray5, 0, (byte)0);
                int n6 = 1;
                ByteUtil.setByte(byArray5, n6, (byte)1);
                System.arraycopy(byArray, 0, byArray5, ++n6, byArray.length);
                return byArray5;
            }
            case 12: 
            case 19: {
                byte[] byArray = TypeData.convertLobToBytes(typeData.m_dumyData, typeDescriptor.column.type, typeDescriptor.getServerEncoding());
                byte[] byArray6 = TypeData.realocBuffer(null, 0, byArray.length + 1 + 1);
                ByteUtil.setByte(byArray6, 0, (byte)0);
                int n7 = 1;
                ByteUtil.setByte(byArray6, n7, (byte)1);
                System.arraycopy(byArray, 0, byArray6, ++n7, byArray.length);
                return byArray6;
            }
            case 13: {
                byte[] byArray = TypeData.realocBuffer(null, 0, 2);
                ByteUtil.setByte(byArray, 0, (byte)0);
                if (typeData.m_dataBuf != null && typeData.m_dataBuf.length > 0) {
                    ByteUtil.setByte(byArray, 1, typeData.m_dataBuf[0]);
                } else {
                    ByteUtil.setByte(byArray, 1, (byte)0);
                }
                return byArray;
            }
        }
        byte[] byArray = typeData.m_dataBuf;
        byte[] byArray7 = TypeData.realocBuffer(null, 0, byArray.length + 1 + 1 + 2);
        ByteUtil.setByte(byArray7, 0, (byte)0);
        int n8 = 1;
        ByteUtil.setByte(byArray7, n8, (byte)1);
        ByteUtil.setShort(byArray7, ++n8, (short)byArray.length);
        System.arraycopy(byArray, 0, byArray7, n8 += 2, byArray.length);
        return byArray7;
    }

    private static byte[] convertLobToBytes(Object object, int n2, Charset charset) {
        if (n2 == 12) {
            DmdbBlob dmdbBlob = (DmdbBlob)object;
            int n3 = (int)dmdbBlob.do_length();
            byte[] byArray = dmdbBlob.do_getBytes(1L, n3);
            byte[] byArray2 = new byte[n3 + 4];
            ByteUtil.setInt(byArray2, 0, n3);
            System.arraycopy(byArray, 0, byArray2, 4, n3);
            return byArray2;
        }
        if (n2 == 19) {
            DmdbClob dmdbClob = (DmdbClob)object;
            int n4 = (int)dmdbClob.do_length();
            String string = dmdbClob.do_getSubString(1L, n4);
            byte[] byArray = ByteUtil.fromString(string, charset);
            byte[] byArray3 = new byte[byArray.length + 4];
            ByteUtil.setInt(byArray3, 0, n4);
            System.arraycopy(byArray, 0, byArray3, 4, n4);
            return byArray3;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    public static byte[] sarrayToBytes(DmdbArray dmdbArray, TypeDescriptor typeDescriptor) {
        int n2 = dmdbArray.m_arrData.length;
        byte[][] byArrayArray = new byte[n2][];
        if (typeDescriptor.getObjId() == 4) {
            return TypeData.ctlnToBytes(dmdbArray, typeDescriptor);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            byArrayArray[n4] = TypeData.typeDataToBytes(dmdbArray.m_arrData[n4], typeDescriptor.m_arrObj);
            n3 += byArrayArray[n4].length;
            ++n4;
        }
        byte[] byArray = TypeData.realocBuffer(null, 0, n3 += 8);
        n4 = 0;
        ByteUtil.setInt(byArray, n4, n3);
        ByteUtil.setInt(byArray, n4 += 4, dmdbArray.m_arrDesc.getLength());
        n4 += 4;
        int n5 = 0;
        while (n5 < n2) {
            System.arraycopy(byArrayArray[n5], 0, byArray, n4, byArrayArray[n5].length);
            n4 += byArrayArray[n5].length;
            ++n5;
        }
        return byArray;
    }

    public static byte[] ctlnToBytes(DmdbArray dmdbArray, TypeDescriptor typeDescriptor) {
        byte[][] byArrayArray = new byte[dmdbArray.m_arrData.length][];
        int n2 = 5;
        n2 += 8;
        int n3 = 0;
        while (n3 < dmdbArray.m_arrData.length) {
            byArrayArray[n3] = TypeData.typeDataToBytes(dmdbArray.m_arrData[n3], typeDescriptor.m_arrObj);
            n2 += byArrayArray[n3].length;
            ++n3;
        }
        byte[] byArray = TypeData.realocBuffer(null, 0, n2);
        n3 = 0;
        ByteUtil.setByte(byArray, n3, (byte)0);
        ++n3;
        ByteUtil.setShort(byArray, n3 += 4, (short)typeDescriptor.getCltnType());
        ByteUtil.setShort(byArray, n3 += 2, (short)typeDescriptor.m_arrObj.getDType());
        ByteUtil.setInt(byArray, n3 += 2, dmdbArray.m_arrData.length);
        n3 += 4;
        int n4 = 0;
        while (n4 < dmdbArray.m_arrData.length) {
            System.arraycopy(byArrayArray[n4], 0, byArray, n3, byArrayArray[n4].length);
            n3 += byArrayArray[n4].length;
            ++n4;
        }
        ByteUtil.setInt(byArray, 1, n3);
        return byArray;
    }

    public static byte[] arrayToBytes(DmdbArray dmdbArray, TypeDescriptor typeDescriptor) {
        byte[][] byArrayArray = new byte[dmdbArray.m_arrData.length][];
        if (typeDescriptor.getObjId() == 4) {
            return TypeData.ctlnToBytes(dmdbArray, typeDescriptor);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < dmdbArray.m_arrData.length) {
            byArrayArray[n3] = TypeData.typeDataToBytes(dmdbArray.m_arrData[n3], typeDescriptor.m_arrObj);
            n2 += byArrayArray[n3].length;
            ++n3;
        }
        n2 += 20;
        n3 = dmdbArray.m_objCount + dmdbArray.m_strCount;
        if (n3 > 0) {
            n2 += 2 * n3;
        }
        byte[] byArray = TypeData.realocBuffer(null, 0, n2);
        ByteUtil.setInt(byArray, 0, n2);
        int n4 = 4;
        ByteUtil.setInt(byArray, n4, dmdbArray.m_arrData.length);
        ByteUtil.setInt(byArray, n4 += 4, 0);
        ByteUtil.setInt(byArray, n4 += 4, dmdbArray.m_objCount);
        ByteUtil.setInt(byArray, n4 += 4, dmdbArray.m_strCount);
        n4 += 4;
        int n5 = 0;
        while (n5 < n3) {
            ByteUtil.setInt(byArray, n4, dmdbArray.m_objStrOffs[n5]);
            n4 += 4;
            ++n5;
        }
        n5 = 0;
        while (n5 < dmdbArray.m_arrData.length) {
            System.arraycopy(byArrayArray[n5], 0, byArray, n4, byArrayArray[n5].length);
            n4 += byArrayArray[n5].length;
            ++n5;
        }
        return byArray;
    }

    public static byte[] objToBytes(Object object, TypeDescriptor typeDescriptor) {
        if (object instanceof DmdbArray) {
            return TypeData.arrayToBytes((DmdbArray)object, typeDescriptor);
        }
        return TypeData.structToBytes((DmdbStruct)object, typeDescriptor);
    }

    public static byte[] structToBytes(DmdbStruct dmdbStruct, TypeDescriptor typeDescriptor) {
        int n2 = typeDescriptor.getStrctMemSize();
        byte[][] byArrayArray = new byte[n2][];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            byArrayArray[n4] = TypeData.typeDataToBytes(dmdbStruct.m_attribs[n4], typeDescriptor.m_fieldsObj[n4]);
            n3 += byArrayArray[n4].length;
            ++n4;
        }
        byte[] byArray = TypeData.realocBuffer(null, 0, n3 += 5);
        n4 = 0;
        ByteUtil.setByte(byArray, n4, (byte)0);
        ByteUtil.setInt(byArray, ++n4, n3);
        n4 += 4;
        int n5 = 0;
        while (n5 < n2) {
            System.arraycopy(byArrayArray[n5], 0, byArray, n4, byArrayArray[n5].length);
            n4 += byArrayArray[n5].length;
            ++n5;
        }
        return byArray;
    }

    public static byte[] recordToBytes(DmdbStruct dmdbStruct, TypeDescriptor typeDescriptor) {
        int n2 = typeDescriptor.getStrctMemSize();
        byte[][] byArrayArray = new byte[n2][];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            byArrayArray[n4] = TypeData.typeDataToBytes(dmdbStruct.m_attribs[n4], typeDescriptor.m_fieldsObj[n4]);
            n3 += byArrayArray[n4].length;
            ++n4;
        }
        byte[] byArray = TypeData.realocBuffer(null, 0, n3 += 4);
        ByteUtil.setInt(byArray, 0, n3);
        n4 = 4;
        int n5 = 0;
        while (n5 < typeDescriptor.getStrctMemSize()) {
            System.arraycopy(byArrayArray[n5], 0, byArray, n4, byArrayArray[n5].length);
            n4 += byArrayArray[n5].length;
            ++n5;
        }
        return byArray;
    }

    private static TypeData bytesToBlob(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor) {
        int n2 = typeData.m_offset;
        int n3 = ByteUtil.getInt(byArray, n2);
        byte[] byArray2 = ByteUtil.getBytes(byArray, n2 += 4, n3);
        typeData.m_offset = n2 += n3;
        return new TypeData(DmdbBlob.newInstanceOfLocal(byArray2, typeDescriptor.m_conn), byArray2);
    }

    private static TypeData bytesToClob(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor, Charset charset) {
        int n2 = typeData.m_offset;
        int n3 = ByteUtil.getInt(byArray, n2);
        byte[] byArray2 = ByteUtil.getBytes(byArray, n2 += 4, n3);
        typeData.m_offset = n2 += n3;
        return new TypeData(DmdbClob.newInstance(ByteUtil.getString(byArray2, 0, byArray2.length, charset), typeDescriptor.m_conn), byArray2);
    }

    private static TypeData bytesToTypeData(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor) {
        int n2 = typeData.m_offset;
        byte by = ByteUtil.getByte(byArray, ++n2);
        typeData.m_offset = ++n2;
        if (typeDescriptor.getDType() == 13) {
            boolean bl = false;
            if (by != 0) {
                bl = true;
            }
            return new TypeData(bl, ByteUtil.getBytes(byArray, n2 - 1, 1));
        }
        byte[] byArray2 = null;
        switch (typeDescriptor.getDType()) {
            case 119: {
                if ((by & 1) != 0) {
                    Object object = TypeData.bytesToObj(byArray, typeData, typeDescriptor);
                    if (typeData.m_offset > n2) {
                        byArray2 = ByteUtil.getBytes(byArray, n2, typeData.m_offset - n2);
                    }
                    return new TypeData(object, byArray2);
                }
                return new TypeData(null, null);
            }
            case 117: {
                if ((by & 1) != 0) {
                    DmdbArray dmdbArray = TypeData.bytesToArray(byArray, typeData, typeDescriptor);
                    if (typeData.m_offset > n2) {
                        byArray2 = ByteUtil.getBytes(byArray, n2, typeData.m_offset - n2);
                    }
                    return new TypeData(dmdbArray, byArray2);
                }
                return new TypeData(null, null);
            }
            case 121: {
                if ((by & 1) != 0) {
                    DmdbStruct dmdbStruct = TypeData.bytesToRecord(byArray, typeData, typeDescriptor);
                    if (typeData.m_offset > n2) {
                        byArray2 = ByteUtil.getBytes(byArray, n2, typeData.m_offset - n2);
                    }
                    return new TypeData(dmdbStruct, byArray2);
                }
                return new TypeData(null, null);
            }
            case 122: {
                if ((by & 1) != 0) {
                    DmdbArray dmdbArray = TypeData.bytesToSArray(byArray, typeData, typeDescriptor);
                    if (typeData.m_offset > n2) {
                        byArray2 = ByteUtil.getBytes(byArray, n2, typeData.m_offset - n2);
                    }
                    return new TypeData(dmdbArray, byArray2);
                }
                return new TypeData(null, null);
            }
            case 12: {
                if ((by & 1) != 0) {
                    return TypeData.bytesToBlob(byArray, typeData, typeDescriptor);
                }
                return new TypeData(null, null);
            }
            case 19: {
                if ((by & 1) != 0) {
                    return TypeData.bytesToClob(byArray, typeData, typeDescriptor, typeDescriptor.getServerEncoding());
                }
                return new TypeData(null, null);
            }
        }
        if ((by & 1) != 0) {
            return TypeData.convertBytes2BaseData(byArray, typeData, typeDescriptor);
        }
        return new TypeData(null, null);
    }

    private static boolean checkObjExist(byte[] byArray, TypeData typeData) {
        int n2 = typeData.m_offset;
        byte by = ByteUtil.getByte(byArray, n2);
        typeData.m_offset = ++n2;
        if (by == 1) {
            return true;
        }
        typeData.m_offset += 4;
        return false;
    }

    private static DmdbStruct findObjByPackId(byte[] byArray, TypeData typeData) {
        int n2 = typeData.m_offset;
        int n3 = ByteUtil.getInt(byArray, n2);
        typeData.m_offset = n2 += 4;
        if (n3 < 0 || n3 > typeData.m_packid) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        return (DmdbStruct)typeData.m_objRefArr.get(n3);
    }

    private static void addObjToRefArr(TypeData typeData, Object object) {
        typeData.m_objRefArr.add(object);
        ++typeData.m_packid;
    }

    private static boolean checkObjClnt(TypeDescriptor typeDescriptor) {
        return typeDescriptor.m_objId == 4;
    }

    private static DmdbStruct bytesToObj_EXACT(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor) {
        DmdbStruct dmdbStruct = new DmdbStruct(null, typeDescriptor);
        int n2 = typeData.m_offset;
        int n3 = typeDescriptor.getStrctMemSize();
        typeData.m_offset = n2;
        dmdbStruct.m_attribs = new TypeData[n3];
        int n4 = 0;
        while (n4 < n3) {
            TypeDescriptor typeDescriptor2 = typeDescriptor.m_fieldsObj[n4];
            dmdbStruct.m_attribs[n4] = TypeData.bytesToTypeData(byArray, typeData, typeDescriptor2);
            ++n4;
        }
        dmdbStruct.m_dataBuf = ByteUtil.getBytes(byArray, n2, typeData.m_offset - n2);
        return dmdbStruct;
    }

    private static DmdbArray bytesToNestTab(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor) {
        int n2 = typeData.m_offset;
        int n3 = ByteUtil.getInt(byArray, n2 += 2);
        typeData.m_offset = n2 += 4;
        DmdbArray dmdbArray = new DmdbArray(null, typeDescriptor);
        dmdbArray.m_itemCount = n3;
        dmdbArray.m_arrData = new TypeData[n3];
        int n4 = 0;
        while (n4 < n3) {
            dmdbArray.m_arrData[n4] = TypeData.bytesToTypeData(byArray, typeData, typeDescriptor.m_arrObj);
            ++n4;
        }
        dmdbArray.m_dataBuf = ByteUtil.getBytes(byArray, n2, typeData.m_offset - n2);
        return dmdbArray;
    }

    private static DmdbArray bytesToClnt(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor) {
        DmdbArray dmdbArray = null;
        int n2 = typeData.m_offset;
        short s2 = ByteUtil.getShort(byArray, n2);
        typeData.m_offset = n2 += 2;
        switch (s2) {
            case 3: {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                break;
            }
            case 1: 
            case 2: {
                dmdbArray = TypeData.bytesToNestTab(byArray, typeData, typeDescriptor);
            }
        }
        return dmdbArray;
    }

    public static Object bytesToObj(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor) {
        TypeData typeData2 = null;
        if (typeData == null) {
            typeData = new TypeData(null, null);
        }
        if (TypeData.checkObjExist(byArray, typeData)) {
            typeData2 = TypeData.findObjByPackId(byArray, typeData);
        } else {
            TypeData.addObjToRefArr(typeData, typeData2);
            typeData2 = TypeData.checkObjClnt(typeDescriptor) ? TypeData.bytesToClnt(byArray, typeData, typeDescriptor) : TypeData.bytesToObj_EXACT(byArray, typeData, typeDescriptor);
        }
        return typeData2;
    }

    public static DmdbArray bytesToArray(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor) {
        DmdbArray dmdbArray = new DmdbArray(null, typeDescriptor);
        if (typeData == null) {
            typeData = new TypeData(null, null);
        }
        int n2 = typeData.m_offset;
        dmdbArray.m_bufLen = ByteUtil.getInt(byArray, n2);
        dmdbArray.m_itemCount = ByteUtil.getInt(byArray, n2 += 4);
        dmdbArray.m_itemSize = ByteUtil.getInt(byArray, n2 += 4);
        dmdbArray.m_objCount = ByteUtil.getInt(byArray, n2 += 4);
        dmdbArray.m_strCount = ByteUtil.getInt(byArray, n2 += 4);
        n2 += 4;
        int n3 = dmdbArray.m_objCount + dmdbArray.m_strCount;
        dmdbArray.m_objStrOffs = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            dmdbArray.m_objStrOffs[n4] = ByteUtil.getInt(byArray, n2);
            n2 += 4;
            ++n4;
        }
        typeData.m_offset = n2;
        dmdbArray.m_arrData = new TypeData[dmdbArray.m_itemCount];
        n4 = 0;
        while (n4 < dmdbArray.m_itemCount) {
            dmdbArray.m_arrData[n4] = TypeData.bytesToTypeData(byArray, typeData, typeDescriptor.m_arrObj);
            ++n4;
        }
        dmdbArray.m_dataBuf = ByteUtil.getBytes(byArray, n2, typeData.m_offset - n2);
        return dmdbArray;
    }

    public static DmdbArray bytesToSArray(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor) {
        if (typeData == null) {
            typeData = new TypeData(null, null);
        }
        int n2 = typeData.m_offset;
        DmdbArray dmdbArray = new DmdbArray(null, typeDescriptor);
        dmdbArray.m_bufLen = ByteUtil.getInt(byArray, n2);
        dmdbArray.m_itemCount = ByteUtil.getInt(byArray, n2 += 4);
        typeData.m_offset = n2 += 4;
        dmdbArray.m_arrData = new TypeData[dmdbArray.m_itemCount];
        int n3 = 0;
        while (n3 < dmdbArray.m_itemCount) {
            dmdbArray.m_arrData[n3] = TypeData.bytesToTypeData(byArray, typeData, typeDescriptor.m_arrObj);
            ++n3;
        }
        dmdbArray.m_dataBuf = ByteUtil.getBytes(byArray, n2, typeData.m_offset - n2);
        return dmdbArray;
    }

    public static DmdbStruct bytesToRecord(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor) {
        if (typeData == null) {
            typeData = new TypeData(null, null);
        }
        int n2 = typeData.m_offset;
        DmdbStruct dmdbStruct = new DmdbStruct(null, typeDescriptor);
        dmdbStruct.m_bufLen = ByteUtil.getInt(byArray, n2);
        typeData.m_offset = n2 += 4;
        dmdbStruct.m_attribs = new TypeData[typeDescriptor.getStrctMemSize()];
        int n3 = 0;
        while (n3 < typeDescriptor.getStrctMemSize()) {
            dmdbStruct.m_attribs[n3] = TypeData.bytesToTypeData(byArray, typeData, typeDescriptor.m_fieldsObj[n3]);
            ++n3;
        }
        dmdbStruct.m_dataBuf = ByteUtil.getBytes(byArray, n2, typeData.m_offset - n2);
        return dmdbStruct;
    }

    private static void objBlob_GetChkBuf(byte[] byArray, TypeData typeData) {
        int n2 = 4;
        int n3 = ByteUtil.getInt(byArray, n2);
        typeData.m_objBlobDescBuf = ByteUtil.getBytes(byArray, n2 += 4, n3);
        typeData.m_isFromBlob = true;
        typeData.m_offset = n2 += n3;
    }

    public static Object objBlobToObj(Blob blob, TypeDescriptor typeDescriptor) {
        TypeData typeData = new TypeData(null, null);
        int n2 = (int)blob.length();
        byte[] byArray = blob.getBytes(1L, n2);
        TypeData.objBlob_GetChkBuf(byArray, typeData);
        return TypeData.bytesToObj(byArray, typeData, typeDescriptor);
    }

    public static byte[] objBlobToBytes(byte[] byArray, TypeDescriptor typeDescriptor) {
        int n2;
        byte[] byArray2;
        int n3 = byArray.length;
        int n4 = 0;
        int n5 = ByteUtil.getInt(byArray, n4);
        n4 += 4;
        if (78111999 != n5) {
            DBError.ECJDBC_INVALID_OBJ_LOB.throwz(new Object[0]);
        }
        if (!Arrays.equals(byArray2 = ByteUtil.getBytes(byArray, n4 += 4, n2 = ByteUtil.getInt(byArray, n4)), typeDescriptor.getClassDescChkInfo())) {
            DBError.ECJDBC_INVALID_OBJ_LOB.throwz(new Object[0]);
        }
        byte[] byArray3 = new byte[n3 - (n4 += n2)];
        System.arraycopy(byArray, n4, byArray3, 0, byArray3.length);
        return byArray3;
    }

    private static byte[] realocBuffer(byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        if (byArray == null) {
            return new byte[n3];
        }
        if (n3 + n2 > byArray.length) {
            byArray2 = new byte[byArray.length + n3];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    private static TypeData convertBytes2BaseData(byte[] byArray, TypeData typeData, TypeDescriptor typeDescriptor) {
        int n2 = typeData.m_offset;
        boolean bl = false;
        int n3 = ByteUtil.getUB2(byArray, n2);
        n2 += 2;
        if (n3 == 65534) {
            n3 = 0;
            bl = true;
        }
        if (-1 == n3) {
            n3 = ByteUtil.getInt(byArray, n2);
            n2 += 4;
        }
        if (bl) {
            typeData.m_offset = n2;
            return new TypeData(null, null);
        }
        byte[] byArray2 = ByteUtil.getBytes(byArray, n2, n3);
        typeData.m_offset = n2 += n3;
        Object object = DB2J.toObject(byArray2, typeDescriptor.column, typeDescriptor.m_conn, typeDescriptor.m_conn.do_getTypeMap());
        return new TypeData(object, byArray2);
    }

    public Object toJavaArray(DmdbArray dmdbArray, int n2, int n3) {
        return this.toJavaArray(dmdbArray, 1L, n2, n3);
    }

    public Object toJavaArray(DmdbArray dmdbArray, long l2, int n2, int n3) {
        Object object;
        if (dmdbArray.m_objArray != null) {
            return dmdbArray.m_objArray;
        }
        int n4 = (int)(l2 - 1L);
        switch (n3) {
            case 0: 
            case 1: 
            case 2: {
                object = new String[n2];
                int n5 = 0;
                while (n5 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n5];
                    if (typeData != null && typeData.m_dumyData != null) {
                        ((String[])object)[n5] = (String)typeData.m_dumyData;
                    }
                    ++n5;
                }
                break;
            }
            case 3: {
                object = new Boolean[n2];
                int n6 = 0;
                while (n6 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n6];
                    if (typeData != null && typeData.m_dumyData != null) {
                        ((Boolean[])object)[n6] = typeData.m_dumyData instanceof Boolean ? (Boolean)typeData.m_dumyData : Boolean.valueOf((Byte)typeData.m_dumyData == 1);
                    }
                    ++n6;
                }
                break;
            }
            case 5: {
                object = new Byte[n2];
                int n7 = 0;
                while (n7 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n7];
                    if (typeData != null && typeData.m_dumyData != null) {
                        ((Byte[])object)[n7] = (Byte)typeData.m_dumyData;
                    }
                    ++n7;
                }
                break;
            }
            case 17: 
            case 18: {
                object = new byte[n2][];
                int n8 = 0;
                while (n8 < n2) {
                    byte[] byArray;
                    TypeData typeData = dmdbArray.m_arrData[n4 + n8];
                    if (typeData != null && typeData.m_dumyData != null && (byArray = (byte[])typeData.m_dumyData).length > 0) {
                        ((byte[][])object)[n8] = byArray;
                    }
                    ++n8;
                }
                break;
            }
            case 13: {
                object = new Boolean[n2];
                int n9 = 0;
                while (n9 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n9];
                    ((Boolean[])object)[n9] = typeData != null && typeData.m_dumyData != null ? (Boolean)typeData.m_dumyData : null;
                    ++n9;
                }
                break;
            }
            case 6: {
                object = new Short[n2];
                int n10 = 0;
                while (n10 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n10];
                    ((Short[])object)[n10] = typeData != null && typeData.m_dumyData != null ? (Short)typeData.m_dumyData : null;
                    ++n10;
                }
                break;
            }
            case 7: {
                object = new Integer[n2];
                int n11 = 0;
                while (n11 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n11];
                    ((Integer[])object)[n11] = typeData != null && typeData.m_dumyData != null ? (Integer)typeData.m_dumyData : null;
                    ++n11;
                }
                break;
            }
            case 8: {
                object = new Long[n2];
                int n12 = 0;
                while (n12 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n12];
                    ((Long[])object)[n12] = typeData != null && typeData.m_dumyData != null ? (Long)typeData.m_dumyData : null;
                    ++n12;
                }
                break;
            }
            case 9: {
                object = new BigDecimal[n2];
                int n13 = 0;
                while (n13 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n13];
                    ((BigDecimal[])object)[n13] = typeData != null && typeData.m_dumyData != null ? new BigDecimal(String.valueOf(typeData.m_dumyData)) : null;
                    ++n13;
                }
                break;
            }
            case 10: {
                object = new Float[n2];
                int n14 = 0;
                while (n14 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n14];
                    ((Float[])object)[n14] = typeData != null && typeData.m_dumyData != null ? (Float)typeData.m_dumyData : null;
                    ++n14;
                }
                break;
            }
            case 11: {
                object = new Double[n2];
                int n15 = 0;
                while (n15 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n15];
                    ((Double[])object)[n15] = typeData != null && typeData.m_dumyData != null ? (Double)typeData.m_dumyData : null;
                    ++n15;
                }
                break;
            }
            case 14: {
                object = new Date[n2];
                int n16 = 0;
                while (n16 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n16];
                    if (typeData != null && typeData.m_dumyData != null) {
                        ((Date[])object)[n16] = (Date)typeData.m_dumyData;
                    }
                    ++n16;
                }
                break;
            }
            case 15: {
                object = new Time[n2];
                int n17 = 0;
                while (n17 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n17];
                    if (typeData != null && typeData.m_dumyData != null) {
                        ((Time[])object)[n17] = (Time)typeData.m_dumyData;
                    }
                    ++n17;
                }
                break;
            }
            case 16: 
            case 26: {
                object = new Timestamp[n2];
                int n18 = 0;
                while (n18 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n18];
                    if (typeData != null && typeData.m_dumyData != null) {
                        ((Timestamp[])object)[n18] = (Timestamp)typeData.m_dumyData;
                    }
                    ++n18;
                }
                break;
            }
            case 20: {
                object = new DmdbIntervalYM[n2];
                int n19 = 0;
                while (n19 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n19];
                    if (typeData != null && typeData.m_dumyData != null) {
                        ((DmdbIntervalYM[])object)[n19] = (DmdbIntervalYM)typeData.m_dumyData;
                    }
                    ++n19;
                }
                break;
            }
            case 21: {
                object = new DmdbIntervalDT[n2];
                int n20 = 0;
                while (n20 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n20];
                    if (typeData != null && typeData.m_dumyData != null) {
                        ((DmdbIntervalDT[])object)[n20] = (DmdbIntervalDT)typeData.m_dumyData;
                    }
                    ++n20;
                }
                break;
            }
            case 22: 
            case 23: 
            case 27: {
                object = new DmdbTimestamp[n2];
                int n21 = 0;
                while (n21 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n21];
                    if (typeData != null && typeData.m_dumyData != null) {
                        ((DmdbTimestamp[])object)[n21] = (DmdbTimestamp)typeData.m_dumyData;
                    }
                    ++n21;
                }
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                object = new Object[n2];
                int n22 = 0;
                while (n22 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n22];
                    object[n22] = typeData != null ? typeData.m_dumyData : null;
                    ++n22;
                }
                break;
            }
            case 12: {
                object = new DmdbBlob[n2];
                int n23 = 0;
                while (n23 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n23];
                    ((DmdbBlob[])object)[n23] = typeData != null && typeData.m_dumyData != null ? (DmdbBlob)typeData.m_dumyData : null;
                    ++n23;
                }
                break;
            }
            case 19: {
                object = new DmdbClob[n2];
                int n24 = 0;
                while (n24 < n2) {
                    TypeData typeData = dmdbArray.m_arrData[n4 + n24];
                    ((DmdbClob[])object)[n24] = typeData != null && typeData.m_dumyData != null ? (DmdbClob)typeData.m_dumyData : null;
                    ++n24;
                }
                break;
            }
            default: {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                return null;
            }
        }
        return object;
    }

    public Object toNumericArray(DmdbArray dmdbArray, long l2, int n2, int n3) {
        if (dmdbArray.m_objArray == null) {
            return null;
        }
        int n4 = (int)(l2 - 1L);
        Object[] objectArray = null;
        if (n3 == 1 && dmdbArray.m_objArray instanceof short[]) {
            short[] sArray = new short[n2];
            System.arraycopy(dmdbArray.m_objArray, n4, sArray, 0, n2);
            objectArray = sArray;
        } else if (n3 == 2 && dmdbArray.m_objArray instanceof int[]) {
            int[] nArray = new int[n2];
            System.arraycopy(dmdbArray.m_objArray, n4, nArray, 0, n2);
            objectArray = nArray;
        } else if (n3 == 3 && dmdbArray.m_objArray instanceof long[]) {
            long[] lArray = new long[n2];
            System.arraycopy(dmdbArray.m_objArray, n4, lArray, 0, n2);
            objectArray = lArray;
        } else if (n3 == 4 && dmdbArray.m_objArray instanceof float[]) {
            float[] fArray = new float[n2];
            System.arraycopy(dmdbArray.m_objArray, n4, fArray, 0, n2);
            objectArray = fArray;
        } else if (n3 == 5 && dmdbArray.m_objArray instanceof double[]) {
            double[] dArray = new double[n2];
            System.arraycopy(dmdbArray.m_objArray, n4, dArray, 0, n2);
            objectArray = dArray;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return objectArray;
    }

    public Object[] toJavaArray(DmdbStruct dmdbStruct) {
        TypeData[] typeDataArray = dmdbStruct.getAttribsTypeData();
        if (dmdbStruct.getAttribsTypeData() == null || dmdbStruct.getAttribsTypeData().length <= 0) {
            return null;
        }
        TypeDescriptor[] typeDescriptorArray = dmdbStruct.m_strctDesc.getItemsDesc();
        if (typeDataArray.length != typeDescriptorArray.length) {
            DBError.ECJDBC_STRUCT_MEM_NOT_MATCH.throwz(new Object[0]);
        }
        Object[] objectArray = new Object[typeDescriptorArray.length];
        int n2 = 0;
        while (n2 < typeDescriptorArray.length) {
            objectArray[n2] = typeDataArray[n2].m_dumyData;
            ++n2;
        }
        return objectArray;
    }

    public static byte[] toBytes(TypeData typeData, TypeDescriptor typeDescriptor) {
        byte[] byArray = typeDescriptor.getClassDescChkInfo();
        byte[] byArray2 = null;
        switch (typeDescriptor.getDType()) {
            case 117: {
                byArray2 = TypeData.arrayToBytes((DmdbArray)typeData, typeDescriptor);
                break;
            }
            case 122: {
                byArray2 = TypeData.sarrayToBytes((DmdbArray)typeData, typeDescriptor);
                break;
            }
            case 121: {
                byArray2 = TypeData.recordToBytes((DmdbStruct)typeData, typeDescriptor);
                break;
            }
            case 119: {
                byArray2 = TypeData.objToBytes(typeData, typeDescriptor);
                break;
            }
        }
        byte[] byArray3 = new byte[8 + byArray.length + byArray2.length];
        ByteUtil.setInt(byArray3, 0, 78111999);
        ByteUtil.setInt(byArray3, 4, byArray.length);
        System.arraycopy(byArray, 0, byArray3, 8, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 8 + byArray.length, byArray2.length);
        return byArray3;
    }
}

