/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.incubator.config;

import io.opentelemetry.api.incubator.config.ConfigProvider;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class GlobalConfigProvider {
    private static final AtomicReference<ConfigProvider> instance = new AtomicReference<ConfigProvider>(ConfigProvider.noop());
    @Nullable
    private static volatile Throwable setInstanceCaller;

    private GlobalConfigProvider() {
    }

    public static ConfigProvider get() {
        return instance.get();
    }

    public static void set(ConfigProvider configProvider) {
        boolean changed = instance.compareAndSet(ConfigProvider.noop(), configProvider);
        if (!changed && configProvider != ConfigProvider.noop()) {
            throw new IllegalStateException("GlobalConfigProvider.set has already been called. GlobalConfigProvider.set must be called only once before any calls to GlobalConfigProvider.get. Previous invocation set to cause of this exception.", setInstanceCaller);
        }
        setInstanceCaller = new Throwable();
    }

    public static void resetForTest() {
        instance.set(ConfigProvider.noop());
    }
}

