/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestResettingCounters {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestResettingCounters.class);
    @Rule
    public TestName name = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResettingCounters() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        Configuration conf = htu.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        byte[] table = Bytes.toBytes((String)this.name.getMethodName());
        byte[][] families = new byte[][]{Bytes.toBytes((String)"family1"), Bytes.toBytes((String)"family2"), Bytes.toBytes((String)"family3")};
        int numQualifiers = 10;
        byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes((String)("qf" + i));
        }
        int numRows = 10;
        byte[][] rows = new byte[numRows][];
        for (int i = 0; i < numRows; ++i) {
            rows[i] = Bytes.toBytes((String)("r" + i));
        }
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])table));
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo hri = new HRegionInfo(htd.getTableName(), null, null, false);
        String testDir = htu.getDataTestDir() + "/TestResettingCounters/";
        Path path = new Path(testDir);
        if (fs.exists(path) && !fs.delete(path, true)) {
            throw new IOException("Failed delete of " + path);
        }
        HRegion region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, path, conf, (TableDescriptor)htd);
        try {
            int i;
            Increment odd = new Increment(rows[0]);
            odd.setDurability(Durability.SKIP_WAL);
            Increment even = new Increment(rows[0]);
            even.setDurability(Durability.SKIP_WAL);
            Increment all = new Increment(rows[0]);
            all.setDurability(Durability.SKIP_WAL);
            for (i = 0; i < numQualifiers; ++i) {
                if (i % 2 == 0) {
                    even.addColumn(families[0], qualifiers[i], 1L);
                } else {
                    odd.addColumn(families[0], qualifiers[i], 1L);
                }
                all.addColumn(families[0], qualifiers[i], 1L);
            }
            for (i = 0; i < 5; ++i) {
                region.increment(odd, 0L, 0L);
            }
            region.flush(true);
            for (i = 0; i < 5; ++i) {
                region.increment(even, 0L, 0L);
            }
            Result result = region.increment(all, 0L, 0L);
            Assert.assertEquals((long)numQualifiers, (long)result.size());
            Cell[] kvs = result.rawCells();
            for (int i2 = 0; i2 < kvs.length; ++i2) {
                System.out.println(kvs[i2].toString());
                Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)kvs[i2], (byte[])qualifiers[i2]));
                Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kvs[i2])));
            }
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
        HBaseTestingUtility.closeRegionAndWAL(region);
    }
}

