/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import org.apache.hadoop.hbase.hbtop.screen.AbstractScreenView;
import org.apache.hadoop.hbase.hbtop.screen.Screen;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.MessageModeScreenPresenter;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MessageModeScreenView
extends AbstractScreenView {
    private final int row;
    private final MessageModeScreenPresenter messageModeScreenPresenter;

    public MessageModeScreenView(Screen screen, Terminal terminal, int row, String message, ScreenView nextScreenView) {
        super(screen, terminal);
        this.row = row;
        this.messageModeScreenPresenter = new MessageModeScreenPresenter(this, message, nextScreenView);
    }

    @Override
    public void init() {
        this.messageModeScreenPresenter.init();
        this.setTimer(2000L);
    }

    @Override
    public ScreenView handleTimer() {
        return this.messageModeScreenPresenter.returnToNextScreen();
    }

    @Override
    public ScreenView handleKeyPress(KeyPress keyPress) {
        this.cancelTimer();
        return this.messageModeScreenPresenter.returnToNextScreen();
    }

    public void showMessage(String message) {
        this.getTerminalPrinter(this.row).startHighlight().print(" ").print(message).print(" ").stopHighlight().endOfLine();
    }
}

