/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.cache;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.cache.FederationCache;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationJCache
extends FederationCache {
    private static final Logger LOG = LoggerFactory.getLogger(FederationJCache.class);
    private Cache<String, FederationCache.CacheRequest<String, ?>> cache;
    private int cacheTimeToLive;
    private boolean isCachingEnabled = false;
    private String className = this.getClass().getSimpleName();

    @Override
    public boolean isCachingEnabled() {
        return this.isCachingEnabled;
    }

    @Override
    public void initCache(org.apache.hadoop.conf.Configuration pConf, FederationStateStore pStateStore) {
        this.cacheTimeToLive = pConf.getInt("yarn.federation.cache-ttl.secs", 300);
        if (this.cacheTimeToLive <= 0) {
            this.isCachingEnabled = false;
            return;
        }
        this.setStateStore(pStateStore);
        CachingProvider jcacheProvider = Caching.getCachingProvider();
        CacheManager jcacheManager = jcacheProvider.getCacheManager();
        this.cache = jcacheManager.getCache(this.className);
        if (this.cache == null) {
            LOG.info("Creating a JCache Manager with name {}.", (Object)this.className);
            Duration cacheExpiry = new Duration(TimeUnit.SECONDS, (long)this.cacheTimeToLive);
            FactoryBuilder.SingletonFactory expiryPolicySingletonFactory = new FactoryBuilder.SingletonFactory((Object)new CreatedExpiryPolicy(cacheExpiry));
            MutableConfiguration configuration = new MutableConfiguration();
            configuration.setStoreByValue(false);
            configuration.setExpiryPolicyFactory((Factory)expiryPolicySingletonFactory);
            this.cache = jcacheManager.createCache(this.className, (Configuration)configuration);
        }
        this.isCachingEnabled = true;
    }

    @Override
    public void clearCache() {
        CachingProvider jcacheProvider = Caching.getCachingProvider();
        CacheManager jcacheManager = jcacheProvider.getCacheManager();
        jcacheManager.destroyCache(this.className);
        this.cache = null;
    }

    @Override
    public Map<SubClusterId, SubClusterInfo> getSubClusters(boolean filterInactiveSubClusters) throws YarnException {
        String cacheKey = this.buildCacheKey(this.className, "getSubClusters", Boolean.toString(filterInactiveSubClusters));
        FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterInfo>> cacheRequest = (FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterInfo>>)this.cache.get((Object)cacheKey);
        if (cacheRequest == null) {
            cacheRequest = this.buildGetSubClustersCacheRequest(this.className, filterInactiveSubClusters);
            this.cache.put((Object)cacheKey, cacheRequest);
        }
        return FederationJCache.buildSubClusterInfoMap(cacheRequest);
    }

    @Override
    public Map<String, SubClusterPolicyConfiguration> getPoliciesConfigurations() throws Exception {
        String cacheKey = this.buildCacheKey(this.className, "getPoliciesConfigurations");
        FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterPolicyConfiguration>> cacheRequest = (FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterPolicyConfiguration>>)this.cache.get((Object)cacheKey);
        if (cacheRequest == null) {
            cacheRequest = this.buildGetPoliciesConfigurationsCacheRequest(this.className);
            this.cache.put((Object)cacheKey, cacheRequest);
        }
        return FederationJCache.buildPolicyConfigMap(cacheRequest);
    }

    @Override
    public SubClusterId getApplicationHomeSubCluster(ApplicationId appId) throws Exception {
        String cacheKey = this.buildCacheKey(this.className, "getApplicationHomeSubCluster", appId.toString());
        FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterId>> cacheRequest = (FederationCache.CacheRequest<String, FederationCache.CacheResponse<SubClusterId>>)this.cache.get((Object)cacheKey);
        if (cacheRequest == null) {
            cacheRequest = this.buildGetApplicationHomeSubClusterRequest(this.className, appId);
            this.cache.put((Object)cacheKey, cacheRequest);
        }
        FederationCache.CacheResponse response = (FederationCache.CacheResponse)FederationCache.ApplicationHomeSubClusterCacheResponse.class.cast(cacheRequest.getValue());
        return (SubClusterId)response.getItem();
    }

    @Override
    public void removeSubCluster(boolean flushCache) {
        String cacheKey = this.buildCacheKey(this.className, "getSubClusters", Boolean.toString(flushCache));
        this.cache.remove((Object)cacheKey);
    }

    @VisibleForTesting
    public Cache<String, FederationCache.CacheRequest<String, ?>> getCache() {
        return this.cache;
    }

    @VisibleForTesting
    public String getAppHomeSubClusterCacheKey(ApplicationId appId) throws YarnException {
        return this.buildCacheKey(this.className, "getApplicationHomeSubCluster", appId.toString());
    }
}

