/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.apache.hadoop.fs.azurebfs.extensions.EncryptionContextProvider;
import org.apache.hadoop.fs.azurebfs.security.ABFSKey;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.security.EncodingHelper;

public class ContextProviderEncryptionAdapter
extends ContextEncryptionAdapter {
    private final String path;
    private final ABFSKey encryptionContext;
    private ABFSKey encryptionKey;
    private final EncryptionContextProvider provider;

    public ContextProviderEncryptionAdapter(EncryptionContextProvider provider, String path, byte[] encryptionContext) throws IOException {
        this.provider = provider;
        this.path = path;
        Objects.requireNonNull(encryptionContext, "Encryption context should not be null.");
        this.encryptionContext = new ABFSKey(Base64.getDecoder().decode(encryptionContext));
        Arrays.fill(encryptionContext, (byte)0);
        this.computeKeys();
    }

    public ContextProviderEncryptionAdapter(EncryptionContextProvider provider, String path) throws IOException {
        this.provider = provider;
        this.path = path;
        this.encryptionContext = provider.getEncryptionContext(path);
        Objects.requireNonNull(this.encryptionContext, "Encryption context should not be null.");
        this.computeKeys();
    }

    private void computeKeys() throws IOException {
        this.encryptionKey = this.provider.getEncryptionKey(this.path, this.encryptionContext);
        Objects.requireNonNull(this.encryptionKey, "Encryption key should not be null.");
    }

    @Override
    public String getEncodedKey() {
        return EncodingHelper.getBase64EncodedString(this.encryptionKey.getEncoded());
    }

    @Override
    public String getEncodedKeySHA() {
        return EncodingHelper.getBase64EncodedString(EncodingHelper.getSHA256Hash(this.encryptionKey.getEncoded()));
    }

    @Override
    public String getEncodedContext() {
        return EncodingHelper.getBase64EncodedString(this.encryptionContext.getEncoded());
    }

    @Override
    public void destroy() {
        if (this.encryptionContext != null) {
            this.encryptionContext.destroy();
        }
        if (this.encryptionKey != null) {
            this.encryptionKey.destroy();
        }
    }
}

