/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.QueryMetricsUtils;
import com.microsoft.azure.cosmosdb.QueryPreparationTimes;
import com.microsoft.azure.cosmosdb.RuntimeExecutionTimes;
import com.microsoft.azure.cosmosdb.internal.query.metrics.ClientSideMetrics;
import com.microsoft.azure.cosmosdb.internal.query.metrics.FetchExecutionRange;
import com.microsoft.azure.cosmosdb.internal.query.metrics.QueryMetricsTextWriter;
import com.microsoft.azure.cosmosdb.internal.query.metrics.SchedulingTimeSpan;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public final class QueryMetrics {
    public static QueryMetrics ZERO = new QueryMetrics(new ArrayList<String>(), 0L, 0L, 0L, 0L, 0L, Duration.ZERO, QueryPreparationTimes.ZERO, Duration.ZERO, Duration.ZERO, Duration.ZERO, RuntimeExecutionTimes.ZERO, Duration.ZERO, ClientSideMetrics.ZERO);
    private final long retrievedDocumentCount;
    private final long retrievedDocumentSize;
    private final long outputDocumentCount;
    private final long outputDocumentSize;
    private final long indexHitDocumentCount;
    private final Duration totalQueryExecutionTime;
    private final QueryPreparationTimes queryPreparationTimes;
    private final Duration indexLookupTime;
    private final Duration documentLoadTime;
    private final Duration vmExecutionTime;
    private final RuntimeExecutionTimes runtimeExecutionTimes;
    private final Duration documentWriteTime;
    private final ClientSideMetrics clientSideMetrics;
    private final List<String> activityIds;

    public QueryMetrics(List<String> activities, long retrievedDocumentCount, long retrievedDocumentSize, long outputDocumentCount, long outputDocumentSize, long indexHitCount, Duration totalQueryExecutionTime, QueryPreparationTimes queryPreparationTimes, Duration indexLookupTime, Duration documentLoadTime, Duration vmExecutionTime, RuntimeExecutionTimes runtimeExecutionTimes, Duration documentWriteTime, ClientSideMetrics clientSideMetrics) {
        this.retrievedDocumentCount = retrievedDocumentCount;
        this.retrievedDocumentSize = retrievedDocumentSize;
        this.outputDocumentCount = outputDocumentCount;
        this.outputDocumentSize = outputDocumentSize;
        this.indexHitDocumentCount = indexHitCount;
        this.totalQueryExecutionTime = totalQueryExecutionTime;
        this.queryPreparationTimes = queryPreparationTimes;
        this.indexLookupTime = indexLookupTime;
        this.documentLoadTime = documentLoadTime;
        this.vmExecutionTime = vmExecutionTime;
        this.runtimeExecutionTimes = runtimeExecutionTimes;
        this.documentWriteTime = documentWriteTime;
        this.clientSideMetrics = clientSideMetrics;
        this.activityIds = activities;
    }

    public long getRetrievedDocumentCount() {
        return this.retrievedDocumentCount;
    }

    public long getRetrievedDocumentSize() {
        return this.retrievedDocumentSize;
    }

    public long getOutputDocumentCount() {
        return this.outputDocumentCount;
    }

    public long getOutputDocumentSize() {
        return this.outputDocumentSize;
    }

    public long getIndexHitDocumentCount() {
        return this.indexHitDocumentCount;
    }

    public double getIndexHitRatio() {
        return this.retrievedDocumentCount == 0L ? 1.0 : (double)this.indexHitDocumentCount / (double)this.retrievedDocumentCount;
    }

    public Duration getTotalQueryExecutionTime() {
        return this.totalQueryExecutionTime;
    }

    public QueryPreparationTimes getQueryPreparationTimes() {
        return this.queryPreparationTimes;
    }

    public Duration getIndexLookupTime() {
        return this.indexLookupTime;
    }

    public Duration getDocumentLoadTime() {
        return this.documentLoadTime;
    }

    public Duration getVMExecutionTime() {
        return this.vmExecutionTime;
    }

    public RuntimeExecutionTimes getRuntimeExecutionTimes() {
        return this.runtimeExecutionTimes;
    }

    public Duration getDocumentWriteTime() {
        return this.documentWriteTime;
    }

    ClientSideMetrics getClientSideMetrics() {
        return this.clientSideMetrics;
    }

    public long getRetries() {
        return this.clientSideMetrics.getRetries();
    }

    public QueryMetrics add(QueryMetrics ... queryMetricsArgs) {
        ArrayList<QueryMetrics> queryMetricsList = new ArrayList<QueryMetrics>();
        for (QueryMetrics queryMetrics : queryMetricsArgs) {
            queryMetricsList.add(queryMetrics);
        }
        queryMetricsList.add(this);
        return QueryMetrics.createFromCollection(queryMetricsList);
    }

    private String toTextString() {
        return this.toTextString(0);
    }

    private String toTextString(int indentLevel) {
        StringBuilder stringBuilder = new StringBuilder();
        QueryMetricsTextWriter queryMetricsTextWriter = new QueryMetricsTextWriter(stringBuilder);
        queryMetricsTextWriter.writeQueryMetrics(this);
        return stringBuilder.toString();
    }

    static QueryMetrics createFromCollection(Collection<QueryMetrics> queryMetricsCollection) {
        long retrievedDocumentCount = 0L;
        long retrievedDocumentSize = 0L;
        long outputDocumentCount = 0L;
        long outputDocumentSize = 0L;
        long indexHitDocumentCount = 0L;
        Duration totalQueryExecutionTime = Duration.ZERO;
        ArrayList<QueryPreparationTimes> queryPreparationTimesCollection = new ArrayList<QueryPreparationTimes>();
        Duration indexLookupTime = Duration.ZERO;
        Duration documentLoadTime = Duration.ZERO;
        Duration vmExecutionTime = Duration.ZERO;
        ArrayList<RuntimeExecutionTimes> runtimeExecutionTimesCollection = new ArrayList<RuntimeExecutionTimes>();
        Duration documentWriteTime = Duration.ZERO;
        ArrayList<ClientSideMetrics> clientSideMetricsCollection = new ArrayList<ClientSideMetrics>();
        ArrayList<String> activityIds = new ArrayList<String>();
        for (QueryMetrics queryMetrics : queryMetricsCollection) {
            if (queryMetrics == null) {
                throw new NullPointerException("queryMetricsList can not have null elements");
            }
            activityIds.addAll(queryMetrics.activityIds);
            retrievedDocumentCount += queryMetrics.retrievedDocumentCount;
            retrievedDocumentSize += queryMetrics.retrievedDocumentSize;
            outputDocumentCount += queryMetrics.outputDocumentCount;
            outputDocumentSize += queryMetrics.outputDocumentSize;
            indexHitDocumentCount += queryMetrics.indexHitDocumentCount;
            totalQueryExecutionTime = totalQueryExecutionTime.plus(queryMetrics.totalQueryExecutionTime);
            queryPreparationTimesCollection.add(queryMetrics.queryPreparationTimes);
            indexLookupTime = indexLookupTime.plus(queryMetrics.indexLookupTime);
            documentLoadTime = documentLoadTime.plus(queryMetrics.documentLoadTime);
            vmExecutionTime = vmExecutionTime.plus(queryMetrics.vmExecutionTime);
            runtimeExecutionTimesCollection.add(queryMetrics.runtimeExecutionTimes);
            documentWriteTime = documentWriteTime.plus(queryMetrics.documentWriteTime);
            clientSideMetricsCollection.add(queryMetrics.clientSideMetrics);
        }
        return new QueryMetrics(activityIds, retrievedDocumentCount, retrievedDocumentSize, outputDocumentCount, outputDocumentSize, indexHitDocumentCount, totalQueryExecutionTime, QueryPreparationTimes.createFromCollection(queryPreparationTimesCollection), indexLookupTime, documentLoadTime, vmExecutionTime, RuntimeExecutionTimes.createFromCollection(runtimeExecutionTimesCollection), documentWriteTime, ClientSideMetrics.createFromCollection(clientSideMetricsCollection));
    }

    private static double getOrDefault(HashMap<String, Double> metrics, String key) {
        Double doubleReference = metrics.get(key);
        return doubleReference == null ? 0.0 : doubleReference;
    }

    static QueryMetrics createFromDelimitedString(String delimitedString) {
        HashMap<String, Double> metrics = QueryMetricsUtils.parseDelimitedString(delimitedString);
        return QueryMetrics.createFromDelimitedStringAndClientSideMetrics(delimitedString, new ClientSideMetrics(0, 0.0, new ArrayList<FetchExecutionRange>(), new ArrayList<ImmutablePair<String, SchedulingTimeSpan>>()), "");
    }

    static QueryMetrics createFromDelimitedStringAndClientSideMetrics(String delimitedString, ClientSideMetrics clientSideMetrics, String activityId) {
        HashMap<String, Double> metrics = QueryMetricsUtils.parseDelimitedString(delimitedString);
        double indexHitRatio = metrics.get("indexUtilizationRatio");
        double retrievedDocumentCount = metrics.get("retrievedDocumentCount");
        long indexHitCount = (long)(indexHitRatio * retrievedDocumentCount);
        double outputDocumentCount = metrics.get("outputDocumentCount");
        double outputDocumentSize = metrics.get("outputDocumentSize");
        double retrievedDocumentSize = metrics.get("retrievedDocumentSize");
        Duration totalQueryExecutionTime = QueryMetricsUtils.getDurationFromMetrics(metrics, "totalExecutionTimeInMs");
        ArrayList<String> activities = new ArrayList<String>();
        activities.add(activityId);
        return new QueryMetrics(activities, (long)retrievedDocumentCount, (long)retrievedDocumentSize, (long)outputDocumentCount, (long)outputDocumentSize, indexHitCount, totalQueryExecutionTime, QueryPreparationTimes.createFromDelimitedString(delimitedString), QueryMetricsUtils.getDurationFromMetrics(metrics, "indexLookupTimeInMs"), QueryMetricsUtils.getDurationFromMetrics(metrics, "documentLoadTimeInMs"), QueryMetricsUtils.getDurationFromMetrics(metrics, "VMExecutionTimeInMs"), RuntimeExecutionTimes.createFromDelimitedString(delimitedString), QueryMetricsUtils.getDurationFromMetrics(metrics, "writeOutputTimeInMs"), clientSideMetrics);
    }

    public String toString() {
        return this.toTextString(0);
    }
}

