/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateDuration;

public enum CalendarDateUnit implements TemporalUnit,
CalendarDate.Resolution,
Comparable<CalendarDateUnit>,
Serializable
{
    NANOS(ChronoUnit.NANOS, TimeUnit.NANOSECONDS),
    MICROS(ChronoUnit.MICROS, TimeUnit.MICROSECONDS),
    MILLIS(ChronoUnit.MILLIS, TimeUnit.MILLISECONDS),
    SECOND(ChronoUnit.SECONDS, TimeUnit.SECONDS),
    MINUTE(ChronoUnit.MINUTES, TimeUnit.MINUTES),
    HOUR(ChronoUnit.HOURS, TimeUnit.HOURS),
    DAY(ChronoUnit.DAYS, TimeUnit.DAYS),
    WEEK(ChronoUnit.WEEKS, 604800000L),
    MONTH(ChronoUnit.MONTHS, 2629746000L),
    QUARTER(null, 7889238000L),
    YEAR(ChronoUnit.YEARS, 31556952000L),
    DECADE(ChronoUnit.DECADES, 315569520000L),
    CENTURY(ChronoUnit.CENTURIES, 3155695200000L),
    MILLENIUM(ChronoUnit.MILLENNIA, 31556952000000L);

    private final ChronoUnit myChronoUnit;
    private final long myHalf;
    private final long myDurationInMillis;
    private final TimeUnit myTimeUnit;
    private final long myDurationInNanos;

    private CalendarDateUnit(ChronoUnit chronoUnit, long millis) {
        this.myChronoUnit = chronoUnit;
        this.myTimeUnit = null;
        this.myDurationInMillis = millis;
        this.myHalf = this.myDurationInMillis / 2L;
        this.myDurationInNanos = millis * 1000000L;
    }

    private CalendarDateUnit(ChronoUnit chronoUnit, TimeUnit timeUnit) {
        this.myChronoUnit = chronoUnit;
        this.myTimeUnit = timeUnit;
        this.myDurationInMillis = this.myTimeUnit.toMillis(1L);
        this.myHalf = this.myDurationInMillis / 2L;
        this.myDurationInNanos = timeUnit.toNanos(1L);
    }

    @Override
    public <R extends Temporal> R addTo(R temporal, long amount) {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.addTo(temporal, amount);
        }
        return ChronoUnit.MONTHS.addTo(temporal, 3L * amount);
    }

    @Override
    public CalendarDate adjustInto(Calendar temporal) {
        return CalendarDate.make(temporal, this);
    }

    @Override
    public CalendarDate adjustInto(Date temporal) {
        return CalendarDate.make(temporal, this);
    }

    @Override
    public CalendarDate adjustInto(Temporal temporal) {
        if (temporal instanceof CalendarDate) {
            return CalendarDate.make(((CalendarDate)temporal).millis, this);
        }
        long seconds = temporal.getLong(ChronoField.INSTANT_SECONDS);
        long nanos = temporal.getLong(ChronoField.MILLI_OF_SECOND);
        long millis = seconds / 1000L + nanos * 0L;
        return CalendarDate.make(millis, this);
    }

    @Override
    public long between(Temporal temporal1Inclusive, Temporal temporal2Exclusive) {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.between(temporal1Inclusive, temporal2Exclusive);
        }
        return ChronoUnit.MONTHS.between(temporal1Inclusive, temporal2Exclusive) / 3L;
    }

    public CalendarDateDuration convert(CalendarDateDuration sourceDuration) {
        return sourceDuration.convertTo(this);
    }

    public double convert(CalendarDateUnit aSourceDurationUnit) {
        return this.convert(PrimitiveMath.ONE, aSourceDurationUnit);
    }

    public double convert(double aSourceDurationMeasure, CalendarDateUnit aSourceDurationUnit) {
        double tmpDestinationSize;
        double tmpSourceSize = aSourceDurationUnit.size();
        if (tmpSourceSize > (tmpDestinationSize = (double)this.myDurationInMillis)) {
            double tmpScale = tmpSourceSize / tmpDestinationSize;
            return aSourceDurationMeasure * tmpScale;
        }
        if (tmpSourceSize < tmpDestinationSize) {
            double tmpScale = tmpDestinationSize / tmpSourceSize;
            return aSourceDurationMeasure / tmpScale;
        }
        return aSourceDurationMeasure;
    }

    public long convert(long sourceMeassure, CalendarDateUnit sourceUnit) {
        Optional<TimeUnit> tmpTimeUnit = sourceUnit.getTimeUnit();
        if (this.myTimeUnit != null && tmpTimeUnit.isPresent()) {
            return this.myTimeUnit.convert(sourceMeassure, tmpTimeUnit.get());
        }
        return Math.round(this.convert((double)sourceMeassure, sourceUnit));
    }

    public long count(Calendar aFromValue, Calendar aToValue) {
        return (this.myHalf + this.toTimeInMillis(aToValue) - this.toTimeInMillis(aFromValue)) / this.myDurationInMillis;
    }

    public long count(Date aFromValue, Date aToValue) {
        return (this.myHalf + this.toTimeInMillis(aToValue) - this.toTimeInMillis(aFromValue)) / this.myDurationInMillis;
    }

    public long count(long aFromValue, long aToValue) {
        return (this.myHalf + this.toTimeInMillis(aToValue) - this.toTimeInMillis(aFromValue)) / this.myDurationInMillis;
    }

    public long get(TemporalUnit unit) {
        if (unit == this) {
            return this.myDurationInMillis;
        }
        return 0L;
    }

    public Optional<ChronoUnit> getChronoUnit() {
        return Optional.ofNullable(this.myChronoUnit);
    }

    @Override
    public Duration getDuration() {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.getDuration();
        }
        return ChronoUnit.MONTHS.getDuration().multipliedBy(3L);
    }

    public Optional<TimeUnit> getTimeUnit() {
        return Optional.ofNullable(this.myTimeUnit);
    }

    public List<TemporalUnit> getUnits() {
        return Collections.singletonList(this);
    }

    public boolean isCalendarUnit() {
        return DAY.size() <= this.size();
    }

    @Override
    public boolean isDateBased() {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.isDateBased();
        }
        return true;
    }

    @Override
    public boolean isDurationEstimated() {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.isDurationEstimated();
        }
        return true;
    }

    @Override
    public boolean isTimeBased() {
        if (this.myChronoUnit != null) {
            return this.myChronoUnit.isTimeBased();
        }
        return false;
    }

    public void round(Calendar calendar) {
        if (MILLIS.size() < this.myDurationInMillis) {
            calendar.set(14, 0);
            if (SECOND.size() < this.myDurationInMillis) {
                calendar.set(13, 0);
                if (MINUTE.size() < this.myDurationInMillis) {
                    calendar.set(12, 0);
                    if (HOUR.size() < this.myDurationInMillis) {
                        calendar.set(11, 12);
                        if (DAY.size() < this.myDurationInMillis) {
                            if (WEEK.size() == this.myDurationInMillis) {
                                calendar.add(3, 1);
                                calendar.set(7, calendar.getFirstDayOfWeek());
                                calendar.add(7, -1);
                            } else if (MONTH.size() == this.myDurationInMillis) {
                                calendar.add(2, 1);
                                calendar.set(5, 1);
                                calendar.add(5, -1);
                            } else if (QUARTER.size() == this.myDurationInMillis) {
                                calendar.set(2, 3 * (calendar.get(2) / 3 + 1));
                                calendar.set(5, 1);
                                calendar.add(5, -1);
                            } else if (YEAR.size() == this.myDurationInMillis) {
                                calendar.add(1, 1);
                                calendar.set(6, 1);
                                calendar.add(6, -1);
                            } else if (DECADE.size() == this.myDurationInMillis) {
                                calendar.set(1, 10 + 10 * (calendar.get(1) / 10));
                                calendar.set(6, 1);
                                calendar.add(6, -1);
                            } else if (CENTURY.size() == this.myDurationInMillis) {
                                calendar.set(1, 100 + 100 * (calendar.get(1) / 100));
                                calendar.set(6, 1);
                                calendar.add(6, -1);
                            } else if (MILLENIUM.size() == this.myDurationInMillis) {
                                calendar.set(1, 1000 + 1000 * (calendar.get(1) / 1000));
                                calendar.set(6, 1);
                                calendar.add(6, -1);
                            }
                        }
                    }
                }
            }
        }
    }

    public void round(Date date) {
        date.setTime(this.toTimeInMillis(date));
    }

    public long size() {
        return this.myDurationInMillis;
    }

    public Calendar step(Calendar aCalendar) {
        return this.step(aCalendar, 1);
    }

    public Calendar step(Calendar aCalendar, int aStepCount) {
        Calendar retVal = (Calendar)aCalendar.clone();
        switch (this) {
            case MILLENIUM: {
                retVal.set(6, 1);
                retVal.add(1, 1000 * aStepCount + 1);
                retVal.add(6, -1);
                break;
            }
            case CENTURY: {
                retVal.set(6, 1);
                retVal.add(1, 100 * aStepCount + 1);
                retVal.add(6, -1);
                break;
            }
            case DECADE: {
                retVal.set(6, 1);
                retVal.add(1, 10 * aStepCount + 1);
                retVal.add(6, -1);
                break;
            }
            case YEAR: {
                retVal.set(6, 1);
                retVal.add(1, aStepCount + 1);
                retVal.add(6, -1);
                break;
            }
            case QUARTER: {
                retVal.set(5, 1);
                retVal.add(2, 3 * aStepCount + 1);
                retVal.add(5, -1);
                break;
            }
            case MONTH: {
                retVal.set(5, 1);
                retVal.add(2, aStepCount + 1);
                retVal.add(5, -1);
                break;
            }
            case WEEK: {
                retVal.set(7, aCalendar.getFirstDayOfWeek());
                retVal.add(3, aStepCount + 1);
                retVal.add(7, -1);
                break;
            }
            case DAY: {
                retVal.add(5, aStepCount);
                break;
            }
            case HOUR: {
                retVal.add(11, aStepCount);
                break;
            }
            case MINUTE: {
                retVal.add(12, aStepCount);
                break;
            }
            case SECOND: {
                retVal.add(13, aStepCount);
                break;
            }
            case MILLIS: {
                retVal.add(14, aStepCount);
                break;
            }
        }
        this.round(retVal);
        return retVal;
    }

    public Date step(Date aDate) {
        return this.step(aDate, 1);
    }

    public Date step(Date aDate, int aStepCount) {
        return new Date(this.toTimeInMillis(aDate) + (long)aStepCount * this.size());
    }

    public long step(long aTimeInMillis) {
        return this.step(aTimeInMillis, 1);
    }

    public long step(long aTimeInMillis, int aStepCount) {
        return this.toTimeInMillis(aTimeInMillis) + (long)aStepCount * this.size();
    }

    @Override
    public long toDurationInMillis() {
        return this.myDurationInMillis;
    }

    @Override
    public long toDurationInNanos() {
        return this.myDurationInNanos;
    }

    public long toTimeInMillis(Calendar aCalendar) {
        Calendar tmpClone = (Calendar)aCalendar.clone();
        this.round(tmpClone);
        return tmpClone.getTimeInMillis();
    }

    public long toTimeInMillis(Date aDate) {
        return this.toTimeInMillis(aDate.getTime());
    }

    public long toTimeInMillis(long aTimeInMillis) {
        return aTimeInMillis / this.myDurationInMillis * this.myDurationInMillis + this.myHalf;
    }
}

