/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.BasicMatrix;

public class MatrixError
extends ProgrammingError {
    public static void throwIfMultiplicationNotPossible(Access2D<?> aMtrxLeft, Access2D<?> aMtrxRight) {
        if (aMtrxLeft.countColumns() != aMtrxRight.countRows()) {
            throw new MatrixError("The column dimension of the left matrix does not match the row dimension of the right matrix!");
        }
    }

    public static void throwIfNotEqualColumnDimensions(Access2D<?> aMtrx1, Access2D<?> aMtrx2) {
        if (aMtrx1.countColumns() != aMtrx2.countColumns()) {
            throw new MatrixError("Column dimensions are not equal!");
        }
    }

    public static void throwIfNotEqualDimensions(Access2D<?> aMtrx1, Access2D<?> aMtrx2) {
        MatrixError.throwIfNotEqualRowDimensions(aMtrx1, aMtrx2);
        MatrixError.throwIfNotEqualColumnDimensions(aMtrx1, aMtrx2);
    }

    public static void throwIfNotEqualRowDimensions(Access2D<?> aMtrx1, Access2D<?> aMtrx2) {
        if (aMtrx1.countRows() != aMtrx2.countRows()) {
            throw new MatrixError("Row dimensions are not equal!");
        }
    }

    public static void throwIfNotSquare(BasicMatrix aMtrx) {
        if (aMtrx.countRows() != aMtrx.countColumns()) {
            throw new MatrixError("Matrix is not square!");
        }
    }

    public MatrixError(String aString) {
        super(aString);
    }
}

