/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.QueryMetrics;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.query.metrics.ClientSideMetrics;
import com.microsoft.azure.cosmosdb.internal.query.metrics.FetchExecutionRangeAccumulator;
import com.microsoft.azure.cosmosdb.internal.query.metrics.SchedulingStopwatch;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import com.microsoft.azure.cosmosdb.rx.internal.BackoffRetryUtility;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.InvalidPartitionExceptionRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.PartitionKeyRangeGoneRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.caches.IPartitionKeyRangeCache;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import com.microsoft.azure.cosmosdb.rx.internal.query.CompositeContinuationToken;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentQueryExecutionContextBase;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.OrderByContinuationToken;
import com.microsoft.azure.cosmosdb.rx.internal.query.Paginator;
import com.microsoft.azure.cosmosdb.rx.internal.query.TakeContinuationToken;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import rx.Observable;
import rx.Single;
import rx.functions.Func1;
import rx.functions.Func2;

public class DefaultDocumentQueryExecutionContext<T extends Resource>
extends DocumentQueryExecutionContextBase<T> {
    private boolean isContinuationExpected;
    private volatile int retries = -1;
    private final SchedulingStopwatch fetchSchedulingMetrics;
    private final FetchExecutionRangeAccumulator fetchExecutionRangeAccumulator;
    private static final String DEFAULT_PARTITION_KEY_RANGE_ID = "0";

    public DefaultDocumentQueryExecutionContext(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, UUID correlatedActivityId, boolean isContinuationExpected) {
        super(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, false, correlatedActivityId);
        this.isContinuationExpected = isContinuationExpected;
        this.fetchSchedulingMetrics = new SchedulingStopwatch();
        this.fetchSchedulingMetrics.ready();
        this.fetchExecutionRangeAccumulator = new FetchExecutionRangeAccumulator(DEFAULT_PARTITION_KEY_RANGE_ID);
    }

    protected PartitionKeyInternal getPartitionKeyInternal() {
        return this.feedOptions.getPartitionKey() == null ? null : this.feedOptions.getPartitionKey().getInternalPartitionKey();
    }

    @Override
    public Observable<FeedResponse<T>> executeAsync() {
        FeedOptions newFeedOptions;
        String originalContinuation;
        if (this.feedOptions == null) {
            this.feedOptions = new FeedOptions();
        }
        if (DefaultDocumentQueryExecutionContext.isClientSideContinuationToken(originalContinuation = (newFeedOptions = new FeedOptions(this.feedOptions)).getRequestContinuation())) {
            newFeedOptions.setRequestContinuation(null);
            newFeedOptions.setMaxDegreeOfParallelism(Integer.MAX_VALUE);
        }
        int maxPageSize = newFeedOptions.getMaxItemCount() != null ? newFeedOptions.getMaxItemCount() : 100;
        Func2 createRequestFunc = (continuationToken, pageSize) -> this.createRequestAsync((String)continuationToken, (Integer)pageSize);
        Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc = this.executeInternalAsyncFunc();
        return Paginator.getPaginatedQueryResultAsObservable(newFeedOptions, (Func2<String, Integer, RxDocumentServiceRequest>)createRequestFunc, executeFunc, this.resourceType, maxPageSize);
    }

    public Single<List<PartitionKeyRange>> getTargetPartitionKeyRanges(String resourceId, List<Range<String>> queryRanges) {
        Range r = new Range((Comparable)((Object)""), (Comparable)((Object)"FF"), true, false);
        return this.client.getPartitionKeyRangeCache().tryGetOverlappingRangesAsync(resourceId, (Range<String>)r, false, null);
    }

    protected Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeInternalAsyncFunc() {
        RxCollectionCache collectionCache = this.client.getCollectionCache();
        IPartitionKeyRangeCache partitionKeyRangeCache = this.client.getPartitionKeyRangeCache();
        IDocumentClientRetryPolicy retryPolicyInstance = this.client.getResetSessionTokenRetryPolicy().getRequestPolicy();
        retryPolicyInstance = new InvalidPartitionExceptionRetryPolicy(collectionCache, retryPolicyInstance, this.resourceLink, this.feedOptions);
        if (this.resourceTypeEnum.isPartitioned()) {
            retryPolicyInstance = new PartitionKeyRangeGoneRetryPolicy(collectionCache, partitionKeyRangeCache, PathsHelper.getCollectionPath((String)this.resourceLink), retryPolicyInstance, this.feedOptions);
        }
        IDocumentClientRetryPolicy finalRetryPolicyInstance = retryPolicyInstance;
        Func1 executeFunc = req -> {
            finalRetryPolicyInstance.onBeforeSendRequest((RxDocumentServiceRequest)req);
            this.fetchExecutionRangeAccumulator.beginFetchRange();
            this.fetchSchedulingMetrics.start();
            return BackoffRetryUtility.executeRetry(() -> {
                ++this.retries;
                return this.executeRequestAsync((RxDocumentServiceRequest)req);
            }, finalRetryPolicyInstance).toObservable().map(tFeedResponse -> {
                this.fetchSchedulingMetrics.stop();
                this.fetchExecutionRangeAccumulator.endFetchRange(tFeedResponse.getActivityId(), (long)tFeedResponse.getResults().size(), (long)this.retries);
                ImmutablePair schedulingTimeSpanMap = new ImmutablePair((Object)DEFAULT_PARTITION_KEY_RANGE_ID, (Object)this.fetchSchedulingMetrics.getElapsedTime());
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)tFeedResponse.getResponseHeaders().get("x-ms-documentdb-query-metrics")))) {
                    QueryMetrics qm = BridgeInternal.createQueryMetricsFromDelimitedStringAndClientSideMetrics((String)((String)tFeedResponse.getResponseHeaders().get("x-ms-documentdb-query-metrics")), (ClientSideMetrics)new ClientSideMetrics(this.retries, tFeedResponse.getRequestCharge(), this.fetchExecutionRangeAccumulator.getExecutionRanges(), Arrays.asList(schedulingTimeSpanMap)), (String)tFeedResponse.getActivityId());
                    BridgeInternal.putQueryMetricsIntoMap((FeedResponse)tFeedResponse, (String)DEFAULT_PARTITION_KEY_RANGE_ID, (QueryMetrics)qm);
                }
                return tFeedResponse;
            });
        };
        return executeFunc;
    }

    private Single<FeedResponse<T>> executeOnceAsync(IDocumentClientRetryPolicy retryPolicyInstance, String continuationToken) {
        RxDocumentServiceRequest request = this.createRequestAsync(continuationToken, this.feedOptions.getMaxItemCount());
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        if (!Strings.isNullOrEmpty((String)((String)request.getHeaders().get("x-ms-documentdb-partitionkey"))) || !request.getResourceType().isPartitioned()) {
            return this.executeRequestAsync(request);
        }
        request.UseGatewayMode = true;
        return this.executeRequestAsync(request);
    }

    public RxDocumentServiceRequest createRequestAsync(String continuationToken, Integer maxPageSize) {
        Map<String, String> requestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(continuationToken, maxPageSize));
        RxDocumentServiceRequest request = this.createDocumentServiceRequest(requestHeaders, this.query, this.getPartitionKeyInternal());
        if (!StringUtils.isEmpty((CharSequence)this.feedOptions.getPartitionKeyRangeIdInternal())) {
            request.routeTo(new PartitionKeyRangeIdentity(this.feedOptions.getPartitionKeyRangeIdInternal()));
        }
        return request;
    }

    private static boolean isClientSideContinuationToken(String continuationToken) {
        if (continuationToken != null) {
            Utils.ValueHolder outCompositeContinuationToken = new Utils.ValueHolder();
            if (CompositeContinuationToken.tryParse(continuationToken, (Utils.ValueHolder<CompositeContinuationToken>)outCompositeContinuationToken)) {
                return true;
            }
            Utils.ValueHolder outOrderByContinuationToken = new Utils.ValueHolder();
            if (OrderByContinuationToken.tryParse(continuationToken, (Utils.ValueHolder<OrderByContinuationToken>)outOrderByContinuationToken)) {
                return true;
            }
            Utils.ValueHolder outTakeContinuationToken = new Utils.ValueHolder();
            if (TakeContinuationToken.tryParse(continuationToken, (Utils.ValueHolder<TakeContinuationToken>)outTakeContinuationToken)) {
                return true;
            }
        }
        return false;
    }
}

