/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Arrays;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.apache.hadoop.security.TestLdapGroupsMappingBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLdapGroupsMappingWithPosixGroup
extends TestLdapGroupsMappingBase {
    @Before
    public void setupMocks() throws NamingException {
        Attribute uidNumberAttr = (Attribute)Mockito.mock(Attribute.class);
        Attribute gidNumberAttr = (Attribute)Mockito.mock(Attribute.class);
        Attribute uidAttr = (Attribute)Mockito.mock(Attribute.class);
        Attributes attributes = this.getAttributes();
        Mockito.when((Object)uidAttr.get()).thenReturn((Object)"some_user");
        Mockito.when((Object)uidNumberAttr.get()).thenReturn((Object)"700");
        Mockito.when((Object)gidNumberAttr.get()).thenReturn((Object)"600");
        Mockito.when((Object)attributes.get((String)Mockito.eq((Object)"uid"))).thenReturn((Object)uidAttr);
        Mockito.when((Object)attributes.get((String)Mockito.eq((Object)"uidNumber"))).thenReturn((Object)uidNumberAttr);
        Mockito.when((Object)attributes.get((String)Mockito.eq((Object)"gidNumber"))).thenReturn((Object)gidNumberAttr);
    }

    @Test
    public void testGetGroups() throws NamingException {
        Mockito.when(this.getContext().search(ArgumentMatchers.anyString(), Mockito.contains((String)"posix"), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(this.getUserNames(), (Object[])new NamingEnumeration[]{this.getGroupNames()});
        this.doTestGetGroups(Arrays.asList(this.getTestGroups()), 2);
    }

    private void doTestGetGroups(List<String> expectedGroups, int searchTimes) throws NamingException {
        String ldapUrl = "ldap://test";
        Configuration conf = this.getBaseConf(ldapUrl);
        conf.set("hadoop.security.group.mapping.ldap.search.filter.group", "(objectClass=posixGroup)(cn={0})");
        conf.set("hadoop.security.group.mapping.ldap.search.filter.user", "(objectClass=posixAccount)");
        conf.set("hadoop.security.group.mapping.ldap.search.attr.member", "memberUid");
        conf.set("hadoop.security.group.mapping.ldap.posix.attr.uid.name", "uidNumber");
        conf.set("hadoop.security.group.mapping.ldap.posix.attr.gid.name", "gidNumber");
        conf.set("hadoop.security.group.mapping.ldap.search.attr.group.name", "cn");
        LdapGroupsMapping groupsMapping = this.getGroupsMapping();
        groupsMapping.setConf(conf);
        List groups = groupsMapping.getGroups("some_user");
        Assert.assertEquals(expectedGroups, (Object)groups);
        groupsMapping.getConf().set("hadoop.security.group.mapping.ldap.posix.attr.uid.name", "uid");
        Assert.assertEquals(expectedGroups, (Object)groups);
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)searchTimes))).search(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class));
    }
}

