/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.filter;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.filter.GlobFilter;
import org.apache.hadoop.metrics2.filter.RegexFilter;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPatternFilter {
    @Test
    public void emptyConfigShouldAccept() {
        SubsetConfiguration empty = new ConfigBuilder().subset("");
        TestPatternFilter.shouldAccept(empty, "anything");
        TestPatternFilter.shouldAccept(empty, Arrays.asList(Interns.tag((String)"key", (String)"desc", (String)"value")));
        TestPatternFilter.shouldAccept(empty, TestPatternFilter.mockMetricsRecord("anything", Arrays.asList(Interns.tag((String)"key", (String)"desc", (String)"value"))));
    }

    @Test
    public void includeOnlyShouldOnlyIncludeMatched() {
        SubsetConfiguration wl = new ConfigBuilder().add("p.include", "foo").add("p.include.tags", "foo:f").subset("p");
        TestPatternFilter.shouldAccept(wl, "foo");
        TestPatternFilter.shouldAccept(wl, Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""), Interns.tag((String)"foo", (String)"", (String)"f")), new boolean[]{false, true});
        TestPatternFilter.shouldAccept(wl, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""), Interns.tag((String)"foo", (String)"", (String)"f"))));
        TestPatternFilter.shouldReject(wl, "bar");
        TestPatternFilter.shouldReject(wl, Arrays.asList(Interns.tag((String)"bar", (String)"", (String)"")));
        TestPatternFilter.shouldReject(wl, Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"boo")));
        TestPatternFilter.shouldReject(wl, TestPatternFilter.mockMetricsRecord("bar", Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f"))));
        TestPatternFilter.shouldReject(wl, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""))));
    }

    @Test
    public void excludeOnlyShouldOnlyExcludeMatched() {
        SubsetConfiguration bl = new ConfigBuilder().add("p.exclude", "foo").add("p.exclude.tags", "foo:f").subset("p");
        TestPatternFilter.shouldAccept(bl, "bar");
        TestPatternFilter.shouldAccept(bl, Arrays.asList(Interns.tag((String)"bar", (String)"", (String)"")));
        TestPatternFilter.shouldAccept(bl, TestPatternFilter.mockMetricsRecord("bar", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""))));
        TestPatternFilter.shouldReject(bl, "foo");
        TestPatternFilter.shouldReject(bl, Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""), Interns.tag((String)"foo", (String)"", (String)"f")), new boolean[]{true, false});
        TestPatternFilter.shouldReject(bl, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""))));
        TestPatternFilter.shouldReject(bl, TestPatternFilter.mockMetricsRecord("bar", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""), Interns.tag((String)"foo", (String)"", (String)"f"))));
    }

    @Test
    public void shouldAcceptUnmatchedWhenBothAreConfigured() {
        SubsetConfiguration c = new ConfigBuilder().add("p.include", "foo").add("p.include.tags", "foo:f").add("p.exclude", "bar").add("p.exclude.tags", "bar:b").subset("p");
        TestPatternFilter.shouldAccept(c, "foo");
        TestPatternFilter.shouldAccept(c, Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f")));
        TestPatternFilter.shouldAccept(c, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f"))));
        TestPatternFilter.shouldReject(c, "bar");
        TestPatternFilter.shouldReject(c, Arrays.asList(Interns.tag((String)"bar", (String)"", (String)"b")));
        TestPatternFilter.shouldReject(c, TestPatternFilter.mockMetricsRecord("bar", Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f"))));
        TestPatternFilter.shouldReject(c, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)"b"))));
        TestPatternFilter.shouldAccept(c, "foobar");
        TestPatternFilter.shouldAccept(c, Arrays.asList(Interns.tag((String)"foobar", (String)"", (String)"")));
        TestPatternFilter.shouldAccept(c, TestPatternFilter.mockMetricsRecord("foobar", Arrays.asList(Interns.tag((String)"foobar", (String)"", (String)""))));
    }

    @Test
    public void includeShouldOverrideExclude() {
        SubsetConfiguration c = new ConfigBuilder().add("p.include", "foo").add("p.include.tags", "foo:f").add("p.exclude", "foo").add("p.exclude.tags", "foo:f").subset("p");
        TestPatternFilter.shouldAccept(c, "foo");
        TestPatternFilter.shouldAccept(c, Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f")));
        TestPatternFilter.shouldAccept(c, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f"))));
    }

    static void shouldAccept(SubsetConfiguration conf, String s) {
        Assert.assertTrue((String)("accepts " + s), (boolean)TestPatternFilter.newGlobFilter(conf).accepts(s));
        Assert.assertTrue((String)("accepts " + s), (boolean)TestPatternFilter.newRegexFilter(conf).accepts(s));
    }

    static void shouldAccept(SubsetConfiguration conf, List<MetricsTag> tags) {
        TestPatternFilter.shouldAcceptImpl(true, conf, tags, new boolean[]{true});
    }

    static void shouldAccept(SubsetConfiguration conf, List<MetricsTag> tags, boolean[] expectedAcceptedSpec) {
        TestPatternFilter.shouldAcceptImpl(true, conf, tags, expectedAcceptedSpec);
    }

    static void shouldReject(SubsetConfiguration conf, List<MetricsTag> tags) {
        TestPatternFilter.shouldAcceptImpl(false, conf, tags, new boolean[]{false});
    }

    static void shouldReject(SubsetConfiguration conf, List<MetricsTag> tags, boolean[] expectedAcceptedSpec) {
        TestPatternFilter.shouldAcceptImpl(false, conf, tags, expectedAcceptedSpec);
    }

    private static void shouldAcceptImpl(boolean expectAcceptList, SubsetConfiguration conf, List<MetricsTag> tags, boolean[] expectedAcceptedSpec) {
        GlobFilter globFilter = TestPatternFilter.newGlobFilter(conf);
        RegexFilter regexFilter = TestPatternFilter.newRegexFilter(conf);
        Assert.assertEquals((String)("accepts " + tags), (Object)expectAcceptList, (Object)globFilter.accepts(tags));
        Assert.assertEquals((String)("accepts " + tags), (Object)expectAcceptList, (Object)regexFilter.accepts(tags));
        int acceptedCount = 0;
        for (int i = 0; i < tags.size(); ++i) {
            MetricsTag tag = tags.get(i);
            boolean actGlob = globFilter.accepts(tag);
            boolean actRegex = regexFilter.accepts(tag);
            Assert.assertEquals((String)("accepts " + tag), (Object)expectedAcceptedSpec[i], (Object)actGlob);
            Assert.assertEquals((Object)actGlob, (Object)actRegex);
            if (!actGlob) continue;
            ++acceptedCount;
        }
        if (expectAcceptList) {
            Assert.assertTrue((String)("No tag of the following accepted: " + tags), (acceptedCount > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("No tag of the following rejected: " + tags), (acceptedCount < tags.size() ? 1 : 0) != 0);
        }
    }

    static void shouldAccept(SubsetConfiguration conf, MetricsRecord record) {
        Assert.assertTrue((String)("accepts " + record), (boolean)TestPatternFilter.newGlobFilter(conf).accepts(record));
        Assert.assertTrue((String)("accepts " + record), (boolean)TestPatternFilter.newRegexFilter(conf).accepts(record));
    }

    static void shouldReject(SubsetConfiguration conf, String s) {
        Assert.assertTrue((String)("rejects " + s), (!TestPatternFilter.newGlobFilter(conf).accepts(s) ? 1 : 0) != 0);
        Assert.assertTrue((String)("rejects " + s), (!TestPatternFilter.newRegexFilter(conf).accepts(s) ? 1 : 0) != 0);
    }

    static void shouldReject(SubsetConfiguration conf, MetricsRecord record) {
        Assert.assertTrue((String)("rejects " + record), (!TestPatternFilter.newGlobFilter(conf).accepts(record) ? 1 : 0) != 0);
        Assert.assertTrue((String)("rejects " + record), (!TestPatternFilter.newRegexFilter(conf).accepts(record) ? 1 : 0) != 0);
    }

    public static GlobFilter newGlobFilter(SubsetConfiguration conf) {
        GlobFilter f = new GlobFilter();
        f.init(conf);
        return f;
    }

    public static RegexFilter newRegexFilter(SubsetConfiguration conf) {
        RegexFilter f = new RegexFilter();
        f.init(conf);
        return f;
    }

    private static MetricsRecord mockMetricsRecord(String name, List<MetricsTag> tags) {
        MetricsRecord record = (MetricsRecord)Mockito.mock(MetricsRecord.class);
        Mockito.when((Object)record.name()).thenReturn((Object)name);
        Mockito.when((Object)record.tags()).thenReturn(tags);
        return record;
    }
}

