/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTableRW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppToFlowTableRW
extends BaseTableRW<AppToFlowTable> {
    private static final String PREFIX = "yarn.timeline-service.app-flow";
    public static final String TABLE_NAME_CONF_NAME = "yarn.timeline-service.app-flow.table.name";
    private static final String DEFAULT_TABLE_NAME = "timelineservice.app_flow";
    private static final Logger LOG = LoggerFactory.getLogger(AppToFlowTableRW.class);

    public AppToFlowTableRW() {
        super(TABLE_NAME_CONF_NAME, DEFAULT_TABLE_NAME);
    }

    @Override
    public void createTable(Admin admin, Configuration hbaseConf) throws IOException {
        TableName table = this.getTableName(hbaseConf);
        if (admin.tableExists(table)) {
            throw new IOException("Table " + table.getNameAsString() + " already exists.");
        }
        HTableDescriptor appToFlowTableDescp = new HTableDescriptor(table);
        HColumnDescriptor mappCF = new HColumnDescriptor(AppToFlowColumnFamily.MAPPING.getBytes());
        mappCF.setBloomFilterType(BloomType.ROWCOL);
        appToFlowTableDescp.addFamily(mappCF);
        admin.createTable((TableDescriptor)appToFlowTableDescp);
        LOG.info("Status of table creation for " + table.getNameAsString() + "=" + admin.tableExists(table));
    }
}

