/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.primitive.DataSeries;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.type.ColourData;
import org.ojalgo.type.TypeUtils;

abstract class TreeSeries<K extends Comparable<? super K>, N extends Number, I extends TreeSeries<K, N, I>>
extends TreeMap<K, N>
implements BasicSeries<K, N> {
    private ColourData myColour = null;
    private String myName = null;

    private TreeSeries(Comparator<? super K> comparator) {
        super(comparator);
    }

    protected TreeSeries() {
    }

    protected TreeSeries(Map<? extends K, ? extends N> map) {
        super(map);
    }

    protected TreeSeries(SortedMap<K, ? extends N> sortedMap) {
        super(sortedMap);
    }

    @Override
    public PrimitiveSeries asPrimitive() {
        double[] retVal = new double[this.size()];
        int i = 0;
        for (Number tmpValue : this.values()) {
            retVal[i] = tmpValue.doubleValue();
            ++i;
        }
        return DataSeries.wrap(retVal);
    }

    public I colour(ColourData colour) {
        this.myColour = colour;
        return (I)this;
    }

    @Override
    public final double doubleValue(K key) {
        return ((Number)this.get(key)).doubleValue();
    }

    @Override
    public N firstValue() {
        return (N)this.get((Comparable)this.firstKey());
    }

    @Override
    public ColourData getColour() {
        return this.myColour;
    }

    @Override
    public String getName() {
        if (this.myName == null) {
            this.myName = UUID.randomUUID().toString();
        }
        return this.myName;
    }

    @Override
    public N lastValue() {
        return (N)this.get((Comparable)this.lastKey());
    }

    public I name(String name) {
        this.myName = name;
        return (I)this;
    }

    @Override
    public String toString() {
        StringBuilder retVal = this.toStringFirstPart();
        this.appendLastPartToString(retVal);
        return retVal.toString();
    }

    final void appendLastPartToString(StringBuilder builder) {
        if (this.myColour != null) {
            builder.append(TypeUtils.toHexString(this.myColour.getRGB()));
            builder.append('\u00a0');
        }
        if (this.size() <= 30) {
            builder.append(super.toString());
        } else {
            builder.append("First:");
            builder.append(this.firstEntry());
            builder.append('\u00a0');
            builder.append("Last:");
            builder.append(this.lastEntry());
            builder.append('\u00a0');
            builder.append("Size:");
            builder.append(this.size());
        }
    }

    void setColour(ColourData colour) {
        this.colour(colour);
    }

    void setName(String name) {
        this.name(name);
    }

    StringBuilder toStringFirstPart() {
        StringBuilder retVal = new StringBuilder();
        if (this.myName != null) {
            retVal.append(this.myName);
            retVal.append('\u00a0');
        }
        return retVal;
    }
}

