/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.manager;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.hadoop.shaded.org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.HomeAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.AbstractPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.router.UniformRandomRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;

public class HomePolicyManager
extends AbstractPolicyManager {
    private WeightedPolicyInfo weightedPolicyInfo = new WeightedPolicyInfo();

    public HomePolicyManager() {
        this.weightedPolicyInfo.setRouterPolicyWeights(Collections.singletonMap(new SubClusterIdInfo(""), Float.valueOf(1.0f)));
        this.weightedPolicyInfo.setAMRMPolicyWeights(Collections.singletonMap(new SubClusterIdInfo(""), Float.valueOf(1.0f)));
        this.routerFederationPolicy = UniformRandomRouterPolicy.class;
        this.amrmProxyFederationPolicy = HomeAMRMProxyPolicy.class;
    }

    @Override
    public SubClusterPolicyConfiguration serializeConf() throws FederationPolicyInitializationException {
        ByteBuffer buf = this.weightedPolicyInfo.toByteBuffer();
        return SubClusterPolicyConfiguration.newInstance(this.getQueue(), this.getClass().getCanonicalName(), buf);
    }

    @Override
    public WeightedPolicyInfo getWeightedPolicyInfo() {
        throw new NotImplementedException("HomePolicyManager does not implement getWeightedPolicyInfo.");
    }

    @Override
    public void setWeightedPolicyInfo(WeightedPolicyInfo weightedPolicyInfo) {
        throw new NotImplementedException("HomePolicyManager does not implement setWeightedPolicyInfo.");
    }

    @Override
    public boolean isSupportWeightedPolicyInfo() {
        return false;
    }
}

