/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.codec;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUtil {
    private static final Logger logger = LoggerFactory.getLogger(CleanUtil.class);
    private static final Object unsafe;
    private static final Method cleanerMethod;
    private static final Method cleanMethod;
    private static final Method invokeCleanerMethod;
    private static final int majorVersion;

    private CleanUtil() {
    }

    public static void cleanDirectBuffer(ByteBuffer buf) {
        if (cleanMethod != null) {
            try {
                cleanMethod.invoke(cleanerMethod.invoke((Object)buf, new Object[0]), new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                logger.warn("Error while cleaning up the DirectBuffer", (Throwable)e);
            }
        } else if (invokeCleanerMethod != null) {
            try {
                invokeCleanerMethod.invoke(unsafe, buf);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                logger.warn("Error while cleaning up the DirectBuffer", (Throwable)e);
            }
        }
    }

    static {
        majorVersion = Integer.parseInt(System.getProperty("java.version").split("\\D+")[0]);
        ByteBuffer tempBuffer = ByteBuffer.allocateDirect(0);
        Method cleanerMethodLocal = null;
        Method cleanMethodLocal = null;
        Object unsafeLocal = null;
        Method invokeCleanerMethodLocal = null;
        if (majorVersion >= 9) {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Field theUnsafe = clazz.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                unsafeLocal = theUnsafe.get(null);
                invokeCleanerMethodLocal = clazz.getMethod("invokeCleaner", ByteBuffer.class);
                invokeCleanerMethodLocal.invoke(unsafeLocal, tempBuffer);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.warn("Cannot use direct ByteBuffer cleaner, memory leaking may occur", (Throwable)e);
                unsafeLocal = null;
                invokeCleanerMethodLocal = null;
            }
        } else {
            try {
                cleanerMethodLocal = tempBuffer.getClass().getMethod("cleaner", new Class[0]);
                cleanerMethodLocal.setAccessible(true);
                Object cleanerObject = cleanerMethodLocal.invoke((Object)tempBuffer, new Object[0]);
                cleanMethodLocal = cleanerObject.getClass().getMethod("clean", new Class[0]);
                cleanMethodLocal.invoke(cleanerObject, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.warn("Cannot use direct ByteBuffer cleaner, memory leaking may occur", (Throwable)e);
                cleanerMethodLocal = null;
                cleanMethodLocal = null;
            }
        }
        cleanerMethod = cleanerMethodLocal;
        cleanMethod = cleanMethodLocal;
        unsafe = unsafeLocal;
        invokeCleanerMethod = invokeCleanerMethodLocal;
    }
}

