/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.io;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.io.SingleFileWriter;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.store.format.FieldStatsCollector;
import org.apache.flink.table.store.format.FileStatsExtractor;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class StatsCollectingSingleFileWriter<T, R>
extends SingleFileWriter<T, R> {
    @Nullable
    private final FileStatsExtractor fileStatsExtractor;
    @Nullable
    private FieldStatsCollector fieldStatsCollector = null;

    public StatsCollectingSingleFileWriter(BulkWriter.Factory<RowData> factory, Path path, Function<T, RowData> converter, RowType writeSchema, @Nullable FileStatsExtractor fileStatsExtractor) {
        super(factory, path, converter);
        this.fileStatsExtractor = fileStatsExtractor;
        if (this.fileStatsExtractor == null) {
            this.fieldStatsCollector = new FieldStatsCollector(writeSchema);
        }
    }

    @Override
    public void write(T record) throws IOException {
        RowData rowData = this.writeImpl(record);
        if (this.fieldStatsCollector != null) {
            this.fieldStatsCollector.collect(rowData);
        }
    }

    public FieldStats[] fieldStats() throws IOException {
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot access metric unless the writer is closed.");
        if (this.fileStatsExtractor != null) {
            return this.fileStatsExtractor.extract(this.path);
        }
        return this.fieldStatsCollector.extract();
    }
}

