/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.codegen;

import java.util.List;
import org.apache.flink.table.store.codegen.CodeGenLoader;
import org.apache.flink.table.store.codegen.GeneratedClass;
import org.apache.flink.table.store.codegen.NormalizedKeyComputer;
import org.apache.flink.table.store.codegen.Projection;
import org.apache.flink.table.store.codegen.RecordComparator;
import org.apache.flink.table.store.utils.BinaryRowDataUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class CodeGenUtils {
    public static final Projection EMPTY_PROJECTION = input -> BinaryRowDataUtil.EMPTY_ROW;

    public static Projection newProjection(RowType inputType, int[] mapping) {
        if (mapping.length == 0) {
            return EMPTY_PROJECTION;
        }
        return CodeGenLoader.getCodeGenerator().generateProjection("Projection", inputType, mapping).newInstance(CodeGenUtils.class.getClassLoader());
    }

    public static NormalizedKeyComputer newNormalizedKeyComputer(List<LogicalType> fieldTypes, String name) {
        return CodeGenLoader.getCodeGenerator().generateNormalizedKeyComputer(fieldTypes, name).newInstance(CodeGenUtils.class.getClassLoader());
    }

    public static GeneratedClass<RecordComparator> generateRecordComparator(List<LogicalType> fieldTypes, String name) {
        return CodeGenLoader.getCodeGenerator().generateRecordComparator(fieldTypes, name);
    }

    public static RecordComparator newRecordComparator(List<LogicalType> fieldTypes, String name) {
        return CodeGenUtils.generateRecordComparator(fieldTypes, name).newInstance(CodeGenUtils.class.getClassLoader());
    }
}

