/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.legacy.table.connector.source.SourceFunctionProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.streaming.util.retryable.RetryPredicates;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.LookupJoinHintOptions;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsLookupCustomShuffle;
import org.apache.flink.table.connector.source.lookup.AsyncLookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.FullCachingLookupProvider;
import org.apache.flink.table.connector.source.lookup.LookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.PartialCachingAsyncLookupProvider;
import org.apache.flink.table.connector.source.lookup.PartialCachingLookupProvider;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncLookupFunction;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.legacy.connector.source.AsyncTableFunctionProvider;
import org.apache.flink.table.legacy.connector.source.TableFunctionProvider;
import org.apache.flink.table.legacy.sources.LookupableTableSource;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.utils.TransformationMetadata;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.runtime.functions.table.lookup.CachingAsyncLookupFunction;
import org.apache.flink.table.runtime.functions.table.lookup.CachingLookupFunction;
import org.apache.flink.table.runtime.functions.table.lookup.fullcache.CacheLoader;
import org.apache.flink.table.runtime.functions.table.lookup.fullcache.LookupFullCache;
import org.apache.flink.table.runtime.functions.table.lookup.fullcache.inputformat.InputFormatCacheLoader;
import org.apache.flink.table.runtime.keyselector.GenericRowDataKeySelector;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.lookup.ResultRetryStrategy;
import org.apache.flink.table.runtime.operators.join.lookup.RetryableAsyncLookupFunctionDelegator;
import org.apache.flink.table.runtime.operators.join.lookup.RetryableLookupFunctionDelegator;
import org.apache.flink.table.runtime.partitioner.RowDataCustomStreamPartitioner;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

@Internal
public final class LookupJoinUtil
extends FunctionCallUtil {
    private LookupJoinUtil() {
    }

    public static int[] getOrderedLookupKeys(Collection<Integer> allLookupKeys) {
        ArrayList<Integer> lookupKeyIndicesInOrder = new ArrayList<Integer>(allLookupKeys);
        lookupKeyIndicesInOrder.sort(Integer::compareTo);
        return lookupKeyIndicesInOrder.stream().mapToInt(Integer::intValue).toArray();
    }

    public static FunctionCallUtil.AsyncOptions getMergedAsyncOptions(RelHint lookupHint, TableConfig config, ChangelogMode inputChangelogMode) {
        Configuration confFromHint = lookupHint == null ? new Configuration() : Configuration.fromMap(lookupHint.kvOptions);
        ExecutionConfigOptions.AsyncOutputMode asyncOutputMode = LookupJoinUtil.coalesce((ExecutionConfigOptions.AsyncOutputMode)confFromHint.get(LookupJoinHintOptions.ASYNC_OUTPUT_MODE), (ExecutionConfigOptions.AsyncOutputMode)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_OUTPUT_MODE));
        boolean keyOrdered = LookupJoinUtil.isKeyOrdered(inputChangelogMode, asyncOutputMode, (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_KEY_ORDERED));
        return new FunctionCallUtil.AsyncOptions(LookupJoinUtil.coalesce((Integer)confFromHint.get(LookupJoinHintOptions.ASYNC_CAPACITY), (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_BUFFER_CAPACITY)), LookupJoinUtil.coalesce((Duration)confFromHint.get(LookupJoinHintOptions.ASYNC_TIMEOUT), (Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_TIMEOUT)).toMillis(), keyOrdered, LookupJoinUtil.convert(inputChangelogMode, asyncOutputMode));
    }

    public static boolean isAsyncLookup(RelOptTable temporalTable, Collection<Integer> lookupKeys, @Nullable RelHint lookupHint, boolean upsertMaterialize, boolean preferCustomShuffle) {
        boolean preferAsync = LookupJoinUtil.preferAsync(lookupHint);
        if (upsertMaterialize) {
            return false;
        }
        boolean syncFound = false;
        boolean asyncFound = false;
        if (temporalTable instanceof TableSourceTable) {
            int[] lookupKeyIndicesInOrder = LookupJoinUtil.getOrderedLookupKeys(lookupKeys);
            LookupTableSource.LookupRuntimeProvider provider = LookupJoinUtil.createLookupRuntimeProvider(temporalTable, lookupKeyIndicesInOrder, preferCustomShuffle);
            if (provider instanceof LookupFunctionProvider || provider instanceof TableFunctionProvider) {
                syncFound = true;
            }
            if (provider instanceof AsyncLookupFunctionProvider || provider instanceof AsyncTableFunctionProvider) {
                asyncFound = true;
            }
        } else if (temporalTable instanceof LegacyTableSourceTable) {
            LegacyTableSourceTable legacyTableSourceTable = (LegacyTableSourceTable)temporalTable;
            LookupableTableSource tableSource = (LookupableTableSource)legacyTableSourceTable.tableSource();
            if (tableSource.isAsyncEnabled()) {
                asyncFound = true;
            } else {
                syncFound = true;
            }
        }
        if (!syncFound && !asyncFound) {
            throw new TableException(String.format("table %s is neither TableSourceTable not LegacyTableSourceTable", temporalTable.getQualifiedName()));
        }
        return preferAsync ? asyncFound : !syncFound;
    }

    public static UserDefinedFunction getLookupFunction(RelOptTable temporalTable, Collection<Integer> lookupKeys, ClassLoader classLoader, boolean async, ResultRetryStrategy retryStrategy, boolean preferCustomShuffle) {
        UserDefinedFunction lookupFunction = null;
        int[] lookupKeyIndicesInOrder = LookupJoinUtil.getOrderedLookupKeys(lookupKeys);
        if (temporalTable instanceof TableSourceTable) {
            lookupFunction = LookupJoinUtil.findLookupFunctionFromNewSource((TableSourceTable)temporalTable, lookupKeyIndicesInOrder, retryStrategy, async, classLoader, preferCustomShuffle);
        } else if (temporalTable instanceof LegacyTableSourceTable) {
            lookupFunction = LookupJoinUtil.findLookupFunctionFromLegacySource((LegacyTableSourceTable)temporalTable, lookupKeyIndicesInOrder, async);
        }
        if (null == lookupFunction) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append("Required ").append(async ? "async" : "sync").append(" lookup function by planner, but table ").append(temporalTable.getQualifiedName()).append("does not offer a valid lookup function neither as TableSourceTable nor LegacyTableSourceTable");
            throw new TableException(errorMsg.toString());
        }
        return lookupFunction;
    }

    private static boolean preferAsync(@Nullable RelHint lookupHint) {
        if (null == lookupHint) {
            return true;
        }
        Configuration conf = Configuration.fromMap(lookupHint.kvOptions);
        Boolean async = (Boolean)conf.get(LookupJoinHintOptions.ASYNC_LOOKUP);
        return null == async || async != false;
    }

    private static LookupFunction wrapSyncRetryDelegator(LookupFunctionProvider provider, ResultRetryStrategy retryStrategy) {
        if (retryStrategy != null && retryStrategy != ResultRetryStrategy.NO_RETRY_STRATEGY) {
            return new RetryableLookupFunctionDelegator(provider.createLookupFunction(), retryStrategy);
        }
        return provider.createLookupFunction();
    }

    private static AsyncLookupFunction wrapASyncRetryDelegator(AsyncLookupFunctionProvider provider, ResultRetryStrategy retryStrategy) {
        if (retryStrategy != null && retryStrategy != ResultRetryStrategy.NO_RETRY_STRATEGY) {
            return new RetryableAsyncLookupFunctionDelegator(provider.createAsyncLookupFunction(), retryStrategy);
        }
        return provider.createAsyncLookupFunction();
    }

    private static UserDefinedFunction findLookupFunctionFromNewSource(TableSourceTable temporalTable, int[] lookupKeyIndicesInOrder, ResultRetryStrategy retryStrategy, boolean async, ClassLoader classLoader, boolean preferCustomShuffle) {
        LookupTableSource.LookupRuntimeProvider provider = LookupJoinUtil.createLookupRuntimeProvider(temporalTable, lookupKeyIndicesInOrder, preferCustomShuffle);
        if (async) {
            if (provider instanceof AsyncLookupFunctionProvider) {
                if (provider instanceof PartialCachingAsyncLookupProvider) {
                    PartialCachingAsyncLookupProvider partialCachingLookupProvider = (PartialCachingAsyncLookupProvider)provider;
                    return new CachingAsyncLookupFunction(partialCachingLookupProvider.getCache(), LookupJoinUtil.wrapASyncRetryDelegator((AsyncLookupFunctionProvider)partialCachingLookupProvider, retryStrategy));
                }
                return LookupJoinUtil.wrapASyncRetryDelegator((AsyncLookupFunctionProvider)provider, retryStrategy);
            }
            if (provider instanceof AsyncTableFunctionProvider) {
                return ((AsyncTableFunctionProvider)provider).createAsyncTableFunction();
            }
        } else {
            if (provider instanceof LookupFunctionProvider) {
                if (provider instanceof PartialCachingLookupProvider) {
                    PartialCachingLookupProvider partialCachingLookupProvider = (PartialCachingLookupProvider)provider;
                    return new CachingLookupFunction(partialCachingLookupProvider.getCache(), LookupJoinUtil.wrapSyncRetryDelegator((LookupFunctionProvider)partialCachingLookupProvider, retryStrategy));
                }
                if (provider instanceof FullCachingLookupProvider) {
                    FullCachingLookupProvider fullCachingLookupProvider = (FullCachingLookupProvider)provider;
                    RowType tableSourceRowType = FlinkTypeFactory.toLogicalRowType(temporalTable.getRowType());
                    LookupFullCache fullCache = LookupJoinUtil.createFullCache(fullCachingLookupProvider, lookupKeyIndicesInOrder, classLoader, tableSourceRowType);
                    return new CachingLookupFunction((LookupCache)fullCache, fullCachingLookupProvider.createLookupFunction());
                }
                return LookupJoinUtil.wrapSyncRetryDelegator((LookupFunctionProvider)provider, retryStrategy);
            }
            if (provider instanceof TableFunctionProvider) {
                return ((TableFunctionProvider)provider).createTableFunction();
            }
        }
        return null;
    }

    public static boolean enableLookupShuffle(RelHint lookupJoinHint) {
        if (null != lookupJoinHint) {
            Configuration conf = Configuration.fromMap(lookupJoinHint.kvOptions);
            return (Boolean)conf.get(LookupJoinHintOptions.SHUFFLE);
        }
        return false;
    }

    public static boolean tableProvidesCustomPartitioner(RelOptTable table) {
        if (table instanceof TableSourceTable) {
            DynamicTableSource dynamicTableSource = ((TableSourceTable)table).tableSource();
            return dynamicTableSource instanceof LookupTableSource && dynamicTableSource instanceof SupportsLookupCustomShuffle;
        }
        return false;
    }

    private static UserDefinedFunction findLookupFunctionFromLegacySource(LegacyTableSourceTable temporalTable, int[] lookupKeyIndicesInOrder, boolean async) {
        String[] lookupFieldNamesInOrder = (String[])IntStream.of(lookupKeyIndicesInOrder).mapToObj(temporalTable.getRowType().getFieldNames()::get).toArray(String[]::new);
        LegacyTableSourceTable legacyTableSourceTable = temporalTable;
        LookupableTableSource tableSource = (LookupableTableSource)legacyTableSourceTable.tableSource();
        if (async && tableSource.isAsyncEnabled()) {
            return tableSource.getAsyncLookupFunction(lookupFieldNamesInOrder);
        }
        if (!async && !tableSource.isAsyncEnabled()) {
            return tableSource.getLookupFunction(lookupFieldNamesInOrder);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static LookupTableSource.LookupRuntimeProvider createLookupRuntimeProvider(RelOptTable temporalTable, int[] lookupKeyIndicesInOrder, boolean preferCustomShuffle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Transformation<RowData> tryApplyCustomShufflePartitioner(PlannerBase planner, RelOptTable table, RowType inputRowType, Map<Integer, FunctionCallUtil.FunctionParam> allLookupKeys, Transformation<RowData> inputTransformation, ChangelogMode inputChangelogMode, TransformationMetadata metadata) {
        Optional partitioner = ((SupportsLookupCustomShuffle)((TableSourceTable)table).tableSource()).getPartitioner();
        if (partitioner.isEmpty()) {
            return inputTransformation;
        }
        if (!((SupportsLookupCustomShuffle.InputDataPartitioner)partitioner.get()).isDeterministic() && !inputChangelogMode.containsOnly(RowKind.INSERT)) {
            return inputTransformation;
        }
        GenericRowDataKeySelector lookupTableKeySelector = (GenericRowDataKeySelector)KeySelectorUtil.getLookupKeysSelectorFromLeftTable(planner.getFlinkContext().getClassLoader(), allLookupKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        RowDataCustomStreamPartitioner streamPartitioner = new RowDataCustomStreamPartitioner((SupportsLookupCustomShuffle.InputDataPartitioner)partitioner.get(), (RowDataKeySelector)lookupTableKeySelector);
        return ExecNodeUtil.createPartitionTransformation(inputTransformation, metadata, streamPartitioner);
    }

    private static LookupFullCache createFullCache(FullCachingLookupProvider provider, int[] lookupKeyIndicesInOrder, ClassLoader classLoader, RowType tableSourceRowType) {
        ScanTableSource.ScanRuntimeProvider scanProvider = provider.getScanRuntimeProvider();
        Preconditions.checkArgument((boolean)scanProvider.isBounded(), (Object)"ScanRuntimeProvider that is used for data loading in lookup 'FULL' cache must be bounded.");
        GenericRowDataKeySelector lookupTableKeySelector = (GenericRowDataKeySelector)KeySelectorUtil.getRowDataSelector(classLoader, lookupKeyIndicesInOrder, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)tableSourceRowType), GenericRowData.class);
        if (scanProvider instanceof InputFormatProvider) {
            InputFormat inputFormat = ((InputFormatProvider)scanProvider).createInputFormat();
            InputFormatCacheLoader cacheLoader = new InputFormatCacheLoader(inputFormat, lookupTableKeySelector, InternalSerializers.create((RowType)tableSourceRowType));
            return new LookupFullCache((CacheLoader)cacheLoader, provider.getCacheReloadTrigger());
        }
        if (scanProvider instanceof SourceFunctionProvider) {
            throw new UnsupportedOperationException("Full caching using SourceFunction currently not supported.");
        }
        throw new UnsupportedOperationException("Currently only InputFormatProvider and SourceFunctionProvider are supported as ScanRuntimeProviders for Full caching lookup join.");
    }

    private static boolean isKeyOrdered(ChangelogMode inputChangelogMode, ExecutionConfigOptions.AsyncOutputMode asyncOutputMode, boolean allowKeyOrdered) {
        return allowKeyOrdered && !inputChangelogMode.containsOnly(RowKind.INSERT) && asyncOutputMode == ExecutionConfigOptions.AsyncOutputMode.ALLOW_UNORDERED;
    }

    private static /* synthetic */ int[][] lambda$createLookupRuntimeProvider$2(int x$0) {
        return new int[x$0][];
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="RetryLookupOptions")
    public static class RetryLookupOptions {
        public static final String FIELD_NAME_RETRY_PREDICATE = "retry-predicate";
        public static final String FIELD_NAME_RETRY_STRATEGY = "retry-strategy";
        public static final String FIELD_NAME_RETRY_FIXED_DELAY = "fixed-delay";
        public static final String FIELD_NAME_RETRY_MAX_ATTEMPTS = "max-attempts";
        @JsonProperty(value="retry-predicate")
        private final String retryPredicate;
        @JsonProperty(value="retry-strategy")
        private final LookupJoinHintOptions.RetryStrategy retryStrategy;
        @JsonProperty(value="fixed-delay")
        private final Long retryFixedDelay;
        @JsonProperty(value="max-attempts")
        private final Integer retryMaxAttempts;

        @JsonCreator
        public RetryLookupOptions(@JsonProperty(value="retry-predicate") String retryPredicate, @JsonProperty(value="retry-strategy") LookupJoinHintOptions.RetryStrategy retryStrategy, @JsonProperty(value="fixed-delay") Long retryFixedDelay, @JsonProperty(value="max-attempts") Integer retryMaxAttempts) {
            this.retryPredicate = (String)Preconditions.checkNotNull((Object)retryPredicate);
            this.retryStrategy = (LookupJoinHintOptions.RetryStrategy)Preconditions.checkNotNull((Object)retryStrategy);
            this.retryFixedDelay = (Long)Preconditions.checkNotNull((Object)retryFixedDelay);
            this.retryMaxAttempts = (Integer)Preconditions.checkNotNull((Object)retryMaxAttempts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RetryLookupOptions that = (RetryLookupOptions)o;
            return Objects.equals(this.retryPredicate, that.retryPredicate) && this.retryStrategy == that.retryStrategy && Objects.equals(this.retryFixedDelay, that.retryFixedDelay) && Objects.equals(this.retryMaxAttempts, that.retryMaxAttempts);
        }

        public int hashCode() {
            return Objects.hash(this.retryPredicate, this.retryStrategy, this.retryFixedDelay, this.retryMaxAttempts);
        }

        public String toString() {
            return this.retryPredicate + ", " + String.valueOf(this.retryStrategy) + ", " + this.retryFixedDelay + "ms, " + this.retryMaxAttempts;
        }

        @Nullable
        public static RetryLookupOptions fromJoinHint(@Nullable RelHint lookupJoinHint) {
            Configuration conf;
            Duration fixedDelay;
            if (null != lookupJoinHint && (fixedDelay = (Duration)(conf = Configuration.fromMap(lookupJoinHint.kvOptions)).get(LookupJoinHintOptions.FIXED_DELAY)) != null) {
                return new RetryLookupOptions((String)conf.get(LookupJoinHintOptions.RETRY_PREDICATE), (LookupJoinHintOptions.RetryStrategy)conf.get(LookupJoinHintOptions.RETRY_STRATEGY), fixedDelay.toMillis(), (Integer)conf.get(LookupJoinHintOptions.MAX_ATTEMPTS));
            }
            return null;
        }

        @JsonIgnore
        public ResultRetryStrategy toRetryStrategy() {
            if (!"lookup_miss".equalsIgnoreCase(this.retryPredicate) || this.retryStrategy != LookupJoinHintOptions.RetryStrategy.FIXED_DELAY) {
                return ResultRetryStrategy.NO_RETRY_STRATEGY;
            }
            return ResultRetryStrategy.fixedDelayRetry((int)this.retryMaxAttempts, (long)this.retryFixedDelay, (Predicate)RetryPredicates.EMPTY_RESULT_PREDICATE);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="ShuffleOptions")
    public static class ShuffleLookupOptions {
        public static final String FIELD_NAME_SHUFFLE = "shuffle";
    }
}

