/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.groupwindow.assigners;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.GroupWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.InternalTimeWindowAssigner;

public class TumblingWindowAssigner
extends GroupWindowAssigner<TimeWindow>
implements InternalTimeWindowAssigner {
    private static final long serialVersionUID = -1671849072115929859L;
    private final long size;
    private final long offset;
    private final boolean isEventTime;

    protected TumblingWindowAssigner(long size, long offset, boolean isEventTime) {
        if (size <= 0L) {
            throw new IllegalArgumentException("TumblingWindowAssigner parameters must satisfy size > 0");
        }
        this.size = size;
        this.offset = offset;
        this.isEventTime = isEventTime;
    }

    @Override
    public Collection<TimeWindow> assignWindows(RowData element, long timestamp) {
        long start = TimeWindow.getWindowStartWithOffset(timestamp, this.offset, this.size);
        return Collections.singletonList(new TimeWindow(start, start + this.size));
    }

    @Override
    public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new TimeWindow.Serializer();
    }

    @Override
    public boolean isEventTime() {
        return this.isEventTime;
    }

    @Override
    public String toString() {
        return "TumblingWindow(" + this.size + ")";
    }

    public static TumblingWindowAssigner of(Duration size) {
        return new TumblingWindowAssigner(size.toMillis(), 0L, true);
    }

    public TumblingWindowAssigner withOffset(Duration offset) {
        return new TumblingWindowAssigner(this.size, offset.toMillis(), this.isEventTime);
    }

    @Override
    public TumblingWindowAssigner withEventTime() {
        return new TumblingWindowAssigner(this.size, this.offset, true);
    }

    @Override
    public TumblingWindowAssigner withProcessingTime() {
        return new TumblingWindowAssigner(this.size, this.offset, false);
    }
}

