/*
 * Copyright 2008 The Closure Compiler Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.javascript.jscomp;

/**
 * Tests for {@link MoveFunctionDeclarations}
 *
 */
public final class MoveFunctionDeclarationsTest extends CompilerTestCase {

  @Override
  protected CompilerPass getProcessor(Compiler compiler) {
    return new MoveFunctionDeclarations(compiler);
  }

  public void testFunctionDeclarations() {
    test("a; function f(){} function g(){}", "var f = function(){}; var g = function(){}; a;");
  }

  public void testFunctionDeclarationsInModule() {
    test(createModules("a; function f(){} function g(){}"),
         new String[] { "var f = function(){}; var g = function(){}; a" });
  }

  public void testFunctionsExpression() {
    testSame("a; f = function(){}");
  }

  public void testNoMoveDeepFunctionDeclarations() {
    setAcceptedLanguage(CompilerOptions.LanguageMode.ECMASCRIPT6);
    testSame("a; if (a) function f(){};");
    testSame("a; if (a) { function f(){} }");
  }
}
