/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.webconsole;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.architecture.Architecture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateUtils {
    public static int getValidInstancesCount(List<Architecture> archs) {
        int i = 0;
        for (Architecture a : archs) {
            if (a.getInstanceDescription().getState() != 2) continue;
            ++i;
        }
        return i;
    }

    public static int getInvalidInstancesCount(List<Architecture> archs) {
        int i = 0;
        for (Architecture a : archs) {
            if (a.getInstanceDescription().getState() != 1) continue;
            ++i;
        }
        return i;
    }

    public static int getValidFactoriesCount(List<Factory> factories) {
        int i = 0;
        for (Factory a : factories) {
            if (a.getState() != 1) continue;
            ++i;
        }
        return i;
    }

    public static int getInvalidFactoriesCount(List<Factory> factories) {
        int i = 0;
        for (Factory a : factories) {
            if (a.getState() != 0) continue;
            ++i;
        }
        return i;
    }

    public static int getValidHandlersCount(List<HandlerFactory> handlers) {
        int i = 0;
        for (HandlerFactory a : handlers) {
            if (a.getState() != 1) continue;
            ++i;
        }
        return i;
    }

    public static int getInvalidHandlersCount(List<HandlerFactory> handlers) {
        int i = 0;
        for (HandlerFactory a : handlers) {
            if (a.getState() != 0) continue;
            ++i;
        }
        return i;
    }

    public static String getInstanceState(int state) {
        switch (state) {
            case 2: {
                return "valid";
            }
            case 1: {
                return "invalid";
            }
            case -1: {
                return "disposed";
            }
            case 0: {
                return "stopped";
            }
        }
        return "unknown";
    }

    public static String getFactoryState(int state) {
        switch (state) {
            case 1: {
                return "valid";
            }
            case 0: {
                return "invalid";
            }
        }
        return "unknown";
    }

    public static List<String> getInstanceList(List<Architecture> archs, String factory) {
        ArrayList<String> list = new ArrayList<String>();
        for (Architecture arch : archs) {
            String n = arch.getInstanceDescription().getComponentDescription().getName();
            if (!factory.equals(n)) continue;
            list.add(arch.getInstanceDescription().getName());
        }
        return list;
    }

    public static String getDependencyState(int state) {
        switch (state) {
            case 1: {
                return "resolved";
            }
            case 0: {
                return "unresolved";
            }
            case -1: {
                return "broken";
            }
        }
        return "unknown (" + state + ")";
    }

    public static String getDependencyBindingPolicy(int policy) {
        switch (policy) {
            case 0: {
                return "dynamic";
            }
            case 2: {
                return "dynamic-priority";
            }
            case 1: {
                return "static";
            }
        }
        return "unknown (" + policy + ")";
    }

    public static String getProvidedServiceState(int state) {
        switch (state) {
            case 1: {
                return "registered";
            }
            case 0: {
                return "unregistered";
            }
        }
        return "unknown (" + state + ")";
    }
}

