/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.truetype.TTFFontLoader;
import org.apache.fop.fonts.type1.Type1FontLoader;

public abstract class FontLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CustomFont loadFont(String fontFileURI, FontResolver resolver) throws IOException {
        String effURI;
        fontFileURI = fontFileURI.trim();
        String name = fontFileURI.toLowerCase();
        boolean type1 = false;
        if (name.endsWith(".pfb")) {
            type1 = true;
            effURI = name.substring(0, fontFileURI.length() - 4) + ".pfm";
        } else {
            effURI = fontFileURI;
        }
        InputStream in = FontLoader.openFontFile(resolver, effURI);
        try {
            FontLoader loader = type1 ? new Type1FontLoader(fontFileURI, in, resolver) : new TTFFontLoader(fontFileURI, in, resolver);
            CustomFont customFont = loader.getFont();
            return customFont;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static InputStream openFontFile(FontResolver resolver, String uri) throws IOException, MalformedURLException {
        InputStream in = null;
        if (resolver != null) {
            Source source = resolver.resolve(uri);
            if (source == null) {
                String err = "Cannot load font: failed to create Source for font file " + uri;
                throw new IOException(err);
            }
            if (source instanceof StreamSource) {
                in = ((StreamSource)source).getInputStream();
            }
            if (in == null && source.getSystemId() != null) {
                in = new URL(source.getSystemId()).openStream();
            }
            if (in == null) {
                String err = "Cannot load font: failed to create InputStream from Source for font file " + uri;
                throw new IOException(err);
            }
        } else {
            in = new URL(uri).openStream();
        }
        return in;
    }

    public abstract CustomFont getFont();
}

