/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.util.Arrays;
import java.util.Properties;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_AccessRow;
import org.apache.derbyTesting.unitTests.store.T_Util;
import org.apache.derbyTesting.unitTests.store.commit_method;
import org.apache.derbyTesting.unitTests.util.BitUtil;

public class T_XA
extends T_Generic {
    private static final String testService = "XaTest";
    byte[] global_id = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    byte[] branch_id = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    AccessFactory store = null;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.access.AccessFactory";
    }

    @Override
    protected void runTests() throws T_Fail {
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            this.store = (AccessFactory)T_XA.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        if (this.store == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        this.REPORT("(unitTestMain) Testing XaTest");
        try {
            this.XATest_1(new commit_method(this.store, true));
            this.XATest_2(new commit_method(this.store, true));
            this.XATest_3(new commit_method(this.store, true));
            this.XATest_4(new commit_method(this.store, true));
            this.XATest_5(new commit_method(this.store, true));
            this.XATest_6(new commit_method(this.store, true));
            this.XATest_1(new commit_method(this.store, false));
            this.XATest_2(new commit_method(this.store, false));
            this.XATest_3(new commit_method(this.store, false));
            this.XATest_4(new commit_method(this.store, false));
            this.XATest_5(new commit_method(this.store, false));
            this.XATest_6(new commit_method(this.store, false));
        }
        catch (StandardException standardException) {
            String string = standardException.getMessage();
            if (string == null) {
                string = ((Object)((Object)standardException)).getClass().getName();
            }
            this.REPORT(string);
            standardException.printStackTrace();
            throw T_Fail.exceptionFail(standardException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    void XATest_1(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_1) starting");
        ContextManager contextManager = T_XA.getContextService().getCurrentContextManager();
        XATransactionController xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xATransactionController);
        xATransactionController.destroy();
        xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        long l = xATransactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xATransactionController);
        xATransactionController.destroy();
        xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        ScanController scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController.next();
        scanController.close();
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xATransactionController);
        xATransactionController.destroy();
        this.REPORT("(XATest_1) finishing");
    }

    void XATest_2(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_2) starting");
        ContextManager contextManager = T_XA.getContextService().getCurrentContextManager();
        XATransactionController xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        if (!xATransactionController.isGlobal()) {
            throw T_Fail.testFailMsg("should be a global transaction.");
        }
        if (xATransactionController.xa_prepare() != 1) {
            throw T_Fail.testFailMsg("prepare of idle xact did not return XA_RDONLY.");
        }
        try {
            commit_method2.commit(false, 42, null, null, xATransactionController);
            throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact cant be 2P xa_committed.");
        }
        catch (StandardException standardException) {
            if (((XAResourceManager)this.store.getXAResourceManager()).find((Xid)new XAXactId(42, this.global_id, this.branch_id)) != null) {
                throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact should not be findable.");
            }
            xATransactionController.destroy();
            xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
            T_AccessRow t_AccessRow = new T_AccessRow(1);
            long l = xATransactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
            if (xATransactionController.xa_prepare() != 2) {
                throw T_Fail.testFailMsg("prepare of update xact did not return XA_OK.");
            }
            commit_method2.commit(false, 42, this.global_id, this.branch_id, xATransactionController);
            xATransactionController.destroy();
            xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
            ScanController scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
            scanController.next();
            scanController.close();
            if (xATransactionController.xa_prepare() != 1) {
                throw T_Fail.testFailMsg("prepare of idle xact did not return XA_RDONLY.");
            }
            try {
                commit_method2.commit(false, 42, null, null, xATransactionController);
                throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact cant be 2P xa_committed.");
            }
            catch (StandardException standardException2) {
                if (((XAResourceManager)this.store.getXAResourceManager()).find((Xid)new XAXactId(42, this.global_id, this.branch_id)) != null) {
                    throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact should not be findable.");
                }
                xATransactionController.destroy();
                this.REPORT("(XATest_2) finishing");
                return;
            }
        }
    }

    void XATest_3(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_3) starting");
        ContextManager contextManager = T_XA.getContextService().getCurrentContextManager();
        XATransactionController xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        commit_method2.rollback(42, this.global_id, this.branch_id, xATransactionController);
        xATransactionController.destroy();
        xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        long l = xATransactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        commit_method2.rollback(42, this.global_id, this.branch_id, xATransactionController);
        xATransactionController.destroy();
        xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        t_AccessRow = new T_AccessRow(1);
        l = xATransactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xATransactionController);
        xATransactionController.destroy();
        xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        ScanController scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController.next();
        scanController.close();
        commit_method2.rollback(42, this.global_id, this.branch_id, xATransactionController);
        xATransactionController.destroy();
        this.REPORT("(XATest_3) finishing");
    }

    void XATest_4(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_4) starting");
        ContextManager contextManager = T_XA.getContextService().getCurrentContextManager();
        XATransactionController xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        if (xATransactionController.xa_prepare() != 1) {
            throw T_Fail.testFailMsg("prepare of idle xact did not return XA_RDONLY.");
        }
        commit_method2.commit(true, 42, null, null, xATransactionController);
        if (((XAResourceManager)this.store.getXAResourceManager()).find((Xid)new XAXactId(42, this.global_id, this.branch_id)) != null) {
            throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact should not be findable.");
        }
        xATransactionController.destroy();
        xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        long l = xATransactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        ScanController scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController.next();
        scanController.close();
        if (xATransactionController.xa_prepare() != 2) {
            throw T_Fail.testFailMsg("prepare of update xact did not return XA_OK.");
        }
        try {
            scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
            scanController.next();
            scanController.close();
            throw T_Fail.testFailMsg("Should not be able to do anything on xact after prepare.");
        }
        catch (StandardException standardException) {
            commit_method2.rollback(42, this.global_id, this.branch_id, xATransactionController);
            commit_method2.commit(true, 42, null, null, xATransactionController);
            if (((XAResourceManager)this.store.getXAResourceManager()).find((Xid)new XAXactId(42, this.global_id, this.branch_id)) != null) {
                throw T_Fail.testFailMsg("A xa_rollbacked xact should not be findable.");
            }
            xATransactionController.destroy();
            xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
            try {
                scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
                scanController.next();
                scanController.close();
                throw T_Fail.testFailMsg("Should not be able to open conglom, the create was aborted.");
            }
            catch (StandardException standardException2) {
                xATransactionController.destroy();
                xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
                t_AccessRow = new T_AccessRow(1);
                l = xATransactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
                commit_method2.commit(true, 42, this.global_id, this.branch_id, xATransactionController);
                xATransactionController.destroy();
                xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
                scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
                scanController.next();
                scanController.close();
                if (xATransactionController.xa_prepare() != 1) {
                    throw T_Fail.testFailMsg("prepare of idle xact did not return XA_RDONLY.");
                }
                commit_method2.commit(true, 42, null, null, xATransactionController);
                if (((XAResourceManager)this.store.getXAResourceManager()).find((Xid)new XAXactId(42, this.global_id, this.branch_id)) != null) {
                    throw T_Fail.testFailMsg("A XA_RDONLY prepare-committed xact should not be findable.");
                }
                xATransactionController.destroy();
                this.REPORT("(XATest_5) finishing");
                return;
            }
        }
    }

    void XATest_5(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_5) starting");
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0).length != 0) {
            throw T_Fail.testFailMsg("NOFLAGS should always return 0.");
        }
        ContextManager contextManager = T_XA.getContextService().getCurrentContextManager();
        XATransactionController xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xATransactionController);
        xATransactionController.destroy();
        xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        long l = xATransactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xATransactionController);
        xATransactionController.destroy();
        xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        ScanController scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController.next();
        scanController.close();
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        commit_method2.commit(true, 42, this.global_id, this.branch_id, xATransactionController);
        xATransactionController.destroy();
        xATransactionController = (XATransactionController)this.store.startXATransaction(contextManager, 42, this.global_id, this.branch_id);
        t_AccessRow = new T_AccessRow(1);
        l = xATransactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        if (xATransactionController.xa_prepare() != 2) {
            throw T_Fail.testFailMsg("prepare of update xact did not return XA_OK.");
        }
        try {
            scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
            scanController.next();
            scanController.close();
            throw T_Fail.testFailMsg("Should not be able to do anything on xact after prepare.");
        }
        catch (StandardException standardException) {
            Xid[] xidArray = ((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000);
            if (xidArray.length != 1) {
                throw T_Fail.testFailMsg("recover incorrectly returned wrong prepared xacts.");
            }
            if (xidArray[0].getFormatId() != 42) {
                throw T_Fail.testFailMsg("bad format id = " + xidArray[0].getFormatId());
            }
            byte[] byArray = xidArray[0].getGlobalTransactionId();
            if (!Arrays.equals(byArray, this.global_id)) {
                throw T_Fail.testFailMsg("bad global id = " + BitUtil.hexDump(byArray));
            }
            byte[] byArray2 = xidArray[0].getBranchQualifier();
            if (!Arrays.equals(byArray2, this.branch_id)) {
                throw T_Fail.testFailMsg("bad branch id = " + BitUtil.hexDump(byArray2));
            }
            if (((XAResourceManager)this.store.getXAResourceManager()).recover(0).length != 0) {
                throw T_Fail.testFailMsg("NOFLAGS should always return 0.");
            }
            commit_method2.commit(false, 42, this.global_id, this.branch_id, xATransactionController);
            if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
                throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
            }
            xATransactionController.destroy();
            if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
                throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
            }
            this.REPORT("(XATest_5) finishing");
            return;
        }
    }

    void XATest_6(commit_method commit_method2) throws StandardException, T_Fail {
        this.REPORT("(XATest_5) starting");
        ContextManager contextManager = T_XA.getContextService().getCurrentContextManager();
        TransactionController transactionController = this.store.getTransaction(contextManager);
        T_AccessRow t_AccessRow = new T_AccessRow(1);
        long l = transactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        transactionController.commit();
        XATransactionController xATransactionController = (XATransactionController)transactionController.createXATransactionFromLocalTransaction(42, this.global_id, this.branch_id);
        if (!xATransactionController.isGlobal()) {
            throw T_Fail.testFailMsg("should be a global transaction.");
        }
        ScanController scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanController.next();
        scanController.close();
        t_AccessRow = new T_AccessRow(1);
        l = xATransactionController.createConglomerate("heap", t_AccessRow.getRowArray(), null, null, null, 0);
        if (((XAResourceManager)this.store.getXAResourceManager()).recover(0x1000000).length != 0) {
            throw T_Fail.testFailMsg("recover incorrectly returned prepared xacts.");
        }
        if (xATransactionController.xa_prepare() != 2) {
            throw T_Fail.testFailMsg("prepare of update xact did not return XA_OK.");
        }
        try {
            scanController = xATransactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
            scanController.next();
            scanController.close();
            throw T_Fail.testFailMsg("Should not be able to do anything on xact after prepare.");
        }
        catch (StandardException standardException) {
            commit_method2.commit(false, 42, this.global_id, this.branch_id, xATransactionController);
            xATransactionController.destroy();
            this.REPORT("(XATest_6) finishing");
            return;
        }
    }

    static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
    }
}

