/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.utilXid;

public class XATestUtil {
    public static Xid getXid(int n, int n2, int n3) {
        int n4;
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[64];
        for (n4 = 0; n4 < byArray.length; ++n4) {
            byArray[n4] = (byte)(n2 + n4);
        }
        for (n4 = 0; n4 < byArray2.length; ++n4) {
            byArray2[n4] = (byte)(n3 + n4);
        }
        return XATestUtil.getXid(n, byArray, byArray2);
    }

    public static Xid getXid(int n, byte[] byArray, byte[] byArray2) {
        return new utilXid(n, byArray, byArray2);
    }

    public static void dumpXAException(String string, XAException xAException) {
        System.out.println(string + " : XAException - " + xAException.getMessage() + " errorCode " + XATestUtil.errorCode(xAException));
        xAException.printStackTrace(System.out);
    }

    public static void createXATransactionView(Statement statement) throws SQLException {
        statement.execute("create view XATESTUTIL.global_xactTable as select  cast(global_xid as char(2)) as gxid, status,  CAST (case when first_instant is NULL then 'NULL' else 'false' end AS VARCHAR(8)) as readOnly,  cast (username as char(10)) as username, type  from syscs_diag.transaction_table");
    }

    public static void checkXATransactionView(Connection connection, String[][] stringArray) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from XATESTUTIL.global_xactTable where gxid is not null order by gxid");
        if (stringArray == null) {
            JDBC.assertEmpty(resultSet);
        } else {
            JDBC.assertUnorderedResultSet(resultSet, stringArray);
        }
        resultSet.close();
    }

    public static String errorCode(XAException xAException) {
        return switch (xAException.errorCode) {
            case 7 -> "XA_HEURCOM ";
            case 8 -> "XA_HEURHAZ";
            case 5 -> "XA_HEURMIX";
            case 6 -> "XA_HEURRB ";
            case 9 -> "XA_NOMIGRATE ";
            case 101 -> "XA_RBCOMMFAIL ";
            case 102 -> "XA_RBDEADLOCK ";
            case 103 -> "XA_RBINTEGRITY ";
            case 104 -> "XA_RBOTHER ";
            case 105 -> "XA_RBPROTO ";
            case 100 -> "XA_RBROLLBACK ";
            case 106 -> "XA_RBTIMEOUT ";
            case 107 -> "XA_RBTRANSIENT ";
            case 3 -> "XA_RDONLY ";
            case 4 -> "XA_RETRY ";
            case -2 -> "XAER_ASYNC ";
            case -8 -> "XAER_DUPID ";
            case -5 -> "XAER_INVAL ";
            case -4 -> "XAER_NOTA ";
            case -9 -> "XAER_OUTSIDE ";
            case -6 -> "XAER_PROTO ";
            case -3 -> "XAER_RMERR ";
            case -7 -> "XAER_RMFAIL ";
            default -> Integer.toString(xAException.errorCode);
        };
    }
}

