/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.Properties;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCClientSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LoginTimeoutTest
extends BaseJDBCTestCase {
    private static final String[][] SYSTEM_PROPERTIES = new String[][]{{"derby.connection.requireAuthentication", "true"}, {"derby.authentication.provider", LoginTimeoutTest.class.getName() + "$SluggishAuthenticator"}};
    private static final boolean SUCCEED = true;
    private static final boolean FAIL = false;
    private static final int LONG_TIMEOUT = 10;
    private static final String RUTH = "RUTH";
    private static final String RUTH_PASSWORD = "RUTHPASSWORD";
    private static final String LOGIN_TIMEOUT = "XBDA0";
    private static final String LOGIN_FAILED = "08004";

    public LoginTimeoutTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        Object object = new BaseTestSuite(LoginTimeoutTest.class, "embedded LoginTimeoutTest");
        object = TestConfiguration.singleUseDatabaseDecorator((Test)object);
        object = new SystemPropertyTestSetup((Test)object, LoginTimeoutTest.systemProperties());
        baseTestSuite.addTest((Test)object);
        if (Derby.hasServer() && Derby.hasClient()) {
            Object object2 = new BaseTestSuite(LoginTimeoutTest.class, "client/server LoginTimeoutTest");
            object2 = TestConfiguration.singleUseDatabaseDecorator((Test)object2);
            object2 = new JDBCClientSetup((Test)object2, JDBCClient.DERBYNETCLIENT);
            object2 = new NetworkServerTestSetup((Test)object2, LoginTimeoutTest.systemPropertiesArray(), new String[0], true);
            baseTestSuite.addTest((Test)object2);
        }
        return baseTestSuite;
    }

    private static Properties systemProperties() {
        Properties properties = new Properties();
        for (int i = 0; i < SYSTEM_PROPERTIES.length; ++i) {
            String[] stringArray = SYSTEM_PROPERTIES[i];
            properties.put(stringArray[0], stringArray[1]);
        }
        return properties;
    }

    private static String[] systemPropertiesArray() {
        String[] stringArray = new String[SYSTEM_PROPERTIES.length];
        for (int i = 0; i < SYSTEM_PROPERTIES.length; ++i) {
            String[] stringArray2 = SYSTEM_PROPERTIES[i];
            stringArray[i] = stringArray2[0] + "=" + stringArray2[1];
        }
        return stringArray;
    }

    public void testBasic() throws Exception {
        SluggishAuthenticator.debugPrinting = TestConfiguration.getCurrent().isVerbose();
        Connection connection = this.openDefaultConnection(RUTH, RUTH_PASSWORD);
        connection.close();
        this.vetConnector(new DriverManagerConnector(this), true);
        this.vetConnector(new DataSourceConnector(JDBCDataSource.getDataSource()), true);
        this.vetConnector(new DataSourceConnector(J2EEDataSource.getConnectionPoolDataSource()), true);
        this.vetConnector(new DataSourceConnector(J2EEDataSource.getXADataSource()), true);
        if (LoginTimeoutTest.usingEmbedded()) {
            this.vetExceptionPassthrough();
        }
        if (LoginTimeoutTest.usingDerbyNetClient()) {
            this.vetServerTimeouts();
        }
    }

    private void vetConnector(Connector connector, boolean bl) throws Exception {
        try {
            if (LoginTimeoutTest.usingEmbedded()) {
                SluggishAuthenticator.secondsToSleep = 4L;
            }
            this.tryTimeout(connector, 1, false);
            if (LoginTimeoutTest.usingEmbedded()) {
                SluggishAuthenticator.secondsToSleep = 2L;
            }
            this.tryTimeout(connector, 10, bl);
            this.tryTimeout(connector, 0, bl);
        }
        finally {
            connector.setLoginTimeout(0);
            SluggishAuthenticator.secondsToSleep = 2L;
        }
    }

    private void tryTimeout(Connector connector, int n, boolean bl) throws Exception {
        LoginTimeoutTest.println("Setting timeout " + n + " on " + String.valueOf(connector));
        connector.setLoginTimeout(n);
        this.tryTimeout(connector, bl);
    }

    private void tryTimeout(Connector connector, boolean bl) throws Exception {
        long l = System.currentTimeMillis();
        try {
            Connection connection = connector.getConnection(RUTH, RUTH_PASSWORD);
            LoginTimeoutTest.println("    Got a " + connection.getClass().getName());
            connection.close();
            if (!bl) {
                long l2 = System.currentTimeMillis() - l;
                String string = "Should not have been able to connect! \n         connector: " + String.valueOf(connector) + "        Experiment took " + l2 + " milliseconds. \n         seconds sleep time was: " + SluggishAuthenticator.secondsToSleep;
                LoginTimeoutTest.fail((String)string);
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                LoginTimeoutTest.fail("Should have been able to connect!", sQLException);
            }
            LoginTimeoutTest.assertTrue((String)("Didn't expect to see a " + sQLException.getClass().getName()), (boolean)(sQLException instanceof SQLTimeoutException));
            LoginTimeoutTest.assertSQLState(LOGIN_TIMEOUT, sQLException);
        }
        long l3 = System.currentTimeMillis() - l;
        LoginTimeoutTest.println("        Experiment took " + l3 + " milliseconds.");
    }

    private void vetExceptionPassthrough() throws Exception {
        try {
            LoginTimeoutTest.println("Verifying that exceptions are not swallowed by the embedded login timer.");
            DriverManager.setLoginTimeout(10);
            SluggishAuthenticator.returnValue = false;
            try {
                Connection connection = this.openDefaultConnection(RUTH, RUTH_PASSWORD);
                connection.close();
                LoginTimeoutTest.fail((String)"Didn't expect to get a connection!");
            }
            catch (SQLException sQLException) {
                LoginTimeoutTest.assertSQLState(LOGIN_FAILED, sQLException);
            }
        }
        finally {
            DriverManager.setLoginTimeout(0);
            SluggishAuthenticator.returnValue = true;
        }
    }

    private void vetServerTimeouts() throws Exception {
        LoginTimeoutTest.println("Verifying behavior when timeouts are also set on the server.");
        Connection connection = this.openDefaultConnection(RUTH, RUTH_PASSWORD);
        String string = "create procedure setLoginTimeout( timeout int ) language java parameter style java no sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".setLoginTimeout'";
        LoginTimeoutTest.println(string);
        connection.prepareStatement(string).execute();
        string = "create procedure setAuthenticatorSleep( seconds int ) language java parameter style java no sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".setAuthenticatorSleep'";
        connection.prepareStatement(string).execute();
        LoginTimeoutTest.println(string);
        DriverManagerConnector driverManagerConnector = new DriverManagerConnector(this);
        this.vetServerTimeout(connection, driverManagerConnector, 1, false);
        this.vetServerTimeout(connection, driverManagerConnector, 10, true);
        this.vetServerTimeout(connection, driverManagerConnector, 0, true);
        this.setServerTimeout(connection, 0);
        connection.prepareStatement("drop procedure setLoginTimeout").execute();
        connection.close();
    }

    private void vetServerTimeout(Connection connection, Connector connector, int n, boolean bl) throws Exception {
        this.setServerTimeout(connection, n);
        if (!bl) {
            this.setServerAuthenticatorSleep(connection, 4);
        } else {
            this.setServerAuthenticatorSleep(connection, 2);
        }
        this.vetConnector(connector, bl);
    }

    private void setServerTimeout(Connection connection, int n) throws Exception {
        CallableStatement callableStatement = connection.prepareCall("call setLoginTimeout( ? )");
        callableStatement.setInt(1, n);
        callableStatement.execute();
        callableStatement.close();
    }

    private void setServerAuthenticatorSleep(Connection connection, int n) throws Exception {
        CallableStatement callableStatement = connection.prepareCall("call setAuthenticatorSleep( ? )");
        callableStatement.setInt(1, n);
        callableStatement.execute();
        callableStatement.close();
    }

    public static void setLoginTimeout(int n) throws Exception {
        DriverManager.setLoginTimeout(n);
    }

    public static void setAuthenticatorSleep(int n) throws Exception {
        SluggishAuthenticator.secondsToSleep = n;
    }

    public static final class SluggishAuthenticator
    implements UserAuthenticator {
        public static boolean debugPrinting = false;
        private static final long MILLIS_PER_SECOND = 1000L;
        public static long secondsToSleep = 2L;
        public static boolean returnValue = true;

        public boolean authenticateUser(String string, String string2, String string3, Properties properties) throws SQLException {
            try {
                long l = secondsToSleep * 1000L;
                SluggishAuthenticator.printText("SluggishAuthenticator going to sleep for " + l + " milliseconds.");
                Thread.sleep(secondsToSleep * 1000L);
                SluggishAuthenticator.printText("...SluggishAuthenticator waking up after " + l + " milliseconds.");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage(), exception);
            }
            return returnValue;
        }

        private static void printText(String string) {
            if (debugPrinting) {
                BaseTestCase.println(string);
            }
        }
    }

    public static final class DriverManagerConnector
    implements Connector {
        private BaseJDBCTestCase _test;

        public DriverManagerConnector(BaseJDBCTestCase baseJDBCTestCase) {
            this._test = baseJDBCTestCase;
        }

        @Override
        public Connection getConnection(String string, String string2) throws SQLException {
            return this._test.openDefaultConnection(string, string2);
        }

        @Override
        public void setLoginTimeout(int n) {
            DriverManager.setLoginTimeout(n);
        }

        public String toString() {
            return "DriverManagerConnector";
        }
    }

    public static interface Connector {
        public Connection getConnection(String var1, String var2) throws SQLException;

        public void setLoginTimeout(int var1) throws SQLException;
    }

    public static final class DataSourceConnector
    implements Connector {
        private CommonDataSource _dataSource;

        public DataSourceConnector(CommonDataSource commonDataSource) {
            this._dataSource = commonDataSource;
        }

        @Override
        public Connection getConnection(String string, String string2) throws SQLException {
            if (this._dataSource instanceof DataSource) {
                return ((DataSource)this._dataSource).getConnection(string, string2);
            }
            if (this._dataSource instanceof ConnectionPoolDataSource) {
                return ((ConnectionPoolDataSource)this._dataSource).getPooledConnection(string, string2).getConnection();
            }
            if (this._dataSource instanceof XADataSource) {
                return ((XADataSource)this._dataSource).getXAConnection(string, string2).getConnection();
            }
            throw new SQLException("Unknown data source type: " + this._dataSource.getClass().getName());
        }

        @Override
        public void setLoginTimeout(int n) throws SQLException {
            this._dataSource.setLoginTimeout(n);
        }

        public String toString() {
            return "DataSourceConnector( " + this._dataSource.getClass().getName() + " )";
        }
    }
}

