/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.VisitableFilter;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementColumnPermission;
import org.apache.derby.iapi.sql.dictionary.StatementGenericPermission;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRolePermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.sql.dictionary.StatementSchemaPermission;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class CompilerContextImpl
extends ContextImpl
implements CompilerContext {
    private static final int SCOPE_CELL = 0;
    private final Parser parser;
    private final LanguageConnectionContext lcc;
    private final LanguageConnectionFactory lcf;
    private TypeCompilerFactory typeCompilerFactory;
    private Dependent currentDependent;
    private DependencyManager dm;
    private boolean firstOnStack;
    private boolean inUse;
    private int reliability = 1024;
    private int nextColumnNumber = 1;
    private int nextTableNumber;
    private int nextSubqueryNumber;
    private int nextResultSetNumber;
    private int scanIsolationLevel;
    private int nextEquivalenceClass = -1;
    private long nextClassName;
    private List<Object> savedObjects;
    private String classPrefix;
    private SchemaDescriptor compilationSchema;
    private ArrayList<VisitableFilter> privilegeCheckFilters;
    private HashMap<String, int[]> namedScopes;
    private boolean skippingTypePrivileges;
    private ArrayList<SchemaDescriptor> defaultSchemaStack;
    private ProviderList currentAPL;
    private boolean returnParameterFlag;
    private final HashMap<Long, StoreCostController> storeCostControllers = new HashMap();
    private SortCostController sortCostController;
    private List<ParameterNode> parameterList;
    private DataTypeDescriptor[] parameterDescriptors;
    private Object cursorInfo;
    private SQLWarning warnings;
    private final ArrayList<Integer> privTypeStack = new ArrayList();
    private int currPrivType = -1;
    private HashMap<StatementTablePermission, StatementColumnPermission> requiredColumnPrivileges;
    private HashMap<StatementTablePermission, StatementTablePermission> requiredTablePrivileges;
    private HashMap<StatementSchemaPermission, StatementSchemaPermission> requiredSchemaPrivileges;
    private HashMap<UUID, Integer> requiredRoutinePrivileges;
    private HashMap<UUID, String> requiredUsagePrivileges;
    private HashMap<StatementRolePermission, StatementRolePermission> requiredRolePrivileges;
    private HashMap<UUID, SequenceDescriptor> referencedSequences;

    @Override
    public void cleanupOnError(Throwable error) throws StandardException {
        this.setInUse(false);
        this.resetContext();
        if (error instanceof StandardException) {
            StandardException se = (StandardException)error;
            int severity = se.getSeverity();
            if (severity < 50000) {
                if (this.currentDependent != null) {
                    this.currentDependent.makeInvalid(0, this.lcc);
                }
                this.closeStoreCostControllers();
                this.closeSortCostControllers();
            }
            if (severity >= 40000) {
                this.popMe();
            }
        }
    }

    @Override
    public void resetContext() {
        this.nextColumnNumber = 1;
        this.nextTableNumber = 0;
        this.nextSubqueryNumber = 0;
        this.resetNextResultSetNumber();
        this.nextEquivalenceClass = -1;
        this.compilationSchema = null;
        this.parameterList = null;
        this.parameterDescriptors = null;
        this.scanIsolationLevel = 0;
        this.warnings = null;
        this.savedObjects = null;
        this.reliability = 1024;
        this.returnParameterFlag = false;
        this.initRequiredPriv();
        this.defaultSchemaStack = null;
        this.referencedSequences = null;
        this.privilegeCheckFilters = null;
        this.namedScopes = null;
        this.skippingTypePrivileges = false;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public OptimizerFactory getOptimizerFactory() {
        return this.lcf.getOptimizerFactory();
    }

    @Override
    public int getNextColumnNumber() {
        return this.nextColumnNumber++;
    }

    @Override
    public int getNextTableNumber() {
        return this.nextTableNumber++;
    }

    @Override
    public int getNumTables() {
        return this.nextTableNumber;
    }

    @Override
    public int getNextSubqueryNumber() {
        return this.nextSubqueryNumber++;
    }

    @Override
    public int getNumSubquerys() {
        return this.nextSubqueryNumber;
    }

    @Override
    public int getNextResultSetNumber() {
        return this.nextResultSetNumber++;
    }

    @Override
    public void resetNextResultSetNumber() {
        this.nextResultSetNumber = 0;
    }

    @Override
    public int getNumResultSets() {
        return this.nextResultSetNumber;
    }

    @Override
    public String getUniqueClassName() {
        SanityManager.ASSERT(this.nextClassName <= Long.MAX_VALUE);
        return this.classPrefix.concat(Long.toHexString(this.nextClassName++));
    }

    @Override
    public int getNextEquivalenceClass() {
        return ++this.nextEquivalenceClass;
    }

    @Override
    public ClassFactory getClassFactory() {
        return this.lcf.getClassFactory();
    }

    @Override
    public JavaFactory getJavaFactory() {
        return this.lcf.getJavaFactory();
    }

    @Override
    public void setCurrentDependent(Dependent d) {
        this.currentDependent = d;
    }

    @Override
    public ProviderList getCurrentAuxiliaryProviderList() {
        return this.currentAPL;
    }

    @Override
    public void setCurrentAuxiliaryProviderList(ProviderList apl) {
        this.currentAPL = apl;
    }

    @Override
    public void createDependency(Provider p) throws StandardException {
        SanityManager.ASSERT(this.currentDependent != null, "no current dependent for compilation");
        if (this.dm == null) {
            this.dm = this.lcc.getDataDictionary().getDependencyManager();
        }
        this.dm.addDependency(this.currentDependent, p, this.getContextManager());
        this.addProviderToAuxiliaryList(p);
    }

    @Override
    public void createDependency(Dependent d, Provider p) throws StandardException {
        if (this.dm == null) {
            this.dm = this.lcc.getDataDictionary().getDependencyManager();
        }
        this.dm.addDependency(d, p, this.getContextManager());
        this.addProviderToAuxiliaryList(p);
    }

    private void addProviderToAuxiliaryList(Provider p) {
        if (this.currentAPL != null) {
            this.currentAPL.addProvider(p);
        }
    }

    @Override
    public int addSavedObject(Object obj) {
        if (this.savedObjects == null) {
            this.savedObjects = new ArrayList<Object>();
        }
        this.savedObjects.add(obj);
        return this.savedObjects.size() - 1;
    }

    @Override
    public Object[] getSavedObjects() {
        if (this.savedObjects == null) {
            return null;
        }
        Object[] retVal = this.savedObjects.toArray();
        this.savedObjects = null;
        return retVal;
    }

    @Override
    public void setSavedObjects(List<Object> objs) {
        Iterator<Object> it = objs.iterator();
        while (it.hasNext()) {
            this.addSavedObject(it.next());
        }
    }

    @Override
    public void setCursorInfo(Object cursorInfo) {
        this.cursorInfo = cursorInfo;
    }

    @Override
    public Object getCursorInfo() {
        return this.cursorInfo;
    }

    @Override
    public void firstOnStack() {
        this.firstOnStack = true;
    }

    @Override
    public boolean isFirstOnStack() {
        return this.firstOnStack;
    }

    @Override
    public void setInUse(boolean inUse) {
        this.inUse = inUse;
        if (!inUse) {
            this.closeStoreCostControllers();
            this.closeSortCostControllers();
        }
    }

    @Override
    public boolean getInUse() {
        return this.inUse;
    }

    @Override
    public void setReliability(int reliability) {
        this.reliability = reliability;
    }

    @Override
    public int getReliability() {
        return this.reliability;
    }

    @Override
    public StoreCostController getStoreCostController(long conglomerateNumber) throws StandardException {
        Long conglomNum = conglomerateNumber;
        StoreCostController retval = this.storeCostControllers.get(conglomNum);
        if (retval == null) {
            retval = this.lcc.getTransactionCompile().openStoreCost(conglomerateNumber);
            this.storeCostControllers.put(conglomNum, retval);
        }
        return retval;
    }

    private void closeStoreCostControllers() {
        for (StoreCostController scc : this.storeCostControllers.values()) {
            try {
                scc.close();
            }
            catch (StandardException standardException) {}
        }
        this.storeCostControllers.clear();
    }

    @Override
    public SortCostController getSortCostController() throws StandardException {
        if (this.sortCostController == null) {
            this.sortCostController = this.lcc.getTransactionCompile().openSortCostController();
        }
        return this.sortCostController;
    }

    private void closeSortCostControllers() {
        if (this.sortCostController != null) {
            this.sortCostController.close();
            this.sortCostController = null;
        }
    }

    @Override
    public SchemaDescriptor getCompilationSchema() {
        return this.compilationSchema;
    }

    @Override
    public SchemaDescriptor setCompilationSchema(SchemaDescriptor newDefault) {
        SchemaDescriptor tmpSchema = this.compilationSchema;
        this.compilationSchema = newDefault;
        return tmpSchema;
    }

    @Override
    public void pushCompilationSchema(SchemaDescriptor sd) {
        if (this.defaultSchemaStack == null) {
            this.defaultSchemaStack = new ArrayList(2);
        }
        this.defaultSchemaStack.add(this.defaultSchemaStack.size(), this.getCompilationSchema());
        this.setCompilationSchema(sd);
    }

    @Override
    public void popCompilationSchema() {
        SchemaDescriptor sd = this.defaultSchemaStack.remove(this.defaultSchemaStack.size() - 1);
        this.setCompilationSchema(sd);
    }

    @Override
    public void setParameterList(List<ParameterNode> parameterList) {
        int numberOfParameters;
        this.parameterList = parameterList;
        int n = numberOfParameters = parameterList == null ? 0 : parameterList.size();
        if (numberOfParameters > 0) {
            this.parameterDescriptors = new DataTypeDescriptor[numberOfParameters];
        }
    }

    @Override
    public List<ParameterNode> getParameterList() {
        return this.parameterList;
    }

    @Override
    public void setReturnParameterFlag() {
        this.returnParameterFlag = true;
    }

    @Override
    public boolean getReturnParameterFlag() {
        return this.returnParameterFlag;
    }

    DataTypeDescriptor[] getParameterTypes() {
        return this.parameterDescriptors;
    }

    @Override
    public void setScanIsolationLevel(int isolationLevel) {
        this.scanIsolationLevel = isolationLevel;
    }

    @Override
    public int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    @Override
    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.typeCompilerFactory;
    }

    @Override
    public void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public CompilerContextImpl(ContextManager cm, LanguageConnectionContext lcc, TypeCompilerFactory typeCompilerFactory) {
        super(cm, "CompilerContext");
        this.lcc = lcc;
        this.lcf = lcc.getLanguageConnectionFactory();
        this.parser = this.lcf.newParser(this);
        this.typeCompilerFactory = typeCompilerFactory;
        this.classPrefix = "ac" + this.lcf.getUUIDFactory().createUUID().toString().replace('-', 'x');
        this.initRequiredPriv();
    }

    private void initRequiredPriv() {
        this.currPrivType = -1;
        this.privTypeStack.clear();
        this.requiredColumnPrivileges = null;
        this.requiredTablePrivileges = null;
        this.requiredSchemaPrivileges = null;
        this.requiredRoutinePrivileges = null;
        this.requiredUsagePrivileges = null;
        this.requiredRolePrivileges = null;
        if (this.lcc.usesSqlAuthorization()) {
            this.requiredColumnPrivileges = new HashMap();
            this.requiredTablePrivileges = new HashMap();
            this.requiredSchemaPrivileges = new HashMap();
            this.requiredRoutinePrivileges = new HashMap();
            this.requiredUsagePrivileges = new HashMap();
            this.requiredRolePrivileges = new HashMap();
        }
    }

    @Override
    public void pushCurrentPrivType(int privType) {
        this.privTypeStack.add(this.currPrivType);
        this.currPrivType = privType;
    }

    @Override
    public void popCurrentPrivType() {
        Integer top = this.privTypeStack.remove(this.privTypeStack.size() - 1);
        this.currPrivType = top;
    }

    @Override
    public void addRequiredColumnPriv(ColumnDescriptor column) {
        StatementColumnPermission tableColumnPrivileges;
        StatementTablePermission key;
        if (this.requiredColumnPrivileges == null || this.currPrivType == -1 || this.currPrivType == 4 || this.currPrivType == 3 || this.currPrivType == 5 || this.currPrivType == 6 || column == null) {
            return;
        }
        TableDescriptor td = column.getTableDescriptor();
        if (td == null) {
            return;
        }
        if (td.getTableType() == 3) {
            return;
        }
        UUID tableUUID = td.getUUID();
        if (this.currPrivType == 8 && (this.requiredColumnPrivileges.containsKey(key = new StatementTablePermission(tableUUID, 0)) || this.requiredTablePrivileges.containsKey(key))) {
            return;
        }
        if (this.currPrivType == 0) {
            key = new StatementTablePermission(tableUUID, 8);
            this.requiredColumnPrivileges.remove(key);
        }
        if ((tableColumnPrivileges = this.requiredColumnPrivileges.get(key = new StatementTablePermission(tableUUID, this.currPrivType))) == null) {
            tableColumnPrivileges = new StatementColumnPermission(tableUUID, this.currPrivType, new FormatableBitSet(td.getNumberOfColumns()));
            this.requiredColumnPrivileges.put(key, tableColumnPrivileges);
        }
        tableColumnPrivileges.getColumns().set(column.getPosition() - 1);
    }

    @Override
    public void addRequiredTablePriv(TableDescriptor table) {
        StatementTablePermission key;
        if (this.requiredTablePrivileges == null || table == null) {
            return;
        }
        if (table.getTableType() == 3) {
            return;
        }
        if (this.currPrivType == 0) {
            key = new StatementTablePermission(table.getUUID(), 8);
            this.requiredColumnPrivileges.remove(key);
        }
        key = new StatementTablePermission(table.getUUID(), this.currPrivType);
        this.requiredTablePrivileges.put(key, key);
    }

    @Override
    public void addRequiredRoutinePriv(AliasDescriptor routine) {
        if (this.requiredRoutinePrivileges == null || routine == null) {
            return;
        }
        if (routine.getSchemaUUID().toString().equals("c013800d-00fb-2642-07ec-000000134f30")) {
            return;
        }
        if (this.requiredRoutinePrivileges.get(routine.getUUID()) == null) {
            this.requiredRoutinePrivileges.put(routine.getUUID(), 1);
        }
    }

    @Override
    public void addRequiredUsagePriv(PrivilegedSQLObject usableObject) {
        if (this.requiredUsagePrivileges == null || usableObject == null) {
            return;
        }
        UUID objectID = usableObject.getUUID();
        String objectType = usableObject.getObjectTypeName();
        if (this.requiredUsagePrivileges.get(objectID) == null) {
            this.requiredUsagePrivileges.put(objectID, objectType);
        }
    }

    @Override
    public void addRequiredSchemaPriv(String schemaName, String aid, int privType) {
        if (this.requiredSchemaPrivileges == null || schemaName == null) {
            return;
        }
        StatementSchemaPermission key = new StatementSchemaPermission(schemaName, aid, privType);
        this.requiredSchemaPrivileges.put(key, key);
    }

    @Override
    public void addRequiredRolePriv(String roleName, int privType) {
        if (this.requiredRolePrivileges == null) {
            return;
        }
        StatementRolePermission key = new StatementRolePermission(roleName, privType);
        this.requiredRolePrivileges.put(key, key);
    }

    @Override
    public List<StatementPermission> getRequiredPermissionsList() {
        Iterator<Object> itr;
        int size = 0;
        if (this.requiredRoutinePrivileges != null) {
            size += this.requiredRoutinePrivileges.size();
        }
        if (this.requiredUsagePrivileges != null) {
            size += this.requiredUsagePrivileges.size();
        }
        if (this.requiredTablePrivileges != null) {
            size += this.requiredTablePrivileges.size();
        }
        if (this.requiredSchemaPrivileges != null) {
            size += this.requiredSchemaPrivileges.size();
        }
        if (this.requiredColumnPrivileges != null) {
            size += this.requiredColumnPrivileges.size();
        }
        if (this.requiredRolePrivileges != null) {
            size += this.requiredRolePrivileges.size();
        }
        ArrayList<StatementPermission> list = new ArrayList<StatementPermission>(size);
        if (this.requiredRoutinePrivileges != null) {
            for (UUID routineUUID : this.requiredRoutinePrivileges.keySet()) {
                list.add(new StatementRoutinePermission(routineUUID));
            }
        }
        if (this.requiredUsagePrivileges != null) {
            for (UUID objectID : this.requiredUsagePrivileges.keySet()) {
                list.add(new StatementGenericPermission(objectID, this.requiredUsagePrivileges.get(objectID), "USAGE"));
            }
        }
        if (this.requiredTablePrivileges != null) {
            itr = this.requiredTablePrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add((StatementPermission)itr.next());
            }
        }
        if (this.requiredSchemaPrivileges != null) {
            itr = this.requiredSchemaPrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add((StatementPermission)itr.next());
            }
        }
        if (this.requiredColumnPrivileges != null) {
            itr = this.requiredColumnPrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add((StatementPermission)itr.next());
            }
        }
        if (this.requiredRolePrivileges != null) {
            itr = this.requiredRolePrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add((StatementPermission)itr.next());
            }
        }
        return list;
    }

    @Override
    public void addReferencedSequence(SequenceDescriptor sd) {
        if (this.referencedSequences == null) {
            this.referencedSequences = new HashMap();
        }
        this.referencedSequences.put(sd.getUUID(), sd);
    }

    @Override
    public boolean isReferenced(SequenceDescriptor sd) {
        if (this.referencedSequences == null) {
            return false;
        }
        return this.referencedSequences.containsKey(sd.getUUID());
    }

    @Override
    public void addPrivilegeFilter(VisitableFilter vf) {
        if (this.privilegeCheckFilters == null) {
            this.privilegeCheckFilters = new ArrayList();
        }
        this.privilegeCheckFilters.add(vf);
    }

    @Override
    public void removePrivilegeFilter(VisitableFilter vf) {
        if (vf != null && this.privilegeCheckFilters != null) {
            this.privilegeCheckFilters.remove(vf);
        }
    }

    @Override
    public boolean passesPrivilegeFilters(Visitable visitable) throws StandardException {
        if (this.privilegeCheckFilters == null) {
            return true;
        }
        for (VisitableFilter filter : this.privilegeCheckFilters) {
            if (filter.accept(visitable)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void beginScope(String scopeName) {
        int[] scopeDepth;
        if (this.namedScopes == null) {
            this.namedScopes = new HashMap();
        }
        if ((scopeDepth = this.namedScopes.get(scopeName)) == null) {
            scopeDepth = new int[1];
            this.namedScopes.put(scopeName, scopeDepth);
        }
        scopeDepth[0] = scopeDepth[0] + 1;
    }

    @Override
    public void endScope(String scopeName) {
        if (this.namedScopes == null) {
            return;
        }
        int[] scopeDepth = this.namedScopes.get(scopeName);
        if (scopeDepth == null) {
            return;
        }
        scopeDepth[0] = scopeDepth[0] - 1;
        if (scopeDepth[0] <= 0) {
            this.namedScopes.remove(scopeName);
        }
    }

    @Override
    public int scopeDepth(String scopeName) {
        if (this.namedScopes == null) {
            return 0;
        }
        int[] scopeDepth = this.namedScopes.get(scopeName);
        if (scopeDepth == null) {
            return 0;
        }
        return scopeDepth[0];
    }

    @Override
    public boolean skipTypePrivileges(boolean skip) {
        boolean oldValue = this.skippingTypePrivileges;
        this.skippingTypePrivileges = skip;
        return oldValue;
    }

    @Override
    public boolean skippingTypePrivileges() {
        return this.skippingTypePrivileges;
    }
}

