/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.io.File;
import java.io.FileInputStream;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CacheManagerMBeanTest
extends MBeanTest {
    private static final int DEFAULT_PAGE_CACHE_SIZE = 1000;
    private static final int DEFAULT_CONTAINER_CACHE_SIZE = 100;
    private static final int DEFAULT_STATEMENT_CACHE_SIZE = 100;
    private static final String JAVA_HOME = "java.home";
    private static final String CONF_DIR = "conf";
    private static final String MANAGEMENT_DIR = "management";
    private static final String MANAGEMENT_PROPERTIES_FILE = "management.properties";
    private static final String DESERIALIZATION_FILTER_PROP = "com.sun.management.jmxremote.serial.filter.pattern";
    private static final String DERBY_FILTER_VALUE = "*";
    private static String[] ALL_ATTRIBUTES = new String[]{"CollectAccessCounts", "HitCount", "MissCount", "EvictionCount", "MaxEntries", "AllocatedEntries", "UsedEntries"};

    public CacheManagerMBeanTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite();
        suite.addTest(MBeanTest.suite(CacheManagerMBeanTest.class, "CacheManagerMBeanTest"));
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().close();
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    private boolean remoteDeserializationEnabled() throws Exception {
        File javaHomeDir = new File(System.getProperty(JAVA_HOME));
        File jmxManagementDir = new File(new File(javaHomeDir, CONF_DIR), MANAGEMENT_DIR);
        File managementPropertiesFile = new File(jmxManagementDir, MANAGEMENT_PROPERTIES_FILE);
        Properties originalManagementProperties = new Properties();
        try (FileInputStream fis = new FileInputStream(managementPropertiesFile);){
            originalManagementProperties.load(fis);
        }
        String filterValue = originalManagementProperties.getProperty(DESERIALIZATION_FILTER_PROP);
        return DERBY_FILTER_VALUE.equals(filterValue);
    }

    private ObjectName createObjectName(String cacheName, String dbName) throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("type", "CacheManager");
        props.put("name", cacheName == null ? DERBY_FILTER_VALUE : cacheName);
        props.put("db", dbName == null ? DERBY_FILTER_VALUE : ObjectName.quote(dbName));
        return this.getDerbyMBeanName(props);
    }

    public void testAllMBeansStartedAndStopped() throws Exception {
        ObjectName pattern = this.createObjectName(null, null);
        Set<ObjectName> names = this.queryMBeans(pattern);
        if (!names.isEmpty()) {
            CacheManagerMBeanTest.fail((String)("Should not find MBeans before boot, found: " + String.valueOf(names)));
        }
        this.getConnection();
        names = this.queryMBeans(pattern);
        CacheManagerMBeanTest.assertEquals((String)("Incorrect number of MBeans found in " + String.valueOf(names)), (int)3, (int)names.size());
        TestConfiguration.getCurrent().shutdownDatabase();
        names = this.queryMBeans(pattern);
        if (!names.isEmpty()) {
            CacheManagerMBeanTest.fail((String)("Should not find MBeans after shutdown, found: " + String.valueOf(names)));
        }
    }

    public void testPageCache() throws Exception {
        this.getConnection();
        Set<ObjectName> names = this.queryMBeans(this.createObjectName("PageCache", null));
        CacheManagerMBeanTest.assertEquals((String)"Should have a single page cache", (int)1, (int)names.size());
        ObjectName name = names.iterator().next();
        this.assertBooleanAttribute(false, name, "CollectAccessCounts");
        this.assertLongAttribute(0, name, "HitCount");
        this.assertLongAttribute(0, name, "MissCount");
        this.assertLongAttribute(0, name, "EvictionCount");
        this.assertLongAttribute(1000, name, "MaxEntries");
        Long allocated = (Long)this.getAttribute(name, "AllocatedEntries");
        CacheManagerMBeanTest.assertTrue((String)("Allocated entries: " + allocated), (allocated > 0L ? 1 : 0) != 0);
        Long used = (Long)this.getAttribute(name, "UsedEntries");
        CacheManagerMBeanTest.assertTrue((String)("Used entries: " + used), (used > 0L ? 1 : 0) != 0);
        PreparedStatement ps = this.prepareStatement("select * from sysibm.sysdummy1");
        JDBC.assertDrainResults(ps.executeQuery());
        this.assertLongAttribute(0, name, "HitCount");
        this.assertLongAttribute(0, name, "MissCount");
        this.assertLongAttribute(0, name, "EvictionCount");
        this.setAttribute(name, "CollectAccessCounts", Boolean.TRUE);
        this.assertBooleanAttribute(true, name, "CollectAccessCounts");
        JDBC.assertDrainResults(ps.executeQuery());
        this.assertLongAttribute(1, name, "HitCount");
        this.assertLongAttribute(0, name, "MissCount");
        this.setAttribute(name, "CollectAccessCounts", Boolean.FALSE);
        this.assertBooleanAttribute(false, name, "CollectAccessCounts");
    }

    public void testContainerCache() throws Exception {
        this.getConnection();
        Set<ObjectName> names = this.queryMBeans(this.createObjectName("ContainerCache", null));
        CacheManagerMBeanTest.assertEquals((String)"Should have a single container cache", (int)1, (int)names.size());
        ObjectName name = names.iterator().next();
        this.assertBooleanAttribute(false, name, "CollectAccessCounts");
        this.assertLongAttribute(0, name, "HitCount");
        this.assertLongAttribute(0, name, "MissCount");
        this.assertLongAttribute(0, name, "EvictionCount");
        this.assertLongAttribute(100, name, "MaxEntries");
        Long allocated = (Long)this.getAttribute(name, "AllocatedEntries");
        CacheManagerMBeanTest.assertTrue((String)("Allocated entries: " + allocated), (allocated > 0L ? 1 : 0) != 0);
        Long used = (Long)this.getAttribute(name, "UsedEntries");
        CacheManagerMBeanTest.assertTrue((String)("Used entries: " + used), (used > 0L ? 1 : 0) != 0);
    }

    public void testStatementCache() throws Exception {
        this.getConnection();
        Set<ObjectName> names = this.queryMBeans(this.createObjectName("StatementCache", null));
        CacheManagerMBeanTest.assertEquals((String)"Should have a single statement cache", (int)1, (int)names.size());
        ObjectName name = names.iterator().next();
        this.assertBooleanAttribute(false, name, "CollectAccessCounts");
        this.assertLongAttribute(0, name, "HitCount");
        this.assertLongAttribute(0, name, "MissCount");
        this.assertLongAttribute(0, name, "EvictionCount");
        this.assertLongAttribute(100, name, "MaxEntries");
        this.assertLongAttribute(0, name, "AllocatedEntries");
        this.assertLongAttribute(0, name, "UsedEntries");
        this.prepareStatement("values 1").close();
        this.assertLongAttribute(1, name, "AllocatedEntries");
        this.assertLongAttribute(1, name, "UsedEntries");
        this.prepareStatement("values 2").close();
        this.assertLongAttribute(2, name, "AllocatedEntries");
        this.assertLongAttribute(2, name, "UsedEntries");
        Statement s = this.createStatement();
        s.execute("call syscs_util.syscs_empty_statement_cache()");
        this.assertLongAttribute(3, name, "AllocatedEntries");
        this.assertLongAttribute(0, name, "UsedEntries");
        this.assertLongAttribute(0, name, "HitCount");
        this.assertLongAttribute(0, name, "MissCount");
        this.assertLongAttribute(0, name, "EvictionCount");
        this.setAttribute(name, "CollectAccessCounts", Boolean.TRUE);
        this.assertBooleanAttribute(true, name, "CollectAccessCounts");
        this.prepareStatement("values 1").close();
        this.assertLongAttribute(0, name, "HitCount");
        this.assertLongAttribute(1, name, "MissCount");
        this.assertLongAttribute(0, name, "EvictionCount");
        this.prepareStatement("values 2").close();
        this.assertLongAttribute(0, name, "HitCount");
        this.assertLongAttribute(2, name, "MissCount");
        this.assertLongAttribute(0, name, "EvictionCount");
        this.prepareStatement("values 1").close();
        this.assertLongAttribute(1, name, "HitCount");
        this.assertLongAttribute(2, name, "MissCount");
        this.assertLongAttribute(0, name, "EvictionCount");
        for (int i = 0; i < 200; ++i) {
            this.prepareStatement("values 1, " + i).close();
        }
        this.assertLongAttribute(1, name, "HitCount");
        this.assertLongAttribute(202, name, "MissCount");
        this.assertLongAttribute(102, name, "EvictionCount");
        this.assertLongAttribute(100, name, "MaxEntries");
        this.assertLongAttribute(100, name, "AllocatedEntries");
        this.assertLongAttribute(100, name, "UsedEntries");
        this.setAttribute(name, "CollectAccessCounts", Boolean.FALSE);
        this.assertBooleanAttribute(false, name, "CollectAccessCounts");
    }

    public void withPermsTest() throws Exception {
        this.getConnection();
        Set<ObjectName> names = this.queryMBeans(this.createObjectName("StatementCache", null));
        CacheManagerMBeanTest.assertEquals((String)"Should have a single statement cache", (int)1, (int)names.size());
        ObjectName name = names.iterator().next();
        for (String attrName : ALL_ATTRIBUTES) {
            this.getAttribute(name, attrName);
        }
        this.setAttribute(name, "CollectAccessCounts", Boolean.FALSE);
    }
}

