/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.shared.common.error.StandardException;

public class PermDescriptor
extends PermissionsDescriptor
implements Provider {
    public static final String SEQUENCE_TYPE = "SEQUENCE";
    public static final String UDT_TYPE = "TYPE";
    public static final String AGGREGATE_TYPE = "DERBY AGGREGATE";
    public static final String USAGE_PRIV = "USAGE";
    private String objectType;
    private UUID permObjectId;
    private String permission;
    private boolean grantable;

    public PermDescriptor(DataDictionary dataDictionary, UUID permUUID, String objectType, UUID permObjectId, String permission, String grantor, String grantee, boolean isGrantable) {
        super(dataDictionary, grantee, grantor);
        this.setUUID(permUUID);
        this.objectType = objectType;
        this.permObjectId = permObjectId;
        this.permission = permission;
        this.grantable = isGrantable;
    }

    public PermDescriptor(DataDictionary dd, UUID permUUID) throws StandardException {
        this(dd, permUUID, null, null, null, null, null, false);
    }

    public String getObjectType() {
        return this.objectType;
    }

    public UUID getPermObjectId() {
        return this.permObjectId;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isGrantable() {
        return this.grantable;
    }

    @Override
    public int getCatalogNumber() {
        return 21;
    }

    public String toString() {
        return "permUUID: " + String.valueOf(this.oid) + "\nobjectType: " + this.objectType + "\npermObjectId: " + String.valueOf(this.permObjectId) + "\npermission: " + this.permission + "\ngrantable: " + this.grantable + "\n";
    }

    public boolean equals(Object other) {
        if (!(other instanceof PermDescriptor)) {
            return false;
        }
        PermDescriptor otherPerm = (PermDescriptor)other;
        return super.keyEquals(otherPerm) && this.permObjectId.equals(otherPerm.permObjectId);
    }

    public int hashCode() {
        return super.keyHashCode() + this.permObjectId.hashCode();
    }

    @Override
    public boolean checkOwner(String authorizationId) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        PrivilegedSQLObject pso = PermDescriptor.getProtectedObject(dd, this.permObjectId, this.objectType);
        return pso.getSchemaDescriptor().getAuthorizationId().equals(authorizationId);
    }

    public static PrivilegedSQLObject getProtectedObject(DataDictionary dd, UUID objectID, String objectType) throws StandardException {
        if (SEQUENCE_TYPE.equals(objectType)) {
            return dd.getSequenceDescriptor(objectID);
        }
        if (AGGREGATE_TYPE.equals(objectType)) {
            return dd.getAliasDescriptor(objectID);
        }
        if (UDT_TYPE.equals(objectType)) {
            return dd.getAliasDescriptor(objectID);
        }
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public String getObjectName() {
        try {
            DataDictionary dd = this.getDataDictionary();
            PrivilegedSQLObject pso = PermDescriptor.getProtectedObject(dd, this.permObjectId, this.objectType);
            return pso.getName();
        }
        catch (StandardException se) {
            return this.objectType;
        }
    }

    @Override
    public String getClassType() {
        return "Perm";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(473);
    }
}

