/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.Test;
import org.apache.derby.impl.io.vfmem.DataStore;
import org.apache.derby.impl.io.vfmem.VirtualFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.unitTests.junit.PathUtilTest;

public class VirtualFileTest
extends BaseTestCase {
    private final String[] NON_EXISTING_DIRS = new String[]{"this", "dir", "does", "not", "exist"};
    private static int dbStoreIndex = 0;

    public VirtualFileTest(String string) {
        super(string);
    }

    public void testCreateFileInRoot() {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile("service.properties", dataStore);
        VirtualFileTest.assertFalse((boolean)new VirtualFile("service.properties", dataStore).exists());
        VirtualFileTest.assertFalse((boolean)virtualFile.exists());
    }

    public void testCreateDirInRoot() {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile("seg0", dataStore);
        VirtualFileTest.assertFalse((boolean)virtualFile.exists());
        virtualFile.mkdir();
        VirtualFileTest.assertTrue((boolean)virtualFile.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile.isDirectory());
    }

    public void testCreateInvalidDir() {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile(PathUtilTest.join(this.NON_EXISTING_DIRS), dataStore);
        VirtualFileTest.assertFalse((boolean)virtualFile.exists());
        VirtualFile virtualFile2 = new VirtualFile("", dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile2.mkdir());
        VirtualFileTest.assertFalse((String)"Dir creation should have failed", (boolean)virtualFile.mkdir());
    }

    public void testMkdirsValidRelative() {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile(PathUtilTest.join(this.NON_EXISTING_DIRS), dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.mkdirs());
    }

    public void testMkdirsValidAbsolute() {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile(PathUtilTest.joinAbs(this.NON_EXISTING_DIRS), dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.mkdirs());
    }

    public void testMkdirsInvalidAbsolute() throws IOException {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile(PathUtilTest.abs("directory"), dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.mkdir());
        virtualFile = new VirtualFile(PathUtilTest.joinAbs("directory", "afile"), dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.createNewFile());
        VirtualFileTest.assertTrue((boolean)virtualFile.exists());
        VirtualFileTest.assertFalse((boolean)virtualFile.isDirectory());
        VirtualFile virtualFile2 = new VirtualFile(PathUtilTest.joinAbs("directory", "afile", "anotherdir"), dataStore);
        VirtualFileTest.assertFalse((boolean)virtualFile2.mkdir());
        VirtualFileTest.assertFalse((boolean)virtualFile2.mkdirs());
    }

    public void testMkdirsInvalidRelative() throws IOException {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile("seg0", dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.mkdir());
        virtualFile = new VirtualFile(PathUtilTest.join("seg0", "datafile"), dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.createNewFile());
        VirtualFileTest.assertTrue((boolean)virtualFile.exists());
        VirtualFileTest.assertFalse((boolean)virtualFile.isDirectory());
        VirtualFile virtualFile2 = new VirtualFile(PathUtilTest.join("seg0", "datafile", "anotherdir"), dataStore);
        VirtualFileTest.assertFalse((boolean)virtualFile2.mkdir());
        VirtualFileTest.assertFalse((boolean)virtualFile2.mkdirs());
    }

    public void testGetParentRelative() {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile(PathUtilTest.join(this.NON_EXISTING_DIRS), dataStore);
        int n = 0;
        for (StorageFile storageFile = virtualFile.getParentDir(); storageFile != null; storageFile = storageFile.getParentDir()) {
            ++n;
        }
        VirtualFileTest.assertEquals((int)4, (int)n);
    }

    public void testGetParentAbsolute() {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile(PathUtilTest.joinAbs(this.NON_EXISTING_DIRS), dataStore);
        int n = 0;
        for (StorageFile storageFile = virtualFile.getParentDir(); storageFile != null; storageFile = storageFile.getParentDir()) {
            ++n;
        }
        VirtualFileTest.assertEquals((int)5, (int)n);
    }

    public void testDeleteAll() throws IOException {
        int n;
        DataStore dataStore = VirtualFileTest.getStore();
        String[] stringArray = new String[]{"seg0", PathUtilTest.join("seg0", "dir1"), "seg1", PathUtilTest.join("seg0", "dir2")};
        for (int i = 0; i < stringArray.length; ++i) {
            VirtualFileTest.assertTrue((boolean)new VirtualFile(stringArray[i], dataStore).mkdir());
        }
        String[] stringArray2 = new String[]{PathUtilTest.join("seg0", "f1"), PathUtilTest.join("seg0", "dir1", "f1"), PathUtilTest.join("seg1", "f1"), PathUtilTest.join("seg0", "f5")};
        for (int i = 0; i < stringArray2.length; ++i) {
            VirtualFileTest.assertTrue((boolean)new VirtualFile(stringArray2[i], dataStore).createNewFile());
        }
        String string = "seg0";
        VirtualFile virtualFile = new VirtualFile(string, dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.deleteAll());
        for (n = 0; n < stringArray.length; ++n) {
            VirtualFileTest.assertEquals((!stringArray[n].startsWith(string) ? 1 : 0) != 0, (boolean)new VirtualFile(stringArray[n], dataStore).exists());
        }
        for (n = 0; n < stringArray2.length; ++n) {
            VirtualFileTest.assertEquals((!stringArray2[n].startsWith(string) ? 1 : 0) != 0, (boolean)new VirtualFile(stringArray2[n], dataStore).exists());
        }
    }

    public void testRenameToSimple() {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile("originalFile", dataStore);
        VirtualFileTest.assertFalse((boolean)virtualFile.canWrite());
        virtualFile.createNewFile();
        VirtualFileTest.assertTrue((boolean)virtualFile.canWrite());
        VirtualFile virtualFile2 = new VirtualFile("newFile", dataStore);
        VirtualFileTest.assertFalse((boolean)virtualFile2.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile.renameTo((StorageFile)virtualFile2));
        VirtualFileTest.assertFalse((boolean)virtualFile.exists());
        VirtualFileTest.assertFalse((boolean)virtualFile.canWrite());
        VirtualFileTest.assertTrue((boolean)virtualFile2.exists());
    }

    public void testGetRAFNonExisting() throws FileNotFoundException {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile("aNewFile.txt", dataStore);
        VirtualFileTest.assertFalse((boolean)virtualFile.exists());
        StorageRandomAccessFile storageRandomAccessFile = virtualFile.getRandomAccessFile("rw");
        VirtualFileTest.assertNotNull((Object)storageRandomAccessFile);
        VirtualFileTest.assertTrue((boolean)virtualFile.exists());
    }

    public void testGetRAFNonExistingReadMode() throws FileNotFoundException {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile("aNewFile.txt", dataStore);
        VirtualFileTest.assertFalse((boolean)virtualFile.exists());
        try {
            virtualFile.getRandomAccessFile("r");
            VirtualFileTest.fail((String)"Cannot read from a non-exsiting file");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        VirtualFileTest.assertFalse((boolean)virtualFile.exists());
    }

    public void testGetRAExistingReadOnly() throws FileNotFoundException {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile("aNewFile.txt", dataStore);
        VirtualFileTest.assertFalse((boolean)virtualFile.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile.createNewFile());
        VirtualFileTest.assertTrue((boolean)virtualFile.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile.setReadOnly());
        VirtualFileTest.assertNotNull((Object)virtualFile.getRandomAccessFile("r"));
        try {
            virtualFile.getRandomAccessFile("rw");
            VirtualFileTest.fail((String)"Should not be able to open a read-only file in write mode");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testGetRAFOnDirectory() {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile("mydir", dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.mkdir());
        VirtualFileTest.assertTrue((boolean)virtualFile.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile.isDirectory());
        try {
            virtualFile.getRandomAccessFile("r");
            VirtualFileTest.fail((String)"Opening a RAF on a directory should have failed");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            virtualFile.getRandomAccessFile("r");
            VirtualFileTest.fail((String)"Opening a RAF on a directory should have failed");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        VirtualFileTest.assertTrue((boolean)virtualFile.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile.isDirectory());
    }

    public void testListChilderen() {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile(PathUtilTest.abs("mydir"), dataStore);
        VirtualFile virtualFile2 = new VirtualFile(PathUtilTest.abs("mydirectory"), dataStore);
        VirtualFile virtualFile3 = new VirtualFile(PathUtilTest.joinAbs("mydir", "file1.txt"), dataStore);
        VirtualFile virtualFile4 = new VirtualFile(PathUtilTest.joinAbs("mydirectory", "file2.txt"), dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.mkdirs());
        VirtualFileTest.assertTrue((boolean)virtualFile.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile.isDirectory());
        VirtualFileTest.assertTrue((boolean)virtualFile2.mkdirs());
        VirtualFileTest.assertTrue((boolean)virtualFile2.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile2.isDirectory());
        VirtualFileTest.assertTrue((boolean)virtualFile3.createNewFile());
        VirtualFileTest.assertTrue((boolean)virtualFile3.exists());
        VirtualFileTest.assertFalse((boolean)virtualFile3.isDirectory());
        VirtualFileTest.assertTrue((boolean)virtualFile4.createNewFile());
        VirtualFileTest.assertTrue((boolean)virtualFile4.exists());
        VirtualFileTest.assertFalse((boolean)virtualFile4.isDirectory());
        String[] stringArray = virtualFile.list();
        VirtualFileTest.assertEquals((int)1, (int)stringArray.length);
        VirtualFileTest.assertEquals((String)virtualFile3.getName(), (String)stringArray[0]);
        VirtualFile virtualFile5 = new VirtualFile(PathUtilTest.joinAbs("mydir", ""), dataStore);
        VirtualFileTest.assertFalse((boolean)virtualFile.getName().equals(virtualFile5.getName()));
        String[] stringArray2 = virtualFile5.list();
        VirtualFileTest.assertEquals((int)1, (int)stringArray2.length);
        VirtualFileTest.assertEquals((String)stringArray[0], (String)stringArray2[0]);
        VirtualFileTest.assertFalse((boolean)virtualFile.delete());
        VirtualFileTest.assertTrue((boolean)virtualFile.deleteAll());
        VirtualFileTest.assertTrue((boolean)virtualFile2.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile4.exists());
    }

    public void testCreateRoot() {
        DataStore dataStore = new DataStore("testCreateRootStore");
        String string = PathUtilTest.joinAbs("these", "are", "directories");
        VirtualFileTest.assertTrue((boolean)dataStore.createAllParents(string));
        VirtualFileTest.assertNotNull((Object)dataStore.createEntry(string, true));
        VirtualFile virtualFile = new VirtualFile(string, dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile.isDirectory());
        string = PathUtilTest.join("c:", "Documents and Settings", "directories");
        VirtualFileTest.assertTrue((boolean)dataStore.createAllParents(string));
        VirtualFileTest.assertNotNull((Object)dataStore.createEntry(string, true));
        virtualFile = new VirtualFile(string, dataStore);
        VirtualFileTest.assertTrue((boolean)virtualFile.exists());
        VirtualFileTest.assertTrue((boolean)virtualFile.isDirectory());
    }

    public void testCloseIdempotent() throws IOException {
        DataStore dataStore = VirtualFileTest.getStore();
        VirtualFile virtualFile = new VirtualFile("afile", dataStore);
        StorageRandomAccessFile storageRandomAccessFile = virtualFile.getRandomAccessFile("rw");
        storageRandomAccessFile.close();
        storageRandomAccessFile.close();
    }

    public static Test suite() {
        return new BaseTestSuite(VirtualFileTest.class);
    }

    private static synchronized DataStore getStore() {
        DataStore dataStore = new DataStore("testVFMemDB-" + dbStoreIndex++);
        VirtualFileTest.assertNotNull((Object)dataStore.createEntry(File.separator, true));
        return dataStore;
    }
}

